/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.ModuleException;
import com.griefcraft.util.Statistics;
import com.griefcraft.util.config.Configuration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class Database {
    public Type currentType;
    private Map<String, PreparedStatement> statementCache = new HashMap<String, PreparedStatement>();
    protected Connection connection = null;
    public static Type DefaultType = Type.NONE;
    private boolean connected = false;
    protected boolean loaded = false;
    protected String prefix = "";
    private boolean useStatementCache = true;

    public Database() {
        this.currentType = DefaultType;
        this.prefix = LWC.getInstance().getConfiguration().getString("database.prefix", "");
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    public Database(Type currentType) {
        this();
        this.currentType = currentType;
    }

    public void pingDatabase() {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.executeQuery("SELECT 1;");
            stmt.close();
        }
        catch (SQLException e) {
            this.log("Keepalive packet (ping) failed!");
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public boolean setAutoCommit(boolean autoCommit) {
        try {
            if (autoCommit) {
                this.connection.commit();
            }
            this.connection.setAutoCommit(autoCommit);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected void printException(Exception exception) {
        throw new ModuleException(exception);
    }

    public boolean connect() throws Exception {
        if (this.connection != null) {
            return true;
        }
        if (this.currentType == null || this.currentType == Type.NONE) {
            this.log("Invalid database engine");
            return false;
        }
        if (this.currentType == Type.MySQL) {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException ignored) {
                Class.forName("com.mysql.jdbc.Driver");
            }
        } else {
            Class.forName("org.sqlite.JDBC");
        }
        Properties properties = new Properties();
        if (this.currentType == Type.MySQL) {
            LWC lwc = LWC.getInstance();
            properties.put("autoReconnect", "true");
            properties.put("user", lwc.getConfiguration().getString("database.username"));
            properties.put("password", lwc.getConfiguration().getString("database.password"));
        }
        this.statementCache.clear();
        try {
            this.connection = DriverManager.getConnection("jdbc:" + this.currentType.toString().toLowerCase() + ":" + this.getDatabasePath(), properties);
            this.connected = true;
            return true;
        }
        catch (SQLException e) {
            this.log("Failed to connect to " + (Object)((Object)this.currentType) + ": " + e.getErrorCode() + " - " + e.getMessage());
            if (e.getCause() != null) {
                this.log("Connection failure cause: " + e.getCause().getMessage());
            }
            return false;
        }
    }

    public void dispose() {
        this.statementCache.clear();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDatabasePath() {
        Configuration lwcConfiguration = LWC.getInstance().getConfiguration();
        if (this.currentType == Type.MySQL) {
            return "//" + lwcConfiguration.getString("database.host") + "/" + lwcConfiguration.getString("database.database");
        }
        return lwcConfiguration.getString("database.path");
    }

    public Type getType() {
        return this.currentType;
    }

    public abstract void load();

    public void log(String str) {
        LWC.getInstance().log(str);
    }

    public PreparedStatement prepare(String sql) {
        return this.prepare(sql, false);
    }

    public PreparedStatement prepare(String sql, boolean returnGeneratedKeys) {
        if (this.connection == null) {
            return null;
        }
        if (this.useStatementCache && this.statementCache.containsKey(sql)) {
            Statistics.addQuery();
            return this.statementCache.get(sql);
        }
        try {
            PreparedStatement preparedStatement = returnGeneratedKeys ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
            this.statementCache.put(sql, preparedStatement);
            Statistics.addQuery();
            return preparedStatement;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean addColumn(String table, String column, String type) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " ADD " + column + " " + type);
    }

    public boolean dropColumn(String table, String column) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " DROP COLUMN " + column);
    }

    public boolean renameTable(String table, String newName) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " RENAME TO " + newName);
    }

    public boolean dropTable(String table) {
        return this.executeUpdateNoException("DROP TABLE " + table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeUpdateNoException(String query) {
        Statement statement = null;
        boolean exception = false;
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            exception = true;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return exception;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean useStatementCache() {
        return this.useStatementCache;
    }

    public void setUseStatementCache(boolean useStatementCache) {
        this.useStatementCache = useStatementCache;
    }

    public static enum Type {
        MySQL,
        SQLite,
        NONE;


        public static Type matchType(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(str)) continue;
                return type;
            }
            return null;
        }
    }
}

