/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.util.matchers.DoorMatcher;
import com.griefcraft.util.matchers.DoubleChestMatcher;
import com.griefcraft.util.matchers.GravityMatcher;
import com.griefcraft.util.matchers.WallMatcher;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;

public class ProtectionFinder {
    private LWC lwc;
    private BlockState baseBlock = null;
    private Protection matchedProtection = null;
    private boolean searched = false;
    private final List<BlockState> blocks = new LinkedList<BlockState>();
    private final List<BlockState> protectables = new LinkedList<BlockState>();

    public ProtectionFinder(LWC lwc) {
        this.lwc = lwc;
    }

    public boolean matchBlocks(Block baseBlock) {
        return this.matchBlocks(baseBlock.getState());
    }

    public boolean matchBlocks(BlockState baseBlock) {
        if (this.matchedProtection != null) {
            return true;
        }
        this.reset();
        this.baseBlock = baseBlock;
        this.addBlock(baseBlock);
        Result result = this.tryLoadProtection(baseBlock, false);
        if (result != Result.E_NOT_FOUND) {
            return result == Result.E_FOUND;
        }
        for (Matcher matcher : this.getProtectionMatchers()) {
            boolean matches = matcher.matches(this);
            if (!matches) continue;
            return true;
        }
        this.searched = true;
        return false;
    }

    public void fullMatchBlocks() {
        this.blocks.clear();
        this.addBlock(this.baseBlock);
        for (Matcher matcher : this.getProtectionMatchers()) {
            if (matcher.matches(this)) break;
        }
    }

    public Matcher[] getProtectionMatchers() {
        BlockData data = this.baseBlock.getBlockData();
        Material material = data.getMaterial();
        if (material == Material.HOPPER || material == Material.BARREL || material.name().endsWith("SHULKER_BOX")) {
            return new Matcher[0];
        }
        if (data instanceof Chest) {
            if (((Chest)data).getType() != Chest.Type.SINGLE) {
                return new Matcher[]{new DoubleChestMatcher()};
            }
            return new Matcher[0];
        }
        if (GravityMatcher.PROTECTABLES_POSTS.contains(material)) {
            return new Matcher[]{new GravityMatcher()};
        }
        if (DoorMatcher.PROTECTABLES_DOORS.contains(material)) {
            return new Matcher[]{new DoorMatcher()};
        }
        return new Matcher[]{new DoorMatcher(), new GravityMatcher(), new WallMatcher()};
    }

    public void addBlock(Block block) {
        if (block != null) {
            this.addBlock(block.getState());
        }
    }

    public void addBlock(BlockState block) {
        if (block != null && !this.blocks.contains(block)) {
            this.blocks.add(block);
        }
    }

    public Protection loadProtection() {
        return this.loadProtection(false);
    }

    public Protection loadProtection(boolean noAutoCache) {
        if (this.searched) {
            return this.matchedProtection;
        }
        this.calculateProtectables();
        this.searched = true;
        for (BlockState block : this.protectables) {
            if (this.tryLoadProtection(block, noAutoCache) != Result.E_FOUND) continue;
            return this.matchedProtection;
        }
        return null;
    }

    protected Result tryLoadProtection(BlockState block, boolean noAutoCache) {
        if (this.matchedProtection != null) {
            return Result.E_FOUND;
        }
        LWC lwc = LWC.getInstance();
        ProtectionCache cache = lwc.getProtectionCache();
        this.matchedProtection = cache.getProtection(block);
        if (this.matchedProtection != null) {
            this.searched = true;
            if (this.matchedProtection.getProtectionFinder() == null) {
                this.fullMatchBlocks();
                this.matchedProtection.setProtectionFinder(this);
                cache.addProtection(this.matchedProtection);
            }
            return Result.E_FOUND;
        }
        if (block.getType() == Material.REDSTONE_WIRE || block.getType() == Material.REDSTONE_TORCH || block.getType() == Material.REDSTONE_WALL_TORCH) {
            return Result.E_ABORT;
        }
        if (!lwc.isProtectable(block)) {
            return Result.E_NOT_FOUND;
        }
        if (block.getWorld() == null) {
            lwc.log("World is null for the block " + block);
            return Result.E_NOT_FOUND;
        }
        Protection protection = lwc.getPhysicalDatabase().loadProtection(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
        if (protection != null) {
            if (protection.getProtectionFinder() == null) {
                protection.setProtectionFinder(this);
                this.fullMatchBlocks();
                cache.addProtection(this.matchedProtection);
            }
            if (protection.getBlockId() > 0) {
                if (protection.isBlockInWorld()) {
                    if (noAutoCache) {
                        return Result.E_FOUND;
                    }
                    this.matchedProtection = protection;
                    this.searched = true;
                } else {
                    lwc.log("Removing corrupted protection: " + protection);
                    protection.remove();
                }
            }
        }
        return this.matchedProtection != null ? Result.E_FOUND : Result.E_NOT_FOUND;
    }

    public BlockState getBaseBlock() {
        return this.baseBlock;
    }

    public List<BlockState> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public void removeBlock(BlockState block) {
        Iterator<BlockState> iter = this.blocks.iterator();
        while (iter.hasNext()) {
            if (!this.lwc.blockEquals(block, iter.next())) continue;
            iter.remove();
        }
    }

    private void reset() {
        this.blocks.clear();
        this.protectables.clear();
        this.baseBlock = null;
        this.searched = false;
    }

    private void calculateProtectables() {
        this.protectables.clear();
        this.searched = false;
        int size = this.blocks.size();
        if (size == 1) {
            return;
        }
        for (int index = 1; index < size; ++index) {
            BlockState state = this.blocks.get(index);
            if (!this.lwc.isProtectable(state)) continue;
            this.protectables.add(state);
        }
    }

    private static enum Result {
        E_FOUND,
        E_ABORT,
        E_NOT_FOUND;

    }

    public static interface Matcher {
        public boolean matches(ProtectionFinder var1);
    }
}

