/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.command.CommandSender;

public class AdminQuery
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!(args[0].equals("query") || args[0].equals("updateprotections") || args[0].equals("deleteprotections") || args[0].equals("selectprotections"))) {
            return;
        }
        event.setCancelled(true);
        if (args[0].equals("query")) {
            String query = StringUtil.join(args, 1);
            try {
                Statement statement = lwc.getPhysicalDatabase().getConnection().createStatement();
                statement.executeUpdate(query);
                statement.close();
                sender.sendMessage("\u00a72Done.");
            }
            catch (SQLException e) {
                sender.sendMessage("\u00a74Err: " + e.getMessage());
            }
        } else {
            String where = StringUtil.join(args, 1);
            if (where.isEmpty()) {
                sender.sendMessage("\u00a74Unsafe query detected.");
                return;
            }
            try {
                PhysDB database = lwc.getPhysicalDatabase();
                Statement statement = database.getConnection().createStatement();
                if (args[0].startsWith("update")) {
                    int affected = statement.executeUpdate("UPDATE " + database.getPrefix() + "protections " + where);
                    sender.sendMessage("\u00a72Affected rows: " + affected);
                } else if (args[0].startsWith("delete")) {
                    int affected = statement.executeUpdate("DELETE FROM " + database.getPrefix() + "protections WHERE " + where);
                    sender.sendMessage("\u00a72Affected rows: " + affected);
                    database.precache();
                } else if (args[0].startsWith("select")) {
                    ResultSet set = statement.executeQuery("SELECT * FROM " + database.getPrefix() + "protections WHERE " + where);
                    while (set.next()) {
                        Protection protection = database.resolveProtection(set);
                        sender.sendMessage(protection.toString());
                    }
                    set.close();
                }
            }
            catch (SQLException e) {
                sender.sendMessage("\u00a74Err: " + e.getMessage());
            }
        }
    }
}

