/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.model;

import com.griefcraft.util.StringUtil;
import java.util.Map;
import org.json.simple.JSONObject;

public class Flag {
    private Type type;
    private final JSONObject data = new JSONObject();

    public Flag(Type type) {
        this.type = type;
        this.data.put((Object)"id", (Object)type.ordinal());
    }

    public static Flag decodeJSON(JSONObject node) {
        if (node == null) {
            return null;
        }
        int ordinal = -1;
        try {
            ordinal = Integer.parseInt(node.get((Object)"id").toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (ordinal == -1) {
            return null;
        }
        Type[] values = Type.values();
        if (ordinal > values.length) {
            return null;
        }
        Type type = values[ordinal];
        Flag flag = new Flag(type);
        flag.getData().putAll((Map)node);
        return flag;
    }

    public String toString() {
        return StringUtil.capitalizeFirstLetter(this.type.toString());
    }

    public Type getType() {
        return this.type;
    }

    public JSONObject getData() {
        return this.data;
    }

    public static enum Type {
        REDSTONE,
        MAGNET,
        EXEMPTION(true),
        AUTOCLOSE,
        ALLOWEXPLOSIONS,
        HOPPER;

        private boolean restricted;

        private Type() {
            this(false);
        }

        private Type(boolean restricted) {
            this.restricted = restricted;
        }

        public boolean isRestricted() {
            return this.restricted;
        }
    }
}

