/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.matchers;

import com.griefcraft.lwc.LWC;
import com.griefcraft.util.ProtectionFinder;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;

public class DoorMatcher
implements ProtectionFinder.Matcher {
    public static final Set<Material> PROTECTABLES_DOORS = EnumSet.of(Material.OAK_DOOR, new Material[]{Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.DARK_OAK_DOOR, Material.JUNGLE_DOOR, Material.SPRUCE_DOOR, Material.IRON_DOOR});
    public static final Set<Material> WOODEN_DOORS = EnumSet.of(Material.OAK_DOOR, new Material[]{Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.DARK_OAK_DOOR, Material.JUNGLE_DOOR, Material.SPRUCE_DOOR});
    public static final Set<Material> PRESSURE_PLATES = EnumSet.of(Material.OAK_PRESSURE_PLATE, new Material[]{Material.ACACIA_PRESSURE_PLATE, Material.BIRCH_PRESSURE_PLATE, Material.DARK_OAK_PRESSURE_PLATE, Material.JUNGLE_PRESSURE_PLATE, Material.SPRUCE_PRESSURE_PLATE, Material.STONE_PRESSURE_PLATE, Material.LIGHT_WEIGHTED_PRESSURE_PLATE, Material.HEAVY_WEIGHTED_PRESSURE_PLATE});
    public static final Set<Material> FENCE_GATES = EnumSet.of(Material.OAK_FENCE_GATE, new Material[]{Material.SPRUCE_FENCE_GATE, Material.BIRCH_FENCE_GATE, Material.JUNGLE_FENCE_GATE, Material.DARK_OAK_FENCE_GATE, Material.ACACIA_FENCE_GATE});
    public static final Set<Material> TRAPDOORS = EnumSet.of(Material.OAK_TRAPDOOR, new Material[]{Material.ACACIA_TRAPDOOR, Material.BIRCH_TRAPDOOR, Material.DARK_OAK_TRAPDOOR, Material.JUNGLE_TRAPDOOR, Material.SPRUCE_TRAPDOOR});
    private static final BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH};

    @Override
    public boolean matches(ProtectionFinder finder) {
        BlockState baseBlockState = finder.getBaseBlock();
        Block block = baseBlockState.getBlock();
        Block aboveBaseBlock = block.getRelative(BlockFace.UP);
        Block aboveAboveBaseBlock = aboveBaseBlock.getRelative(BlockFace.UP);
        if (PRESSURE_PLATES.contains(baseBlockState.getType()) || PRESSURE_PLATES.contains(aboveBaseBlock.getType())) {
            Block pressurePlate = PRESSURE_PLATES.contains(baseBlockState.getType()) ? block : aboveBaseBlock;
            for (BlockFace face : faces) {
                ProtectionFinder doorFinder;
                Block relative = pressurePlate.getRelative(face);
                if (!PROTECTABLES_DOORS.contains(relative.getType()) || !(doorFinder = new ProtectionFinder(LWC.getInstance())).matchBlocks(relative)) continue;
                for (BlockState found : doorFinder.getBlocks()) {
                    finder.addBlock(found);
                }
                finder.addBlock(pressurePlate);
                return true;
            }
        }
        if (PROTECTABLES_DOORS.contains(aboveAboveBaseBlock.getType()) && PROTECTABLES_DOORS.contains(aboveBaseBlock.getType())) {
            finder.addBlock(aboveAboveBaseBlock);
            finder.addBlock(aboveBaseBlock);
            this.findPressurePlate(finder, aboveBaseBlock);
            return true;
        }
        if (PROTECTABLES_DOORS.contains(aboveBaseBlock.getType())) {
            finder.addBlock(aboveBaseBlock);
            finder.addBlock(block.getRelative(BlockFace.DOWN));
            this.findPressurePlate(finder, block);
            return true;
        }
        if (PROTECTABLES_DOORS.contains(baseBlockState.getType())) {
            Block bottomHalf = block.getRelative(BlockFace.DOWN);
            finder.addBlock(bottomHalf);
            finder.addBlock(bottomHalf.getRelative(BlockFace.DOWN));
            this.findPressurePlate(finder, bottomHalf);
            return true;
        }
        return false;
    }

    private void findPressurePlate(ProtectionFinder finder, Block block) {
        for (BlockFace face : faces) {
            Block relative = block.getRelative(face);
            if (!PRESSURE_PLATES.contains(relative.getType())) continue;
            finder.addBlock(relative);
        }
    }
}

