/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class AdminView
extends JavaModule {
    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("view")) {
            return;
        }
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            lwc.sendLocale(sender, "protection.admin.noconsole", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (args.length < 2) {
            lwc.sendSimpleUsage(sender, "/lwc admin view <id>");
            return;
        }
        int protectionId = Integer.parseInt(args[1]);
        Protection protection = lwc.getPhysicalDatabase().loadProtection(protectionId);
        if (protection == null) {
            lwc.sendLocale(sender, "protection.admin.view.noexist", new Object[0]);
            return;
        }
        Block block = world.getBlockAt(protection.getX(), protection.getY(), protection.getZ());
        if (!(block.getState() instanceof InventoryHolder)) {
            lwc.sendLocale(sender, "protection.admin.view.noinventory", new Object[0]);
            return;
        }
        player.openInventory(((InventoryHolder)block.getState()).getInventory());
        lwc.sendLocale(sender, "protection.admin.view.viewing", "id", protectionId);
    }
}

