/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LWCEntityListener
implements Listener {
    private LWCPlugin plugin;
    private UUID placedArmorStandOrSpawnEggPlayer;

    public LWCEntityListener(LWCPlugin plugin) {
        this.plugin = plugin;
        new BukkitRunnable(){

            public void run() {
                LWCEntityListener.this.onTick();
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    protected void onTick() {
        this.placedArmorStandOrSpawnEggPlayer = null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHangingPlace(HangingPlaceEvent event) {
        Player player = event.getPlayer();
        Hanging block = event.getEntity();
        this.entityCreatedByPlayer((Entity)block, player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent e) {
        ItemStack inHand = e.getItem();
        if (inHand != null && (inHand.getType() == Material.ARMOR_STAND || inHand.getType().name().endsWith("_SPAWN_EGG"))) {
            this.placedArmorStandOrSpawnEggPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        ItemStack inHand;
        ItemStack itemStack = inHand = e.getHand() == EquipmentSlot.OFF_HAND ? e.getPlayer().getInventory().getItemInOffHand() : e.getPlayer().getInventory().getItemInMainHand();
        if (inHand != null && (inHand.getType() == Material.ARMOR_STAND || inHand.getType().name().endsWith("_SPAWN_EGG"))) {
            this.placedArmorStandOrSpawnEggPlayer = e.getPlayer().getUniqueId();
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (this.placedArmorStandOrSpawnEggPlayer != null) {
            Player player = this.plugin.getServer().getPlayer(this.placedArmorStandOrSpawnEggPlayer);
            LivingEntity entity = e.getEntity();
            this.placedArmorStandOrSpawnEggPlayer = null;
            if (player != null && !e.isCancelled() && (e.getEntityType() == EntityType.ARMOR_STAND || e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) && player.getWorld().equals(entity.getWorld()) && player.getLocation().distanceSquared(entity.getLocation()) <= 25.0) {
                this.entityCreatedByPlayer((Entity)entity, player);
            }
        }
    }

    private void entityCreatedByPlayer(Entity entity, Player player) {
        Protection.Type type;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        if (!lwc.isProtectable(entity)) {
            return;
        }
        String autoRegisterType = lwc.getAutoRegisterType(entity);
        if (!autoRegisterType.equalsIgnoreCase("private") && !autoRegisterType.equalsIgnoreCase("public")) {
            return;
        }
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + autoRegisterType, "lwc.create", "lwc.protect")) {
            return;
        }
        try {
            type = Protection.Type.valueOf(autoRegisterType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (type == null) {
            player.sendMessage("\u00a74LWC_INVALID_CONFIG_autoRegister");
            return;
        }
        try {
            Block entityBlock = EntityBlock.getEntityBlock(entity);
            LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, entityBlock);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
            Protection protection = lwc.getPhysicalDatabase().registerEntityProtection(entity, type, entity.getWorld().getName(), player.getUniqueId().toString(), "", entityBlock.getX(), entityBlock.getY(), entityBlock.getZ());
            if (!Boolean.parseBoolean(lwc.resolveProtectionConfiguration(entityBlock, "quiet"))) {
                lwc.sendLocale((CommandSender)player, "protection.onplace.create.finalize", "type", lwc.getPlugin().getMessageParser().parseMessage(autoRegisterType.toLowerCase(), new Object[0]), "block", LWC.materialToString(entityBlock));
            }
            if (protection != null) {
                lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
            }
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    @EventHandler
    public void entityInteract(EntityInteractEvent event) {
        boolean allowEntityInteract;
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
        if (protection != null && !(allowEntityInteract = Boolean.parseBoolean(this.plugin.getLWC().resolveProtectionConfiguration(block, "allowEntityInteract")))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void entityBreakDoor(EntityBreakDoorEvent event) {
        boolean allowEntityBreakDoor;
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block.getLocation());
        if (protection != null && !(allowEntityBreakDoor = Boolean.parseBoolean(this.plugin.getLWC().resolveProtectionConfiguration(block, "allowEntityBreakDoor")))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = LWC.getInstance();
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            boolean ignoreExplosions;
            Block block = (Block)it.next();
            Protection protection = this.plugin.getLWC().findProtection(block);
            if (protection == null || (ignoreExplosions = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "ignoreExplosions"))) || protection.hasFlag(Flag.Type.ALLOWEXPLOSIONS)) continue;
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        if (lwc.findProtection(event.getBlock()) != null) {
            event.setCancelled(true);
            return;
        }
    }
}

