/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.google.common.base.Objects;
import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.lwc.BlockMap;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Action;
import com.griefcraft.model.Flag;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCPlayerEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.UUIDRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Hopper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class LWCPlayerListener
implements Listener {
    private static final long HANGING_PROTECTION_TIME_AGAINST_PROJECTILES_IN_TICKS = 80L;
    private LWCPlugin plugin;
    private long tick;
    private HashMap<UUID, Long> recentShooters = new HashMap();
    private UUID lastEntityInteract;
    private boolean lastEntityInteractResult;
    private Inventory lastHopper;
    private boolean lastHopperWasSource;
    private boolean lastHopperResult;

    public LWCPlayerListener(LWCPlugin plugin) {
        this.plugin = plugin;
        new BukkitRunnable(){

            public void run() {
                LWCPlayerListener.this.onTick();
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    protected void onTick() {
        ++this.tick;
        this.lastHopper = null;
        this.lastEntityInteract = null;
        if (!this.recentShooters.isEmpty()) {
            Iterator<Long> it = this.recentShooters.values().iterator();
            while (it.hasNext()) {
                if (it.next() + 80L >= this.tick) continue;
                it.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent e) {
        ProjectileSource source = e.getEntity().getShooter();
        if (source instanceof Player) {
            this.recentShooters.put(((Player)source).getUniqueId(), this.tick);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent e) {
        Hanging entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection == null) {
            return;
        }
        if (e.getCause() != HangingBreakEvent.RemoveCause.ENTITY || !(e.getRemover() instanceof Player)) {
            e.setCancelled(true);
            return;
        }
        if (this.recentShooters.containsKey(e.getRemover().getUniqueId())) {
            e.setCancelled(true);
            return;
        }
        Player p = (Player)e.getRemover();
        if (!protection.isOwner(p)) {
            e.setCancelled(true);
            return;
        }
        protection.remove();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onMinecartBreak(VehicleDestroyEvent e) {
        Vehicle entity = e.getVehicle();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection == null) {
            return;
        }
        if (!(e.getAttacker() instanceof Player)) {
            e.setCancelled(true);
            return;
        }
        Player p = (Player)e.getAttacker();
        if (!protection.isOwner(p)) {
            e.setCancelled(true);
            return;
        }
        protection.remove();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (event instanceof HangingBreakByEntityEvent) {
            return;
        }
        Hanging entity = event.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProtectedEntityDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || e instanceof EntityDamageByEntityEvent || !lwc.isProtectable(entity.getType())) {
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProtectedEntityDamageByEntity(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable(entity.getType())) {
            return;
        }
        Player player = p = e.getDamager() instanceof Player ? (Player)e.getDamager() : null;
        if (p != null && this.onPlayerEntityInteract(p, entity, e.isCancelled(), true)) {
            e.setCancelled(true);
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection == null) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || p == null) {
            e.setCancelled(true);
            return;
        }
        if (!protection.isOwner(p)) {
            ItemStack item;
            if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && entity instanceof ItemFrame && (item = ((ItemFrame)entity).getItem()) != null && item.getType() != Material.AIR) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection != null) {
            protection.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent e) {
        Protection protection;
        ArmorStand entity = e.getRightClicked();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        Player p = e.getPlayer();
        if (this.onPlayerEntityInteract(p, (Entity)entity, e.isCancelled(), true)) {
            e.setCancelled(true);
        }
        if ((protection = lwc.findProtection((Entity)entity)) == null) {
            return;
        }
        if (!e.isCancelled() && !lwc.canAccessProtectionContents(p, protection)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityInteract(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable(entity.getType())) {
            return;
        }
        Player p = e.getPlayer();
        if (this.onPlayerEntityInteract(p, entity, e.isCancelled(), e.getHand() == EquipmentSlot.HAND)) {
            e.setCancelled(true);
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection == null) {
            return;
        }
        if (!lwc.canAccessProtectionContents(p, protection)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAtEntityInteract(PlayerInteractAtEntityEvent e) {
        Protection protection;
        Entity entity = e.getRightClicked();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable(entity.getType())) {
            return;
        }
        Player p = e.getPlayer();
        if (this.onPlayerEntityInteract(p, entity, e.isCancelled(), e.getHand() == EquipmentSlot.HAND)) {
            e.setCancelled(true);
        }
        if ((protection = lwc.findProtection(entity)) == null) {
            return;
        }
        if (!lwc.canAccessProtectionContents(p, protection)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void storageMinecraftInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof StorageMinecart) && !(holder instanceof HopperMinecart)) {
            return;
        }
        Entity entity = (Entity)holder;
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity.getType())) {
            return;
        }
        if (this.onPlayerEntityInteract((Player)event.getPlayer(), entity, event.isCancelled(), true)) {
            event.setCancelled(true);
        }
    }

    private boolean onPlayerEntityInteract(Player player, Entity entity, boolean cancelled, boolean showMessage) {
        if (entity.getUniqueId().equals(this.lastEntityInteract)) {
            return this.lastEntityInteractResult;
        }
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.findProtection(entity);
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        try {
            Player owner;
            Module.Result result;
            LWCPlayerEvent evt;
            boolean hasPendingAction;
            Set<String> actions = lwcPlayer.getActionNames();
            boolean canAccess = lwc.canAccessProtectionContents(player, protection);
            int actionCount = actions.size();
            boolean hasInteracted = actions.contains("interacted");
            boolean bl = hasPendingAction = hasInteracted && actionCount > 1 || !hasInteracted && actionCount > 0;
            if (cancelled) {
                if (hasPendingAction) {
                    lwc.sendLocale((CommandSender)player, "lwc.pendingaction", new Object[0]);
                }
                return false;
            }
            if (protection != null) {
                Action action = new Action();
                action.setName("interacted");
                action.setPlayer(lwcPlayer);
                action.setProtection(protection);
                lwcPlayer.addAction(action);
            }
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            Block fakeBlock = EntityBlock.getEntityBlock(entity);
            PlayerInteractEvent fakeEvent = new PlayerInteractEvent(player, org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK, null, fakeBlock, null);
            if (protection != null) {
                evt = new LWCProtectionInteractEvent(fakeEvent, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCProtectionInteractEvent)evt).getResult();
            } else {
                evt = new LWCBlockInteractEvent(fakeEvent, fakeBlock, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCBlockInteractEvent)evt).getResult();
            }
            if (result == Module.Result.ALLOW) {
                return false;
            }
            if (!(protection == null || canAccess || !lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOnline", false) || (owner = protection.getBukkitOwner()) != null && owner.isOnline())) {
                return false;
            }
            if (protection != null && !canAccess && lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOffline", false) && (owner = protection.getBukkitOwner()) != null && owner.isOnline()) {
                return false;
            }
            if (result == Module.Result.DEFAULT) {
                canAccess = lwc.enforceAccess(player, protection, fakeBlock, canAccess, showMessage);
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                this.lastEntityInteract = entity.getUniqueId();
                this.lastEntityInteractResult = true;
                return true;
            }
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
            return true;
        }
        this.lastEntityInteract = entity.getUniqueId();
        this.lastEntityInteractResult = false;
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUIDRegistry.updateCache(player.getUniqueId(), player.getName());
    }

    @EventHandler(ignoreCancelled=true)
    public void onMoveItem(InventoryMoveItemEvent event) {
        boolean result;
        if (event.getInitiator() == event.getSource()) {
            if (Objects.equal((Object)this.lastHopper, (Object)event.getInitiator()) && this.lastHopperWasSource) {
                result = this.lastHopperResult;
            } else {
                result = this.handleMoveItemEvent(event.getInitiator(), event.getDestination());
                this.lastHopper = event.getInitiator();
                this.lastHopperWasSource = true;
                this.lastHopperResult = result;
            }
        } else if (Objects.equal((Object)this.lastHopper, (Object)event.getInitiator()) && !this.lastHopperWasSource) {
            result = this.lastHopperResult;
        } else {
            result = this.handleMoveItemEvent(event.getInitiator(), event.getSource());
            this.lastHopper = event.getInitiator();
            this.lastHopperWasSource = false;
            this.lastHopperResult = result;
        }
        if (result) {
            event.setCancelled(true);
        }
    }

    private boolean handleMoveItemEvent(Inventory initiator, Inventory inventory) {
        String denyHoppersString;
        boolean denyHoppers;
        Protection protection;
        InventoryHolder initiatorHolder;
        InventoryHolder holder;
        LWC lwc = LWC.getInstance();
        if (inventory == null) {
            return false;
        }
        Location location = null;
        Entity entityHolder = null;
        Location initiatorLocation = null;
        Entity initiatorEntity = null;
        try {
            holder = inventory.getHolder();
            initiatorHolder = initiator.getHolder();
        }
        catch (AbstractMethodError e) {
            return false;
        }
        try {
            if (holder instanceof BlockState) {
                location = ((BlockState)holder).getLocation();
            } else if (holder instanceof DoubleChest) {
                location = ((DoubleChest)holder).getLocation();
            } else if (holder instanceof Entity && lwc.isProtectable(((Entity)holder).getType())) {
                entityHolder = (Entity)holder;
            } else {
                return false;
            }
            if (initiatorHolder instanceof Hopper) {
                initiatorLocation = ((Hopper)initiatorHolder).getLocation();
            } else if (initiatorHolder instanceof Entity && lwc.isProtectable(((Entity)initiatorHolder).getType())) {
                initiatorEntity = (Entity)initiatorHolder;
            }
        }
        catch (Exception e) {
            return false;
        }
        lwc.getProtectionCache().increaseIfNecessary();
        Protection protection2 = protection = entityHolder == null ? lwc.findProtection(location) : lwc.findProtection(entityHolder);
        if (protection == null) {
            return false;
        }
        if ((initiatorLocation != null || initiatorEntity != null) && Boolean.parseBoolean(lwc.resolveProtectionConfiguration(Material.HOPPER, "enabled"))) {
            Protection initiatorProtection;
            Protection protection3 = initiatorProtection = initiatorEntity == null ? lwc.findProtection(initiatorLocation) : lwc.findProtection(initiatorEntity);
            if (initiatorProtection != null && protection.getOwner().equals(initiatorProtection.getOwner())) {
                return false;
            }
        }
        return (denyHoppers = Boolean.parseBoolean(denyHoppersString = entityHolder == null ? lwc.resolveProtectionConfiguration(BlockMap.instance().getMaterial(protection.getBlockId()), "denyHoppers") : lwc.resolveProtectionConfiguration(entityHolder.getType(), "denyHoppers"))) ^ protection.hasFlag(Flag.Type.HOPPER);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.isCancelled() || !LWC.ENABLED) {
            return;
        }
        Player player = event.getPlayer();
        LWCDropItemEvent evt = new LWCDropItemEvent(player, event);
        this.plugin.getLWC().getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        BlockState state;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        if (event.getAction() != org.bukkit.event.block.Action.LEFT_CLICK_BLOCK && event.getAction() != org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        try {
            state = block.getState();
        }
        catch (NullPointerException e) {
            lwc.log("Invalid Tile Entity detected at " + block.getLocation());
            lwc.log("This is either an issue with your world or a bug in Bukkit");
            return;
        }
        if (state instanceof InventoryHolder && lwc.isProtectable(block) && !lwc.hasPermission(player, "lwc.protect") && lwc.hasPermission(player, "lwc.deny") && !lwc.isAdmin(player) && !lwc.isMod(player)) {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.blocked", new Object[0]);
            event.setCancelled(true);
            return;
        }
        try {
            Player owner;
            Module.Result result;
            LWCPlayerEvent evt;
            boolean ignoreRightClick;
            boolean ignoreLeftClick;
            boolean hasPendingAction;
            Set<String> actions = lwcPlayer.getActionNames();
            Protection protection = lwc.findProtection(block.getLocation());
            boolean canAccess = lwc.canAccessProtection(player, protection);
            int actionCount = actions.size();
            boolean hasInteracted = actions.contains("interacted");
            boolean bl = hasPendingAction = hasInteracted && actionCount > 1 || !hasInteracted && actionCount > 0;
            if (event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_BLOCK ? (ignoreLeftClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreLeftClick"))) : event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK && (ignoreRightClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreRightClick")))) {
                return;
            }
            if (event.isCancelled()) {
                if (hasPendingAction) {
                    lwc.sendLocale((CommandSender)player, "lwc.pendingaction", new Object[0]);
                }
                return;
            }
            if (protection != null) {
                Action action = new Action();
                action.setName("interacted");
                action.setPlayer(lwcPlayer);
                action.setProtection(protection);
                lwcPlayer.addAction(action);
            }
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            if (protection != null) {
                evt = new LWCProtectionInteractEvent(event, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCProtectionInteractEvent)evt).getResult();
            } else {
                evt = new LWCBlockInteractEvent(event, block, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCBlockInteractEvent)evt).getResult();
            }
            if (result == Module.Result.ALLOW) {
                return;
            }
            if (!(protection == null || canAccess || !lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOnline", false) || (owner = protection.getBukkitOwner()) != null && owner.isOnline())) {
                return;
            }
            if (protection != null && !canAccess && lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOffline", false) && (owner = protection.getBukkitOwner()) != null && owner.isOnline()) {
                return;
            }
            if (result == Module.Result.DEFAULT) {
                canAccess = lwc.enforceAccess(player, protection, block, canAccess, event.getHand() == EquipmentSlot.HAND);
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                event.setCancelled(true);
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWCPlayer.removePlayer(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        boolean canAccessContents;
        Location location;
        Player player;
        LWC lwc;
        block19: {
            lwc = LWC.getInstance();
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            Inventory inventory = event.getInventory();
            if (inventory == null || event.getSlot() < 0) {
                return;
            }
            InventoryHolder holder = null;
            try {
                holder = event.getInventory().getHolder();
            }
            catch (AbstractMethodError e) {
                lwc.log("Caught issue with Bukkit's Inventory.getHolder() method! This is occuring NEAR the player: " + player.getName());
                lwc.log("This player is located at: " + player.getLocation().toString());
                lwc.log("This should be reported to the Bukkit developers.");
                e.printStackTrace();
                return;
            }
            try {
                if (holder instanceof BlockState) {
                    location = ((BlockState)holder).getLocation();
                    break block19;
                }
                if (holder instanceof DoubleChest) {
                    location = ((DoubleChest)holder).getLocation();
                    break block19;
                }
                return;
            }
            catch (Exception e) {
                Location ploc = player.getLocation();
                String holderName = holder != null ? holder.getClass().getSimpleName() : "Unknown Block";
                lwc.log("Exception with getting the location of a " + holderName + " has occurred NEAR the player: " + player.getName() + " [" + ploc.getBlockX() + " " + ploc.getBlockY() + " " + ploc.getBlockZ() + "]");
                lwc.log("The exact location of the block is not possible to obtain. This is caused by a Minecraft or Bukkit exception normally.");
                e.printStackTrace();
                return;
            }
        }
        Protection protection = lwc.findProtection(location);
        if (protection == null) {
            return;
        }
        if (protection.getType() != Protection.Type.DONATION && protection.getType() != Protection.Type.SHOWCASE) {
            return;
        }
        if (protection.getType() != Protection.Type.SHOWCASE && event.getAction() != InventoryAction.COLLECT_TO_CURSOR) {
            ItemStack item;
            if (event.getSlotType() != InventoryType.SlotType.CONTAINER) {
                return;
            }
            if (event.getSlot() != event.getRawSlot()) {
                return;
            }
            try {
                item = event.getCurrentItem();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
            ItemStack cursor = event.getCursor();
            if (item == null || item.getType() == null || item.getType() == Material.AIR) {
                return;
            }
            if (player.getInventory().getItemInMainHand() == null && !event.isRightClick() && !event.isShiftClick()) {
                return;
            }
            if (cursor != null && item.isSimilar(cursor)) {
                return;
            }
        }
        if (!(canAccessContents = lwc.canAccessProtectionContents(player, protection))) {
            event.setCancelled(true);
        }
    }
}

