/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.config;

import com.griefcraft.util.config.ConfigUpdater;
import com.griefcraft.util.config.ConfigurationException;
import com.griefcraft.util.config.ConfigurationNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class Configuration
extends ConfigurationNode {
    private Yaml yaml;
    private File file;
    private static Map<String, Configuration> loaded = new HashMap<String, Configuration>();
    private static final ConfigUpdater updater = new ConfigUpdater();

    protected Configuration(File file) {
        super(new HashMap<String, Object>());
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), options);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public static void reload() {
        for (Configuration configuration : loaded.values()) {
            configuration.load(configuration.file);
        }
    }

    public static Map<String, Configuration> getLoaded() {
        return loaded;
    }

    public static Configuration load(String config) {
        return Configuration.load(config, true);
    }

    public static Configuration load(String config, boolean extractConfig) {
        if (loaded.containsKey(config)) {
            return loaded.get(config);
        }
        File file = new File("plugins/LWC/" + config);
        File folder = new File("plugins/LWC/");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!file.exists()) {
            if (!extractConfig) {
                return null;
            }
            Configuration.extractFile("/config/" + config, "plugins/LWC/" + config);
        }
        Configuration configuration = new Configuration(file);
        configuration.load(file);
        loaded.put(config, configuration);
        updater.update(configuration);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(String path, String destFolder) {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = updater.getClass().getResourceAsStream(path);
            os = new FileOutputStream(destFolder);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void load(InputStream inputStream) {
        try {
            this.read(this.yaml.load((Reader)new UnicodeReader(inputStream)));
        }
        catch (ConfigurationException e) {
            this.root = new HashMap();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void load(File file) {
        try {
            this.cache.clear();
            this.load(new FileInputStream(file));
        }
        catch (IOException e) {
            this.root = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        FileOutputStream stream = null;
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            stream = new FileOutputStream(this.file);
            this.yaml.dump((Object)this.root, (Writer)new OutputStreamWriter((OutputStream)stream, "UTF-8"));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private void read(Object input) throws ConfigurationException {
        try {
            this.root = null == input ? new HashMap() : (Map)input;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Root document must be an key-value structure");
        }
    }

    public static ConfigurationNode getEmptyNode() {
        return new ConfigurationNode(new HashMap<String, Object>());
    }
}

