/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import java.security.MessageDigest;
import java.util.Formatter;

public class StringUtil {
    public static String fastReplace(String haystack, char find, char replace) {
        if (haystack == null) {
            throw new IllegalArgumentException("Invalid haystack");
        }
        char[] chrarray = haystack.toCharArray();
        for (int index = 0; index < chrarray.length; ++index) {
            if (chrarray[index] != find) continue;
            chrarray[index] = replace;
        }
        return new String(chrarray);
    }

    public static String fastReplace(String haystack, String needle, String replace) {
        return haystack.replace(needle, replace);
    }

    public static String capitalizeFirstLetter(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        char[] string = str.toLowerCase().toCharArray();
        string[0] = Character.toUpperCase(string[0]);
        for (int index = 0; index < string.length; ++index) {
            if (string[index] != ' ' || index == string.length) continue;
            string[index + 1] = Character.toUpperCase(string[index + 1]);
        }
        return new String(string);
    }

    public static String encrypt(String plaintext) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(plaintext.getBytes("UTF-8"));
            byte[] raw = md.digest();
            return StringUtil.byteArray2Hex(raw);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean hasFlag(String[] args, String checkFlag) {
        String flag = args[0].toLowerCase();
        return flag.equals(checkFlag) || flag.equals("-" + checkFlag);
    }

    public static boolean hasFlag(String command, String checkFlag) {
        return command.equals(checkFlag) || command.equals("-" + checkFlag);
    }

    public static String join(String[] arr) {
        return StringUtil.join(arr, 0);
    }

    public static String join(String[] arr, int offset) {
        return StringUtil.join(arr, offset, " ");
    }

    public static String join(String[] arr, int offset, String delim) {
        String str = "";
        if (arr == null || arr.length == 0) {
            return str;
        }
        for (int i = offset; i < arr.length; ++i) {
            str = str + arr[i] + delim;
        }
        return str.trim();
    }

    public static String transform(String str, char chr) {
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = chr;
        }
        return new String(charArray);
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }
}

