/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.cache.CacheKey;
import com.griefcraft.cache.LRUCache;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.BlockMap;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.History;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.sql.Column;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.Table;
import com.griefcraft.util.Statistics;
import com.griefcraft.util.UUIDRegistry;
import com.griefcraft.util.config.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PhysDB
extends Database {
    private final JSONParser jsonParser = new JSONParser();
    private int databaseVersion = 0;
    private int protectionCount = 0;

    public PhysDB() {
    }

    public PhysDB(Database.Type currentType) {
        super(currentType);
    }

    public void decrementProtectionCount() {
        --this.protectionCount;
    }

    public boolean hasAllProtectionsCached() {
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        return cache.size() >= this.protectionCount;
    }

    private Object fetch(String sql, String column, Object ... toBind) {
        try {
            int index = 1;
            PreparedStatement statement = this.prepare(sql);
            for (Object bind : toBind) {
                statement.setObject(index, bind);
                ++index;
            }
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                Object object = set.getObject(column);
                set.close();
                return object;
            }
            set.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return null;
    }

    public int getProtectionCount() {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "protections", "count", new Object[0]).toString());
    }

    public int getProtectionCount(Protection.Type type) {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "protections WHERE type = " + type.ordinal(), "count", new Object[0]).toString());
    }

    public int getHistoryCount() {
        return Integer.decode(this.fetch("SELECT COUNT(*) AS count FROM " + this.prefix + "history", "count", new Object[0]).toString());
    }

    public int getProtectionCount(String player) {
        int count = 0;
        try {
            PreparedStatement statement = this.prepare("SELECT COUNT(*) as count FROM " + this.prefix + "protections WHERE owner = ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                count = set.getInt("count");
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return count;
    }

    public int getHistoryCount(String player) {
        int count = 0;
        try {
            PreparedStatement statement = this.prepare("SELECT COUNT(*) AS count FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?)");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                count = set.getInt("count");
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return count;
    }

    public int getProtectionCount(String player, Material block) {
        int count = 0;
        try {
            PreparedStatement statement = this.prepare("SELECT COUNT(*) AS count FROM " + this.prefix + "protections WHERE owner = ? AND blockId = ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            statement.setInt(2, BlockMap.instance().getId(block));
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                count = set.getInt("count");
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return count;
    }

    public String getMenuStyle(String player) {
        return "basic";
    }

    @Override
    public void load() {
        if (this.loaded) {
            return;
        }
        this.databaseVersion = -1;
        this.loadDatabaseVersion();
        if (this.databaseVersion < 6) {
            this.doUpdate301();
            this.doUpdate302();
            this.doUpdate330();
            this.doUpdate400_4();
            this.doUpdate400_5();
            this.doUpdate400_6();
            this.doUpdate5_0_12();
            boolean resetDatabaseVersion = this.doUpdateModernLWC();
            Table protections = new Table(this, "protections");
            Column column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            protections.add(column);
            column = new Column("owner");
            column.setType("VARCHAR(36)");
            protections.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("x");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("y");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("z");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("data");
            column.setType("TEXT");
            protections.add(column);
            column = new Column("blockId");
            column.setType("INTEGER");
            protections.add(column);
            column = new Column("world");
            column.setType("VARCHAR(50)");
            protections.add(column);
            column = new Column("password");
            column.setType("VARCHAR(255)");
            protections.add(column);
            column = new Column("date");
            column.setType("VARCHAR(50)");
            protections.add(column);
            column = new Column("last_accessed");
            column.setType("INTEGER");
            protections.add(column);
            Table history = new Table(this, "history");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            history.add(column);
            column = new Column("protectionId");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("player");
            column.setType("VARCHAR(36)");
            history.add(column);
            column = new Column("x");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("y");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("z");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("type");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("status");
            column.setType("INTEGER");
            history.add(column);
            column = new Column("metadata");
            column.setType("VARCHAR(255)");
            history.add(column);
            column = new Column("timestamp");
            column.setType("long");
            history.add(column);
            Table internal = new Table(this, "internal");
            column = new Column("name");
            column.setType("VARCHAR(40)");
            column.setPrimary(true);
            column.setAutoIncrement(false);
            internal.add(column);
            column = new Column("value");
            column.setType("VARCHAR(40)");
            internal.add(column);
            Table blockMappings = new Table(this, "blocks");
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            column.setAutoIncrement(false);
            blockMappings.add(column);
            column = new Column("name");
            column.setType("VARCHAR(40)");
            blockMappings.add(column);
            protections.execute();
            history.execute();
            internal.execute();
            blockMappings.execute();
            this.databaseVersion = 0;
            if (!resetDatabaseVersion) {
                this.loadDatabaseVersion();
            }
        }
        this.performDatabaseUpdates();
        this.protectionCount = this.getProtectionCount();
        this.loaded = true;
    }

    public void performDatabaseUpdates() {
        LWC lwc = LWC.getInstance();
        if (this.databaseVersion == 0) {
            this.dropIndex("protections", "in1");
            this.dropIndex("protections", "in6");
            this.dropIndex("protections", "in7");
            this.dropIndex("history", "in8");
            this.dropIndex("history", "in9");
            this.dropIndex("protections", "in10");
            this.dropIndex("history", "in12");
            this.dropIndex("history", "in13");
            this.dropIndex("history", "in14");
            this.doUpdatedDatabaseVersion7();
            this.createIndex("protections", "protections_main", "x, y, z, world");
            this.createIndex("protections", "protections_utility", "owner");
            this.createIndex("history", "history_main", "protectionId");
            this.createIndex("history", "history_utility", "player");
            this.createIndex("history", "history_utility2", "x, y, z");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 1) {
            this.createIndex("internal", "internal_main", "name");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 2) {
            this.doUpdate400_2();
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 3) {
            this.createIndex("protections", "protections_type", "type");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 4) {
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 5) {
            boolean foundTrappedChest = false;
            for (String key : lwc.getConfiguration().getNode("protections.blocks").getKeys(null)) {
                if (!key.equalsIgnoreCase("trapped_chest")) continue;
                foundTrappedChest = true;
                break;
            }
            if (!foundTrappedChest) {
                lwc.getConfiguration().setProperty("protections.blocks.trapped_chest.enabled", true);
                lwc.getConfiguration().setProperty("protections.blocks.trapped_chest.autoRegister", "private");
                lwc.getConfiguration().save();
                Configuration.reload();
                lwc.log("Added Trapped Chests to core.yml as default protectable (ENABLED & AUTO REGISTERED)");
                lwc.log("Trapped chests are nearly the same as reg chests but can light up! They can also be double chests.");
                lwc.log("If you DO NOT want this as protected, simply remove it from core.yml! (search/look for trapped_chests under protections -> blocks");
            }
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 6) {
            this.doUpdatedDatabaseVersion7();
            this.createIndex("protections", "protections_main", "x, y, z, world");
            this.createIndex("protections", "protections_utility", "owner");
            this.createIndex("history", "history_utility", "player");
            this.incrementDatabaseVersion();
        }
        if (this.databaseVersion == 7) {
            this.doUpdatedDatabaseVersion7();
            this.incrementDatabaseVersion();
        }
    }

    public void incrementDatabaseVersion() {
        this.setDatabaseVersion(++this.databaseVersion);
    }

    public void setDatabaseVersion(int databaseVersion) {
        this.databaseVersion = databaseVersion;
        try {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "internal SET value = ? WHERE name = ?");
            statement.setInt(1, databaseVersion);
            statement.setString(2, "version");
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getInternal(String key) {
        try {
            PreparedStatement statement = this.prepare("SELECT value FROM " + this.prefix + "internal WHERE name = ?");
            statement.setString(1, key);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                String value = set.getString("value");
                set.close();
                return value;
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return null;
    }

    public void setInternal(String key, String value) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "internal (name, value) VALUES (?, ?)");
            statement.setString(1, key);
            statement.setString(2, value);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "internal SET value = ? WHERE name = ?");
                statement.setString(1, value);
                statement.setString(2, key);
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
        }
    }

    public int loadDatabaseVersion() {
        try {
            PreparedStatement statement = this.prepare("SELECT value FROM " + this.prefix + "internal WHERE name = ?");
            statement.setString(1, "version");
            ResultSet set = statement.executeQuery();
            if (!set.next()) {
                throw new IllegalStateException("Internal is empty");
            }
            this.databaseVersion = Integer.parseInt(set.getString("value"));
            set.close();
        }
        catch (Exception e) {
            try {
                PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "internal (name, value) VALUES(?, ?)");
                statement.setString(1, "version");
                statement.setInt(2, this.databaseVersion);
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.databaseVersion;
    }

    public Protection loadProtection(int id) {
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        Protection cached = cache.getProtectionById(id);
        if (cached != null) {
            return cached;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE id = ?");
            statement.setInt(1, id);
            Protection protection = this.resolveProtection(statement);
            if (protection != null) {
                cache.addProtection(protection);
                return protection;
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return null;
    }

    public List<Protection> loadProtectionsUsingType(Protection.Type type) {
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE type = ?");
            statement.setInt(1, type.ordinal());
            return this.resolveProtections(statement);
        }
        catch (SQLException e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public Protection resolveProtection(ResultSet set) {
        try {
            Object flags;
            Protection protection = new Protection();
            int protectionId = set.getInt("id");
            int x = set.getInt("x");
            int y = set.getInt("y");
            int z = set.getInt("z");
            int blockId = set.getInt("blockId");
            int type = set.getInt("type");
            String world = set.getString("world");
            String owner = set.getString("owner");
            String password = set.getString("password");
            String date = set.getString("date");
            long lastAccessed = set.getLong("last_accessed");
            protection.setId(protectionId);
            protection.setX(x);
            protection.setY(y);
            protection.setZ(z);
            if (blockId == 5000 || y < 0 || y > 255) {
                protection.setIsEntity(true);
            } else {
                protection.setBlockMaterial(BlockMap.instance().getMaterial(blockId));
            }
            protection.setType(Protection.Type.values()[type]);
            protection.setWorld(world);
            protection.setOwner(owner);
            protection.setPassword(password);
            protection.setCreation(date);
            protection.setLastAccessed(lastAccessed);
            String data = set.getString("data");
            if (data == null || data.trim().isEmpty()) {
                return protection;
            }
            Object object = null;
            try {
                object = this.jsonParser.parse(data);
            }
            catch (Exception e) {
                return protection;
            }
            catch (Error e) {
                return protection;
            }
            if (!(object instanceof JSONObject)) {
                return protection;
            }
            JSONObject root = (JSONObject)object;
            protection.getData().putAll((Map)root);
            Object rights = root.get((Object)"rights");
            if (rights != null && rights instanceof JSONArray) {
                JSONArray array = (JSONArray)rights;
                for (Object node : array) {
                    JSONObject map;
                    Permission permission;
                    if (!(node instanceof JSONObject) || (permission = Permission.decodeJSON(map = (JSONObject)node)) == null) continue;
                    protection.addPermission(permission);
                }
            }
            if ((flags = root.get((Object)"flags")) != null && rights instanceof JSONArray) {
                JSONArray array = (JSONArray)flags;
                for (Object node : array) {
                    JSONObject map;
                    Flag flag;
                    if (!(node instanceof JSONObject) || (flag = Flag.decodeJSON(map = (JSONObject)node)) == null) continue;
                    protection.addFlag(flag);
                }
            }
            return protection;
        }
        catch (SQLException e) {
            this.printException(e);
            return null;
        }
    }

    private List<Protection> resolveProtections(ResultSet set) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        try {
            while (set.next()) {
                Protection protection = this.resolveProtection(set);
                if (protection == null) continue;
                protections.add(protection);
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return protections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Protection> resolveProtections(PreparedStatement statement) {
        ArrayList<Protection> protections = new ArrayList();
        ResultSet set = null;
        try {
            set = statement.executeQuery();
            protections = this.resolveProtections(set);
        }
        catch (SQLException e) {
            this.printException(e);
        }
        finally {
            if (set != null) {
                try {
                    set.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return protections;
    }

    private Protection resolveProtection(PreparedStatement statement) {
        List<Protection> protections = this.resolveProtections(statement);
        if (protections.size() == 0) {
            return null;
        }
        return protections.get(0);
    }

    public void precache() {
        LWC lwc = LWC.getInstance();
        ProtectionCache cache = lwc.getProtectionCache();
        cache.clear();
        int precacheSize = lwc.getConfiguration().getInt("core.precache", -1);
        if (precacheSize == -1) {
            precacheSize = lwc.getConfiguration().getInt("core.cacheSize", 10000);
        }
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections ORDER BY id DESC LIMIT ?");
            statement.setInt(1, precacheSize);
            statement.setFetchSize(10);
            List<Protection> protections = this.resolveProtections(statement);
            for (Protection protection : protections) {
                cache.addProtection(protection);
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public Protection loadProtection(String worldName, int x, int y, int z) {
        return this.loadProtection(worldName, x, y, z, false);
    }

    private Protection loadProtection(String worldName, int x, int y, int z, boolean ignoreProtectionCount) {
        CacheKey cacheKey = ProtectionCache.cacheKey(worldName, x, y, z);
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        Protection cached = cache.getProtection(cacheKey);
        if (cached != null) {
            if (x == y && x == z) {
                Statistics.addEntityCacheHit();
            } else {
                Statistics.addBlockCacheHit();
            }
            return cached;
        }
        if (cache.isDirectKnownNull(cacheKey) || cache.isKnownNull(cacheKey)) {
            if (x == y && x == z) {
                Statistics.addEntityCacheHitNull();
            } else {
                Statistics.addBlockCacheHitNull();
            }
            return null;
        }
        if (!ignoreProtectionCount && this.hasAllProtectionsCached()) {
            return null;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE x = ? AND y = ? AND z = ? AND world = ?");
            statement.setInt(1, x);
            statement.setInt(2, y);
            statement.setInt(3, z);
            statement.setString(4, worldName);
            Protection protection = this.resolveProtection(statement);
            if (protection != null) {
                cache.addProtection(protection);
                if (x == y && x == z) {
                    Statistics.addEntityCacheMiss();
                } else {
                    Statistics.addBlockCacheMiss();
                }
            } else {
                if (x == y && x == z) {
                    Statistics.addEntityCacheMissNull();
                } else {
                    Statistics.addBlockCacheMissNull();
                }
                cache.addDirectKnownNull(cacheKey);
            }
            return protection;
        }
        catch (SQLException e) {
            this.printException(e);
            return null;
        }
    }

    public List<Protection> loadProtections() {
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections");
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public List<Protection> loadProtections(String world, int baseX, int baseY, int baseZ, int radius) {
        if (this.hasAllProtectionsCached()) {
            ProtectionCache cache = LWC.getInstance().getProtectionCache();
            ArrayList<Protection> protections = new ArrayList<Protection>();
            if (cache.size() < 1000) {
                for (Protection protection : cache.getReferences().keySet()) {
                    int x = protection.getX();
                    int y = protection.getY();
                    int z = protection.getZ();
                    if (x < baseX - radius || x > baseX + radius || y < baseY - radius || y > baseY + radius || z < baseZ - radius || z > baseZ + radius) continue;
                    protections.add(protection);
                }
            } else {
                for (int x = baseX - radius; x < baseX + radius; ++x) {
                    for (int y = baseY - radius; y < baseY + radius; ++y) {
                        for (int z = baseZ - radius; z < baseZ + radius; ++z) {
                            Protection protection = cache.getProtection(ProtectionCache.cacheKey(world, x, y, z));
                            if (protection == null) continue;
                            protections.add(protection);
                        }
                    }
                }
            }
            return protections;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE world = ? AND x >= ? AND x <= ? AND y >= ? AND y <= ? AND z >= ? AND z <= ?");
            statement.setString(1, world);
            statement.setInt(2, baseX - radius);
            statement.setInt(3, baseX + radius);
            statement.setInt(4, baseY - radius);
            statement.setInt(5, baseY + radius);
            statement.setInt(6, baseZ - radius);
            statement.setInt(7, baseZ + radius);
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public int removeProtectionsByPlayer(String player) {
        int removed = 0;
        for (Protection protection : this.loadProtectionsByPlayer(player)) {
            protection.remove();
            ++removed;
        }
        return removed;
    }

    public List<Protection> loadProtections(String world, int x1, int x2, int y1, int y2, int z1, int z2) {
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE world = ? AND x >= ? AND x <= ? AND y >= ? AND y <= ? AND z >= ? AND z <= ?");
            statement.setString(1, world);
            statement.setInt(2, x1);
            statement.setInt(3, x2);
            statement.setInt(4, y1);
            statement.setInt(5, y2);
            statement.setInt(6, z1);
            statement.setInt(7, z2);
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return new ArrayList<Protection>();
        }
    }

    public List<Protection> loadProtectionsByPlayerAlsoIfNotOwner(String player) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE owner = ? OR data LIKE ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            String playerString = uuid != null ? uuid.toString() : player;
            statement.setString(1, playerString);
            statement.setString(2, "%\"" + playerString + "\"%");
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return protections;
        }
    }

    public List<Protection> loadProtectionsByPlayer(String player) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE owner = ?");
            UUID uuid = UUIDRegistry.getUUID(player);
            statement.setString(1, uuid != null ? uuid.toString() : player);
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return protections;
        }
    }

    public List<Protection> loadProtectionsByPlayer(String player, int start, int count) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        UUID uuid = UUIDRegistry.getUUID(player);
        try {
            PreparedStatement statement = this.prepare("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + this.prefix + "protections WHERE owner = ? ORDER BY id DESC limit ?,?");
            statement.setString(1, uuid != null ? uuid.toString() : player);
            statement.setInt(2, start);
            statement.setInt(3, count);
            return this.resolveProtections(statement);
        }
        catch (Exception e) {
            this.printException(e);
            return protections;
        }
    }

    public Protection registerEntityProtection(Entity entity, Protection.Type type, String world, String player, String data, int x, int y, int z) {
        return this.registerProtection(5000, type, world, player, data, x, y, z);
    }

    public Protection registerProtection(Material block, Protection.Type type, String world, String player, String data, int x, int y, int z) {
        int blockId = BlockMap.instance().registerOrGetId(block);
        return this.registerProtection(blockId, type, world, player, data, x, y, z);
    }

    private Protection registerProtection(int blockId, Protection.Type type, String world, String player, String data, int x, int y, int z) {
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "protections (blockId, type, world, owner, password, x, y, z, date, last_accessed) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, blockId);
            statement.setInt(2, type.ordinal());
            statement.setString(3, world);
            statement.setString(4, player);
            statement.setString(5, data);
            statement.setInt(6, x);
            statement.setInt(7, y);
            statement.setInt(8, z);
            statement.setString(9, new Timestamp(new Date().getTime()).toString());
            statement.setLong(10, System.currentTimeMillis() / 1000L);
            statement.executeUpdate();
            cache.remove(ProtectionCache.cacheKey(world, x, y, z));
            Protection protection = this.loadProtection(world, x, y, z, true);
            protection.removeCache();
            if (LWC.getInstance().isHistoryEnabled()) {
                History transaction = protection.createHistoryObject();
                transaction.setPlayer(player);
                transaction.setType(History.Type.TRANSACTION);
                transaction.setStatus(History.Status.ACTIVE);
                transaction.addMetaData("creator=" + player);
                transaction.saveNow();
            }
            cache.addProtection(protection);
            ++this.protectionCount;
            return protection;
        }
        catch (SQLException e) {
            this.printException(e);
            return null;
        }
    }

    public void saveHistory(History history) {
        try {
            PreparedStatement statement;
            if (history.doesExist()) {
                statement = this.prepare("UPDATE " + this.prefix + "history SET protectionId = ?, player = ?, x = ?, y = ?, z = ?, type = ?, status = ?, metadata = ?, timestamp = ? WHERE id = ?");
            } else {
                statement = this.prepare("INSERT INTO " + this.prefix + "history (protectionId, player, x, y, z, type, status, metadata, timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", true);
                history.setTimestamp(System.currentTimeMillis() / 1000L);
            }
            statement.setInt(1, history.getProtectionId());
            statement.setString(2, history.getPlayer());
            statement.setInt(3, history.getX());
            statement.setInt(4, history.getY());
            statement.setInt(5, history.getZ());
            statement.setInt(6, history.getType().ordinal());
            statement.setInt(7, history.getStatus().ordinal());
            statement.setString(8, history.getSafeMetaData());
            statement.setLong(9, history.getTimestamp());
            if (history.doesExist()) {
                statement.setInt(10, history.getId());
            }
            int affectedRows = statement.executeUpdate();
            if (!history.doesExist() && affectedRows > 0) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    history.setId(generatedKeys.getInt(1));
                }
                generatedKeys.close();
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void invalidateHistory(String player) {
        try {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "history SET status = ? WHERE player = ?");
            statement.setInt(1, History.Status.INACTIVE.ordinal());
            statement.setString(2, player);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    private History resolveHistory(History history, ResultSet set) throws SQLException {
        if (history == null) {
            return null;
        }
        int historyId = set.getInt("id");
        int protectionId = set.getInt("protectionId");
        int x = set.getInt("x");
        int y = set.getInt("y");
        int z = set.getInt("z");
        String player = set.getString("player");
        int type_ord = set.getInt("type");
        int status_ord = set.getInt("status");
        String[] metadata = set.getString("metadata").split(",");
        long timestamp = set.getLong("timestamp");
        History.Type type = History.Type.values()[type_ord];
        History.Status status = History.Status.values()[status_ord];
        history.setId(historyId);
        history.setProtectionId(protectionId);
        history.setType(type);
        history.setPlayer(player);
        history.setX(x);
        history.setY(y);
        history.setZ(z);
        history.setStatus(status);
        history.setMetaData(metadata);
        history.setTimestamp(timestamp);
        return history;
    }

    public List<History> loadHistory(Protection protection) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE protectionId = ? ORDER BY id DESC");
            statement.setInt(1, protection.getId());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(protection.createHistoryObject(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory(Player player) {
        return this.loadHistory(player.getName());
    }

    public List<History> loadHistory(String player) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?) ORDER BY id DESC");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public History loadHistory(int historyId) {
        if (!LWC.getInstance().isHistoryEnabled()) {
            return null;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE id = ?");
            statement.setInt(1, historyId);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                History history = this.resolveHistory(new History(), set);
                set.close();
                return history;
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return null;
    }

    public List<History> loadHistory(Player player, int start, int count) {
        return this.loadHistory(player.getName(), start, count);
    }

    public List<History> loadHistory(String player, int start, int count) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?) ORDER BY id DESC LIMIT ?,?");
            statement.setString(1, player);
            statement.setInt(2, start);
            statement.setInt(3, count);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory() {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history ORDER BY id DESC");
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory(History.Status status) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE status = ? ORDER BY id DESC");
            statement.setInt(1, status.ordinal());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory(int x, int y, int z) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE x = ? AND y = ? AND z = ?");
            statement.setInt(1, x);
            statement.setInt(2, y);
            statement.setInt(3, z);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory(String player, int x, int y, int z) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history WHERE LOWER(player) = LOWER(?) AND x = ? AND y = ? AND z = ?");
            statement.setString(1, player);
            statement.setInt(2, x);
            statement.setInt(3, y);
            statement.setInt(4, z);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public List<History> loadHistory(int start, int count) {
        ArrayList<History> temp = new ArrayList<History>();
        if (!LWC.getInstance().isHistoryEnabled()) {
            return temp;
        }
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "history ORDER BY id DESC LIMIT ?,?");
            statement.setInt(1, start);
            statement.setInt(2, count);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                History history = this.resolveHistory(new History(), set);
                if (history == null) continue;
                temp.add(history);
            }
            set.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
        return temp;
    }

    public void saveProtection(Protection protection) {
        try {
            PreparedStatement statement = this.prepare("REPLACE INTO " + this.prefix + "protections (id, type, blockId, world, data, owner, password, x, y, z, date, last_accessed) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, protection.getId());
            statement.setInt(2, protection.getType().ordinal());
            statement.setInt(3, protection.getBlockId());
            statement.setString(4, protection.getWorld());
            statement.setString(5, protection.getData().toJSONString());
            statement.setString(6, protection.getOwner());
            statement.setString(7, protection.getPassword());
            statement.setInt(8, protection.getX());
            statement.setInt(9, protection.getY());
            statement.setInt(10, protection.getZ());
            statement.setString(11, protection.getCreation());
            statement.setLong(12, protection.getLastAccessed());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void saveProtectionLastAccessed(Protection protection) {
        try {
            PreparedStatement statement = this.prepare("UPDATE " + this.prefix + "protections SET last_accessed = ? WHERE id = ?");
            statement.setLong(1, protection.getLastAccessed());
            statement.setInt(2, protection.getId());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void removeProtection(int protectionId) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "protections WHERE id = ?");
            statement.setInt(1, protectionId);
            int affected = statement.executeUpdate();
            if (affected >= 1) {
                this.protectionCount -= affected;
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void removeProtectionHistory(int protectionId) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "history WHERE protectionId = ?");
            statement.setInt(1, protectionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void removeHistory(int historyId) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "history WHERE id = ?");
            statement.setInt(1, historyId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void removeAllProtections() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM " + this.prefix + "protections");
            this.protectionCount = 0;
            statement.close();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(String table, String indexName, String columns) {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate("CREATE INDEX" + (this.currentType == Database.Type.SQLite ? " IF NOT EXISTS" : "") + " " + indexName + " ON " + this.prefix + table + " (" + columns + ")");
        }
        catch (Exception exception) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(String table, String indexName) {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            if (this.currentType == Database.Type.SQLite) {
                statement.executeUpdate("DROP INDEX IF EXISTS " + indexName);
            } else {
                statement.executeUpdate("DROP INDEX " + indexName + " ON " + this.prefix + table);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void doUpdate301() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT * FROM limits LIMIT 1");
            statement.close();
        }
        catch (Exception e) {
            return;
        }
        LWC lwc = LWC.getInstance();
        Module rawModule = lwc.getModuleLoader().getModule(LimitsModule.class);
        if (rawModule == null) {
            this.log("Failed to load the Limits module. Something is wrong!");
            return;
        }
        LimitsModule limits = (LimitsModule)rawModule;
        PreparedStatement statement = this.prepare("SELECT * FROM limits");
        try {
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                int type = result.getInt("type");
                int amount = result.getInt("amount");
                String entity = result.getString("entity");
                switch (type) {
                    case 2: {
                        limits.set("master.type", "default");
                        limits.set("master.limit", amount);
                        break;
                    }
                    case 0: {
                        limits.set("groups." + entity + ".type", "default");
                        limits.set("groups." + entity + ".limit", amount);
                        break;
                    }
                    case 1: {
                        limits.set("players." + entity + ".type", "default");
                        limits.set("players." + entity + ".limit", amount);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.printException(e);
            return;
        }
        limits.save();
        this.dropTable("limits");
    }

    private void doUpdate302() {
        if (this.prefix == null || this.prefix.length() == 0) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT id FROM " + this.prefix + "protections limit 1");
        }
        catch (SQLException e) {
            this.renameTable("protections", this.prefix + "protections");
            this.renameTable("rights", this.prefix + "rights");
            this.renameTable("menu_styles", this.prefix + "menu_styles");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void doUpdate330() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT last_accessed FROM " + this.prefix + "protections LIMIT 1");
        }
        catch (SQLException e) {
            this.addColumn(this.prefix + "protections", "last_accessed", "INTEGER");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate400_2() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT id FROM " + this.prefix + "rights LIMIT 1");
            this.log("Migrating LWC3 rights to LWC4 format");
            Statement stmt = this.connection.createStatement();
            ResultSet set = stmt.executeQuery("SELECT * FROM " + this.prefix + "rights");
            LRUCache<Integer, Protection> cache = new LRUCache<Integer, Protection>(100000);
            while (set.next()) {
                int protectionId = set.getInt("chest");
                String entity = set.getString("entity");
                int access = set.getInt("rights");
                int type = set.getInt("type");
                Protection protection = null;
                if (cache.containsKey(protectionId)) {
                    protection = (Protection)cache.get(protectionId);
                } else {
                    protection = this.loadProtection(protectionId);
                    if (protection == null) continue;
                    cache.put(protectionId, protection);
                }
                if (protection == null) continue;
                Permission permission = new Permission(entity, Permission.Type.values()[type], Permission.Access.values()[access]);
                protection.addPermission(permission);
            }
            for (Protection protection : cache.values()) {
                protection.saveNow();
            }
            set.close();
            stmt.close();
            this.dropTable(this.prefix + "rights");
            this.precache();
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void doUpdate400_4() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute("SELECT data FROM " + this.prefix + "protections LIMIT 1");
        }
        catch (SQLException e) {
            this.dropColumn(this.prefix + "protections", "rights");
            this.addColumn(this.prefix + "protections", "data", "TEXT");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate400_5() {
        Statement statement = null;
        try {
            Flag flag;
            statement = this.connection.createStatement();
            statement.executeQuery("SELECT flags FROM " + this.prefix + "protections LIMIT 1");
            PreparedStatement pStatement = this.prepare("SELECT * FROM " + this.prefix + "protections WHERE flags = 8");
            for (Protection protection : this.resolveProtections(pStatement)) {
                flag = new Flag(Flag.Type.EXEMPTION);
                protection.addFlag(flag);
                protection.save();
            }
            pStatement = this.prepare("SELECT * FROM " + this.prefix + "protections WHERE flags = 3");
            for (Protection protection : this.resolveProtections(pStatement)) {
                flag = new Flag(Flag.Type.MAGNET);
                protection.addFlag(flag);
                protection.save();
            }
            pStatement = this.prepare("SELECT * FROM " + this.prefix + "protections WHERE flags = 2");
            for (Protection protection : this.resolveProtections(pStatement)) {
                flag = new Flag(Flag.Type.REDSTONE);
                protection.addFlag(flag);
                protection.save();
            }
            this.dropColumn(this.prefix + "protections", "flags");
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void doUpdate400_6() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT x FROM " + this.prefix + "history LIMIT 1");
            rs.close();
        }
        catch (SQLException e) {
            this.addColumn(this.prefix + "history", "x", "INTEGER");
            this.addColumn(this.prefix + "history", "y", "INTEGER");
            this.addColumn(this.prefix + "history", "z", "INTEGER");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate5_0_12() {
        Statement statement = null;
        try {
            ResultSet rs;
            statement = this.connection.createStatement();
            try {
                rs = statement.executeQuery("SELECT blockId FROM " + this.prefix + "protections LIMIT 1");
                rs.close();
            }
            catch (SQLException e) {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return;
            }
            rs = statement.executeQuery("SELECT id FROM " + this.prefix + "blocks LIMIT 1");
            rs.close();
        }
        catch (SQLException e) {
            LWC.getInstance().getPlugin().getLogger().info("Creating block mappings table");
            Table blockMappings = new Table(this, "blocks");
            Column column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            column.setAutoIncrement(false);
            blockMappings.add(column);
            column = new Column("name");
            column.setType("VARCHAR(40)");
            blockMappings.add(column);
            blockMappings.execute();
            try {
                statement.executeUpdate("UPDATE " + this.prefix + "protections SET blockId = -1 WHERE blockId IS NULL");
                ResultSet rs = statement.executeQuery("SELECT DISTINCT blockId FROM " + this.prefix + "protections");
                PreparedStatement insertSmt = this.prepare("INSERT INTO " + this.prefix + "blocks (`id`,`name`) VALUES (?, ?)");
                while (rs.next()) {
                    int id = rs.getInt("blockId");
                    if (id < 0 || id == 5000) continue;
                    Material mat = Material.matchMaterial((String)Integer.toString(id));
                    if (mat != null) {
                        insertSmt.setInt(1, id);
                        insertSmt.setString(2, mat.name());
                        insertSmt.executeUpdate();
                        continue;
                    }
                    this.mergeBlockMapping(id, -1);
                }
                rs.close();
            }
            catch (SQLException e2) {
                this.printException(e2);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdateModernLWC() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT DISTINCT blockName FROM " + this.prefix + "protections");
            LWC.getInstance().getPlugin().getLogger().info("Upgrading from ModernLWC");
            try {
                PreparedStatement updateSmt = this.prepare("UPDATE " + this.prefix + "protections SET blockId = ? WHERE blockName = ?");
                HashSet<String> typeMap = new HashSet<String>();
                typeMap.add("Entity");
                for (EntityType e : EntityType.values()) {
                    typeMap.add(e.name());
                }
                while (rs.next()) {
                    String blockName = rs.getString(1);
                    if (!typeMap.contains(blockName)) continue;
                    updateSmt.setInt(1, 5000);
                    updateSmt.setString(2, blockName);
                    updateSmt.executeUpdate();
                }
                rs.close();
                statement.executeUpdate("ALTER TABLE " + this.prefix + "protections DROP COLUMN blockName");
                statement.executeUpdate("UPDATE " + this.prefix + "protections SET blockId = -1 WHERE blockId IS NULL");
            }
            catch (SQLException e) {
                this.printException(e);
            }
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    private void doUpdatedDatabaseVersion7() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "protections` CHANGE `owner` `owner` VARCHAR(36)");
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "protections` CHANGE `world` `world` VARCHAR(50)");
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "protections` CHANGE `date` `date` VARCHAR(50)");
            statement.executeUpdate("ALTER TABLE `" + this.prefix + "history` CHANGE `owner` `owner` VARCHAR(36)");
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Integer, String> loadBlockMappings() {
        HashMap<Integer, String> rv = new HashMap<Integer, String>();
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT `id`,`name` FROM " + this.prefix + "blocks");
            while (rs.next()) {
                rv.put(rs.getInt(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            this.printException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return rv;
    }

    public void addBlockMapping(int id, String name) {
        try {
            PreparedStatement insertSmt = this.prepare("INSERT INTO " + this.prefix + "blocks (`id`,`name`) VALUES (?, ?)");
            insertSmt.setInt(1, id);
            insertSmt.setString(2, name);
            insertSmt.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void updateBlockMappingName(int id, String name) {
        try {
            PreparedStatement insertSmt = this.prepare("UPDATE " + this.prefix + "blocks SET name = ? WHERE id = ?");
            insertSmt.setString(1, name);
            insertSmt.setInt(2, id);
            insertSmt.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }

    public void mergeBlockMapping(int oldid, int newid) {
        try {
            PreparedStatement updateSmt = this.prepare("UPDATE " + this.prefix + "protections SET blockId = ? WHERE blockId = ?");
            updateSmt.setInt(1, newid);
            updateSmt.setInt(2, oldid);
            int updated = updateSmt.executeUpdate();
            LWC.getInstance().getPlugin().getLogger().info("Updated " + updated + " protections!");
            PreparedStatement insertSmt = this.prepare("DELETE FROM " + this.prefix + "blocks WHERE id = ?");
            insertSmt.setInt(1, oldid);
            insertSmt.executeUpdate();
        }
        catch (SQLException e) {
            this.printException(e);
        }
    }
}

