/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.pluginsupport;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.util.config.Configuration;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.permission.RegionPermissionModel;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuard
extends JavaModule {
    private Configuration configuration = Configuration.load("worldguard.yml");
    private WorldGuardPlugin worldGuard = null;

    @Override
    public void load(LWC lwc) {
        Plugin plugin = lwc.getPlugin().getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin != null) {
            this.worldGuard = (WorldGuardPlugin)plugin;
        }
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("purgeregion") && !args[0].equals("protectregion")) {
            return;
        }
        String commandName = args[0];
        event.setCancelled(true);
        if (this.worldGuard == null) {
            sender.sendMessage("\u00a74WorldGuard is not enabled.");
            return;
        }
        if (args.length < 2) {
            lwc.sendSimpleUsage(sender, "/lwc admin " + commandName + " <RegionName> [World]");
            return;
        }
        if (!(sender instanceof Player) && args.length < 3) {
            sender.sendMessage("\u00a74You must specify the world name the region is in since you are not logged in as a player.");
            return;
        }
        String regionName = args[1];
        String worldName = args.length > 2 ? args[2] : "";
        org.bukkit.World world = !worldName.isEmpty() ? lwc.getPlugin().getServer().getWorld(worldName) : ((Player)sender).getWorld();
        if (world == null) {
            sender.sendMessage("\u00a74Invalid world.");
            return;
        }
        RegionManager regionManager = com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)world));
        ProtectedRegion region = regionManager.getRegion(regionName);
        if (region == null) {
            sender.sendMessage("\u00a74Region not found. If you region is in a different world than you, please use: /lwc admin " + commandName + " " + regionName + " WorldName");
            return;
        }
        BlockVector3 minimum = region.getMinimumPoint();
        BlockVector3 maximum = region.getMaximumPoint();
        int minBlockX = minimum.getBlockX();
        int minBlockY = minimum.getBlockY();
        int minBlockZ = minimum.getBlockZ();
        int maxBlockX = maximum.getBlockX();
        int maxBlockY = maximum.getBlockY();
        int maxBlockZ = maximum.getBlockZ();
        if (args[0].equals("purgeregion")) {
            List<Protection> protections = lwc.getPhysicalDatabase().loadProtections(world.getName(), minBlockX, maxBlockX, minBlockY, maxBlockY, minBlockZ, maxBlockZ);
            for (Protection protection : protections) {
                protection.remove();
            }
            sender.sendMessage("\u00a72Removed " + protections.size() + " protections from the region " + regionName);
        } else if (args[0].equals("protectregion")) {
            String ownerName = "LWCWorldGuard";
            int registered = 0;
            for (int x = minBlockX; x <= maxBlockX; ++x) {
                for (int y = minBlockY; y <= maxBlockY; ++y) {
                    for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                        Block block = world.getBlockAt(x, y, z);
                        if (!lwc.isProtectable(block) || lwc.findProtection(block.getLocation()) != null) continue;
                        lwc.getPhysicalDatabase().registerProtection(block.getType(), Protection.Type.PRIVATE, world.getName(), ownerName, "", x, y, z);
                        ++registered;
                    }
                }
            }
            sender.sendMessage("Registered " + registered + " blocks in the region " + regionName);
            sender.sendMessage("Currently, the owner of these protections is \"" + ownerName + "\". To change this to someone else, run:");
            sender.sendMessage("/lwc admin updateprotections set owner = 'NewOwner' where owner = '" + ownerName + "'");
        }
    }

    @Override
    public void onAccessRequest(LWCAccessEvent event) {
        if (event.getAccess() != Permission.Access.NONE) {
            return;
        }
        if (this.worldGuard == null) {
            return;
        }
        if (!this.configuration.getBoolean("worldguard.enabled", false)) {
            return;
        }
        if (!this.configuration.getBoolean("worldguard.allowRegionPermissions", true)) {
            return;
        }
        Protection protection = event.getProtection();
        LocalPlayer wgPlayer = this.worldGuard.wrapPlayer(event.getPlayer());
        for (Permission permission : protection.getPermissions()) {
            if (permission.getType() != Permission.Type.REGION) continue;
            String regionName = permission.getName();
            if (regionName.equalsIgnoreCase("#this")) {
                if (!this.canBuild(event.getPlayer(), protection.getBlock())) {
                    continue;
                }
            } else {
                ProtectedRegion region;
                RegionManager regionManager;
                org.bukkit.World world;
                int c = regionName.indexOf(58);
                if (c < 0) {
                    world = protection.getBukkitWorld();
                } else {
                    String worldName = regionName.substring(c + 1);
                    world = event.getLWC().getPlugin().getServer().getWorld(worldName);
                    regionName = regionName.substring(0, c);
                }
                if (world == null || (regionManager = com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)world))) == null || (region = regionManager.getRegion(regionName)) == null || !region.isMember(wgPlayer)) continue;
            }
            if (permission.getAccess().ordinal() <= event.getAccess().ordinal()) continue;
            event.setAccess(permission.getAccess());
            if (event.getAccess().ordinal() < Permission.Access.ADMIN.ordinal()) continue;
            return;
        }
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        block5: {
            List regions;
            Player player;
            LWC lwc;
            block4: {
                if (this.worldGuard == null) {
                    return;
                }
                if (!this.configuration.getBoolean("worldguard.enabled", false)) {
                    return;
                }
                lwc = event.getLWC();
                player = event.getPlayer();
                Block block = event.getBlock();
                RegionManager regionManager = com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)block.getWorld()));
                if (this.configuration.getBoolean("worldguard.requireBuildRights", true) && !this.canBuild(player, block)) {
                    lwc.sendLocale((CommandSender)player, "lwc.worldguard.needbuildrights", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                BlockVector3 vector = BukkitAdapter.asBlockVector((Location)block.getLocation());
                regions = regionManager.getApplicableRegionsIDs(vector);
                if (regions.size() != 0) break block4;
                if (this.configuration.getBoolean("worldguard.allowProtectionsOutsideRegions", true)) break block5;
                lwc.sendLocale((CommandSender)player, "lwc.worldguard.notallowed", new Object[0]);
                event.setCancelled(true);
                break block5;
            }
            for (String region : regions) {
                if (!this.isRegionBlacklisted(region)) continue;
                lwc.sendLocale((CommandSender)player, "lwc.worldguard.blacklisted", new Object[0]);
                event.setCancelled(true);
                break;
            }
        }
    }

    private boolean canBuild(Player player, Block block) {
        World wgWorld;
        LocalPlayer wgPlayer = this.worldGuard.wrapPlayer(player);
        if (new RegionPermissionModel((Actor)wgPlayer).mayIgnoreRegionProtection(wgWorld = BukkitAdapter.adapt((org.bukkit.World)block.getWorld()))) {
            return true;
        }
        RegionQuery query = com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        return query.testBuild(BukkitAdapter.adapt((Location)block.getLocation()), wgPlayer, new StateFlag[0]);
    }

    private boolean isRegionBlacklisted(String region) {
        if (!this.isRegionAllowed(region)) {
            return true;
        }
        List<String> blacklistedRegions = this.configuration.getStringList("worldguard.blacklistedRegions", new ArrayList<String>());
        return blacklistedRegions.contains("*") || blacklistedRegions.contains(region);
    }

    private boolean isRegionAllowed(String region) {
        List<String> allowedRegions = this.configuration.getStringList("worldguard.regions", new ArrayList<String>());
        return allowedRegions.contains("*") || allowedRegions.contains(region);
    }

    public void set(String path, Object value) {
        this.configuration.setProperty(path, value);
    }

    public boolean save() {
        return this.configuration.save();
    }
}

