/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.cache.CacheKey;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import com.griefcraft.util.BlockUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class LWCBlockListener
implements Listener {
    private LWCPlugin plugin;
    private final HashSet<Material> blacklistedBlocks = new HashSet();
    public static final BlockFace[] POSSIBLE_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    public LWCBlockListener(LWCPlugin plugin) {
        this.plugin = plugin;
        this.loadAndProcessConfig();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        Protection protection = lwc.findProtection(block.getLocation());
        if (protection == null) {
            return;
        }
        LWCRedstoneEvent evt = new LWCRedstoneEvent(event, protection);
        lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = LWC.getInstance();
        List blocks = event.getBlocks();
        for (BlockState newblock : blocks) {
            Protection protection;
            Block block = newblock.getBlock();
            if (!lwc.isProtectable(block) || (protection = lwc.findProtection(block)) == null) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block == null) {
            return;
        }
        Protection protection = lwc.findProtection(block.getLocation());
        if (protection == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtection(player, protection);
        if (!canAccess) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block doubleChest;
        Protection protection;
        CacheKey cacheKey;
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        boolean ignoreBlockDestruction = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreBlockDestruction"));
        if (ignoreBlockDestruction) {
            return;
        }
        ProtectionCache cache = lwc.getProtectionCache();
        if (cache.isKnownNull(cacheKey = ProtectionCache.cacheKey(block.getLocation()))) {
            cache.remove(cacheKey);
        }
        if ((protection = lwc.findProtection(block.getLocation())) == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtection(player, protection);
        boolean canAdmin = lwc.canAdminProtection(player, protection);
        if (lwc.canDestoryProtection(player, protection) && (doubleChest = BlockUtil.findAdjacentDoubleChest(block)) != null) {
            protection.setBlockMaterial(doubleChest.getType());
            protection.setX(doubleChest.getX());
            protection.setY(doubleChest.getY());
            protection.setZ(doubleChest.getZ());
            protection.saveNow();
            protection.radiusRemoveCache();
            if (protection.getProtectionFinder() != null) {
                protection.getProtectionFinder().removeBlock(block.getState());
            }
            lwc.getProtectionCache().addProtection(protection);
            return;
        }
        try {
            LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, LWCProtectionDestroyEvent.Method.BLOCK_DESTRUCTION, canAccess, canAdmin);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled() || !canAccess) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            lwc.logAndPrintInternalException(player, "BLOCK_BREAK", e, protection);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        LWC lwc = this.plugin.getLWC();
        for (BlockState state : event.getReplacedBlockStates()) {
            Protection protection = lwc.findProtection(state);
            if (protection == null || lwc.canAccessProtection(event.getPlayer(), protection)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        for (Block moved : event.getBlocks()) {
            if (lwc.findProtection(moved) == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        for (Block moved : event.getBlocks()) {
            if (lwc.findProtection(moved) == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!LWC.ENABLED || event.isCancelled()) {
            return;
        }
        LWC lwc = LWC.getInstance();
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            boolean ignoreExplosions;
            Block block = (Block)it.next();
            Protection protection = this.plugin.getLWC().findProtection(block);
            if (protection == null || (ignoreExplosions = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "ignoreExplosions"))) || protection.hasFlag(Flag.Type.ALLOWEXPLOSIONS)) continue;
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        Block block = event.getToBlock();
        Protection protection = this.plugin.getLWC().findProtection(block);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        Block block = event.getBlock();
        Protection protection = this.plugin.getLWC().findProtection(block);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        boolean blockIsBlacklisted;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        Location location = block.getLocation();
        ProtectionCache cache = lwc.getProtectionCache();
        CacheKey cacheKey = ProtectionCache.cacheKey(location);
        if (lwc.isProtectable(event.getBlockReplacedState())) {
            existingProtection = lwc.findProtection(block);
            if (existingProtection != null && block.getType() == Material.LECTERN && event.getBlockReplacedState().getType() == Material.LECTERN) {
                return;
            }
            if (!lwc.canAdminProtection(player, existingProtection)) {
                event.setCancelled(true);
                return;
            }
        } else {
            existingProtection = lwc.getPhysicalDatabase().loadProtection(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
            if (existingProtection != null) {
                existingProtection.remove();
            }
        }
        if (cache.isKnownNull(cacheKey)) {
            cache.remove(cacheKey);
        }
        if (blockIsBlacklisted = this.blacklistedBlocks.contains(block.getType())) {
            for (Protection protection : lwc.findAdjacentProtectionsOnAllSides(block, new Block[0])) {
                if (protection == null || lwc.canAccessProtection(player, protection) && (protection.getType() != Protection.Type.DONATION && protection.getType() != Protection.Type.SHOWCASE || lwc.canAdminProtection(player, protection))) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlaceMonitor(BlockPlaceEvent event) {
        Protection.Type type;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        Protection current = lwc.findProtection(block.getLocation());
        if (current != null) {
            if (!current.isBlockInWorld()) {
                lwc.log("Removing corrupted protection: " + String.valueOf(current));
                current.remove();
            } else {
                if (current.getProtectionFinder() != null) {
                    current.getProtectionFinder().fullMatchBlocks();
                    lwc.getProtectionCache().addProtection(current);
                }
                return;
            }
        }
        if (!lwc.isProtectable(block)) {
            return;
        }
        String autoRegisterType = lwc.resolveProtectionConfiguration(block, "autoRegister");
        if (!(autoRegisterType.equalsIgnoreCase("private") || autoRegisterType.equalsIgnoreCase("public") || autoRegisterType.equalsIgnoreCase("donation") || autoRegisterType.equalsIgnoreCase("showcase"))) {
            return;
        }
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + autoRegisterType, "lwc.create", "lwc.protect")) {
            return;
        }
        try {
            type = Protection.Type.matchType(autoRegisterType);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (type == null) {
            player.sendMessage("\u00a74LWC_INVALID_CONFIG_autoRegister");
            return;
        }
        Block connectedChest = BlockUtil.findAdjacentDoubleChest(block);
        if (connectedChest != null && lwc.findProtection(connectedChest.getLocation()) != null) {
            return;
        }
        Protection protection = null;
        try {
            LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, block);
            lwc.getModuleLoader().dispatchEvent(evt);
            if (evt.isCancelled()) {
                return;
            }
            protection = lwc.getPhysicalDatabase().registerProtection(block.getType(), type, block.getWorld().getName(), player.getUniqueId().toString(), "", block.getX(), block.getY(), block.getZ());
            if (!Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "quiet"))) {
                lwc.sendLocale((CommandSender)player, "protection.onplace.create.finalize", "type", lwc.getPlugin().getMessageParser().parseMessage(autoRegisterType.toLowerCase(), new Object[0]), "block", LWC.materialToString(block));
            }
            if (protection != null) {
                lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
            }
        }
        catch (Exception e) {
            lwc.logAndPrintInternalException(player, "BLOCK_PLACE", e, protection);
        }
    }

    public void loadAndProcessConfig() {
        List<String> ids = LWC.getInstance().getConfiguration().getStringList("optional.blacklistedBlocks", new ArrayList<String>());
        for (String sId : ids) {
            Material mat = Material.matchMaterial((String)sId);
            if (mat == null) {
                this.plugin.getLogger().log(Level.SEVERE, "Invalid block name in optional.blacklistedBlocks: " + sId);
                continue;
            }
            this.blacklistedBlocks.add(mat);
        }
    }
}

