/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.model;

import com.griefcraft.cache.CacheKey;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.cache.StringCache;
import com.griefcraft.lwc.BlockMap;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.History;
import com.griefcraft.model.Permission;
import com.griefcraft.scripting.event.LWCProtectionRemovePostEvent;
import com.griefcraft.util.ProtectionFinder;
import com.griefcraft.util.StringUtil;
import com.griefcraft.util.TimeUtil;
import com.griefcraft.util.UUIDRegistry;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Protection {
    private Set<History> historyCache = null;
    private Set<Permission> permissions = null;
    private Map<Flag.Type, Flag> flags = null;
    private int blockId;
    private String password;
    private int id;
    private UUID owner;
    private String legacyOwner;
    private Type type;
    private String world;
    private int x;
    private int y;
    private int z;
    private UUID entityId;
    private long lastAccessed;
    private long creation;
    private boolean removed = false;
    private boolean removing = false;
    private boolean modified = false;
    private ProtectionFinder finder;
    private Block cachedBlock;
    private CacheKey cacheKey;
    private Material blockMaterial;
    private boolean isEntity;

    public boolean equals(Object object) {
        if (!(object instanceof Protection)) {
            return false;
        }
        Protection other = (Protection)object;
        return this.id == other.id && this.x == other.x && this.y == other.y && this.z == other.z && Objects.equals(this.owner, other.owner) && Objects.equals(this.legacyOwner, other.legacyOwner) && Objects.equals(this.world, other.world);
    }

    public int hashCode() {
        int hash = 17;
        hash *= 37 + this.id;
        hash *= 37 + this.x;
        hash *= 37 + this.y;
        hash *= 37 + this.z;
        hash = (int)((long)hash * (37L + this.creation));
        return hash;
    }

    public boolean convertPlayerNamesToUUIDs() {
        UUID uuid;
        if (!this.needsUUIDConversion()) {
            return false;
        }
        boolean res = false;
        if (this.legacyOwner != null && (uuid = UUIDRegistry.getUUID(this.legacyOwner)) != null) {
            this.setOwner(uuid);
            res = true;
        }
        if (this.permissions != null) {
            for (Permission permission : this.permissions) {
                UUID uuid2;
                if (permission.getType() != Permission.Type.PLAYER || UUIDRegistry.isValidUUID(permission.getName()) || (uuid2 = UUIDRegistry.getUUID(permission.getName())) == null) continue;
                permission.setName(uuid2.toString());
                this.modified = true;
                res = true;
            }
        }
        return res;
    }

    public boolean needsUUIDConversion() {
        if (this.legacyOwner != null) {
            return true;
        }
        if (this.permissions != null) {
            for (Permission permission : this.permissions) {
                if (permission.getType() != Permission.Type.PLAYER || UUIDRegistry.isValidUUID(permission.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getFormattedOwnerPlayerName() {
        return this.owner != null ? UUIDRegistry.formatPlayerName(this.owner) : UUIDRegistry.formatPlayerName(this.legacyOwner);
    }

    public void checkHistory(History history) {
        if (this.historyCache == null) {
            this.historyCache = new HashSet<History>();
        }
        if (!this.historyCache.contains(history)) {
            this.historyCache.add(history);
        }
    }

    public boolean isOwner(Player player) {
        LWC lwc = LWC.getInstance();
        if (this.isRealOwner(player)) {
            return true;
        }
        return lwc.isAdmin(player);
    }

    public boolean isRealOwner(Player player) {
        if (player == null) {
            return false;
        }
        if (this.owner != null) {
            return this.owner.equals(player.getUniqueId());
        }
        return this.legacyOwner != null && this.legacyOwner.equalsIgnoreCase(player.getName());
    }

    public History createHistoryObject() {
        History history = new History();
        history.setProtectionId(this.id);
        history.setProtection(this);
        history.setStatus(History.Status.INACTIVE);
        history.setX(this.x);
        history.setY(this.y);
        history.setZ(this.z);
        if (this.historyCache == null) {
            this.historyCache = new HashSet<History>();
        }
        this.historyCache.add(history);
        return history;
    }

    public Set<History> getRelatedHistory() {
        if (this.historyCache == null) {
            this.historyCache = new HashSet<History>();
            this.historyCache.addAll(LWC.getInstance().getPhysicalDatabase().loadHistory(this));
        }
        return Collections.unmodifiableSet(this.historyCache);
    }

    public List<History> getRelatedHistory(History.Type type) {
        ArrayList<History> matches = new ArrayList<History>();
        Set<History> relatedHistory = this.getRelatedHistory();
        for (History history : relatedHistory) {
            if (history.getType() != type) continue;
            matches.add(history);
        }
        return matches;
    }

    public boolean hasFlag(Flag.Type type) {
        return this.flags != null && this.flags.containsKey((Object)type);
    }

    public Flag getFlag(Flag.Type type) {
        return this.flags != null ? this.flags.get((Object)type) : null;
    }

    public boolean addFlag(Flag flag) {
        if (this.removed || flag == null) {
            return false;
        }
        if (this.flags == null) {
            this.flags = new HashMap<Flag.Type, Flag>();
        }
        if (!this.flags.containsKey((Object)flag.getType())) {
            this.flags.put(flag.getType(), flag);
            this.modified = true;
            return true;
        }
        return false;
    }

    public void removeFlag(Flag flag) {
        if (this.removed || flag == null || this.flags == null) {
            return;
        }
        this.flags.remove((Object)flag.getType());
        if (this.flags.isEmpty()) {
            this.flags = null;
        }
        this.modified = true;
    }

    public Permission.Access getAccess(String name, Permission.Type type) {
        if (this.permissions != null) {
            for (Permission permission : this.permissions) {
                if (permission.getType() != type || !permission.getName().equalsIgnoreCase(name)) continue;
                return permission.getAccess();
            }
        }
        return Permission.Access.NONE;
    }

    public List<Permission> getPermissions() {
        return this.permissions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Permission>(this.permissions));
    }

    public void removeTemporaryPermissions() {
        if (this.permissions != null) {
            Iterator<Permission> iter = this.permissions.iterator();
            while (iter.hasNext()) {
                Permission permission = iter.next();
                if (!permission.isVolatile()) continue;
                iter.remove();
            }
            if (this.permissions.isEmpty()) {
                this.permissions = null;
            }
        }
    }

    public void addPermission(Permission permission) {
        if (this.removed || permission == null) {
            return;
        }
        this.removePermissions(permission.getName(), permission.getType());
        if (this.permissions == null) {
            this.permissions = new HashSet<Permission>();
        }
        this.permissions.add(permission);
        this.modified = true;
    }

    public void removePermissions(String name, Permission.Type type) {
        if (this.removed || this.permissions == null || type == null) {
            return;
        }
        Iterator<Permission> iter = this.permissions.iterator();
        while (iter.hasNext()) {
            Permission permission = iter.next();
            if (!permission.getName().equals(name) && !name.equals("*") || permission.getType() != type) continue;
            iter.remove();
            this.modified = true;
        }
        if (this.permissions.isEmpty()) {
            this.permissions = null;
        }
    }

    public void removeAllPermissions() {
        this.permissions = null;
        this.modified = true;
    }

    public boolean isBlockInWorld() {
        Material storedBlockId = this.getBlockMaterial();
        Block block = this.getBlock();
        return storedBlockId == null || storedBlockId == block.getType();
    }

    public JSONObject getData() {
        JSONArray root;
        JSONObject data = null;
        if (this.permissions != null && !this.permissions.isEmpty()) {
            root = new JSONArray();
            for (Permission permission : this.permissions) {
                if (permission == null) continue;
                root.add((Object)permission.encodeToJSON());
            }
            data = new JSONObject();
            data.put((Object)"rights", (Object)root);
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            root = new JSONArray();
            for (Flag flag : this.flags.values()) {
                if (flag == null) continue;
                root.add((Object)flag.getData());
            }
            if (data == null) {
                data = new JSONObject();
            }
            data.put((Object)"flags", (Object)root);
        }
        return data;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public Material getBlockMaterial() {
        return this.blockMaterial;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCreation() {
        return new Timestamp(this.creation).toString();
    }

    public long getCreationTime() {
        return this.creation;
    }

    public void setCreationTime(long time) {
        this.creation = time;
    }

    public int getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner != null ? this.owner.toString() : this.legacyOwner;
    }

    public String getOwnerName() {
        return this.owner != null ? UUIDRegistry.getName(this.owner) : this.legacyOwner;
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public boolean hasSameOwner(Protection other) {
        return Objects.equals(this.owner, other.owner) && Objects.equals(this.legacyOwner, other.legacyOwner);
    }

    public Type getType() {
        return this.type;
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setBlockMaterial(Material material) {
        if (this.removed) {
            return;
        }
        this.blockId = material == null ? -1 : BlockMap.instance().registerOrGetId(material);
        this.blockMaterial = material;
        this.isEntity = false;
        this.modified = true;
    }

    public void setPassword(String password) {
        if (this.removed) {
            return;
        }
        this.password = password;
        this.modified = true;
    }

    public void setCreation(String creation) {
        if (this.removed) {
            return;
        }
        this.creation = Timestamp.valueOf(creation).getTime();
        this.modified = true;
    }

    public void setId(int id) {
        if (this.removed) {
            return;
        }
        this.id = id;
        this.modified = true;
    }

    public void setOwner(String owner) {
        if (this.removed) {
            return;
        }
        if (UUIDRegistry.isValidUUID(owner)) {
            this.owner = UUID.fromString(owner);
            this.legacyOwner = null;
        } else {
            this.owner = null;
            this.legacyOwner = owner;
        }
        this.modified = true;
    }

    public void setOwner(UUID owner) {
        if (this.removed) {
            return;
        }
        this.legacyOwner = null;
        this.owner = owner;
        this.modified = true;
    }

    public void setType(Type type) {
        if (this.removed) {
            return;
        }
        this.type = type;
        this.modified = true;
    }

    public void setWorld(String world) {
        if (this.removed) {
            return;
        }
        this.world = StringCache.intern(world);
        this.modified = true;
        this.cacheKey = null;
    }

    public void setX(int x) {
        if (this.removed) {
            return;
        }
        this.x = x;
        this.modified = true;
        this.cacheKey = null;
    }

    public void setY(int y) {
        if (this.removed) {
            return;
        }
        this.y = y;
        this.modified = true;
        this.cacheKey = null;
    }

    public void setZ(int z) {
        if (this.removed) {
            return;
        }
        this.z = z;
        this.modified = true;
        this.cacheKey = null;
    }

    public void setLastAccessed(long lastAccessed) {
        if (this.removed) {
            return;
        }
        this.lastAccessed = lastAccessed;
        this.modified = true;
    }

    public void setProtectionFinder(ProtectionFinder finder) {
        this.finder = finder;
    }

    public ProtectionFinder getProtectionFinder() {
        return this.finder;
    }

    public void remove() {
        if (this.removed) {
            return;
        }
        LWC lwc = LWC.getInstance();
        this.removeTemporaryPermissions();
        this.modified = false;
        this.removing = true;
        lwc.getModuleLoader().dispatchEvent(new LWCProtectionRemovePostEvent(this));
        for (History history : this.getRelatedHistory(History.Type.TRANSACTION)) {
            if (history.getStatus() != History.Status.ACTIVE) continue;
            history.setStatus(History.Status.INACTIVE);
        }
        this.checkAndSaveHistory();
        this.removed = true;
        lwc.getPhysicalDatabase().removeProtection(this.id);
        this.removeCache();
    }

    public void removeCache() {
        LWC lwc = LWC.getInstance();
        lwc.getProtectionCache().removeProtection(this);
        this.radiusRemoveCache();
    }

    public void radiusRemoveCache() {
        if (this.isEntity()) {
            return;
        }
        ProtectionCache cache = LWC.getInstance().getProtectionCache();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    CacheKey cacheKey = ProtectionCache.cacheKey(this.world, this.x + x, this.y + y, this.z + z);
                    Protection protection = cache.getProtection(cacheKey);
                    if ((protection == null || this.id != protection.getId()) && protection != null) continue;
                    cache.remove(cacheKey);
                }
            }
        }
    }

    public void save() {
        if (this.removed) {
            return;
        }
        this.saveNow();
    }

    public void saveLastAccessed() {
        if (this.removed) {
            return;
        }
        LWC.getInstance().getPhysicalDatabase().saveProtectionLastAccessed(this);
    }

    public void saveNow() {
        if (this.removed) {
            return;
        }
        if (this.modified && !this.removing) {
            LWC.getInstance().getPhysicalDatabase().saveProtection(this);
        }
        this.checkAndSaveHistory();
    }

    public void checkAndSaveHistory() {
        if (this.removed) {
            return;
        }
        for (History history : this.getRelatedHistory()) {
            if (!history.wasModified()) continue;
            history.saveNow();
        }
    }

    public CacheKey getCacheKey() {
        CacheKey cc = this.cacheKey;
        if (cc == null) {
            this.cacheKey = cc = ProtectionCache.cacheKey(this.world, this.x, this.y, this.z);
        }
        return cc;
    }

    public World getBukkitWorld() {
        if (this.world == null || this.world.isEmpty()) {
            return (World)Bukkit.getServer().getWorlds().get(0);
        }
        return Bukkit.getServer().getWorld(this.world);
    }

    public Player getBukkitOwner() {
        return this.owner != null ? Bukkit.getServer().getPlayer(this.owner) : Bukkit.getServer().getPlayer(this.legacyOwner);
    }

    public void uncacheBlock() {
        this.cachedBlock = null;
    }

    public Block getBlock() {
        if (this.cachedBlock != null) {
            return this.cachedBlock;
        }
        if (this.entityId != null || this.getBlockId() == 5000) {
            return null;
        }
        World world = this.getBukkitWorld();
        if (world == null) {
            return null;
        }
        this.cachedBlock = world.getBlockAt(this.x, this.y, this.z);
        return this.cachedBlock;
    }

    public String toString() {
        Object lastAccessed;
        Object flagStr = "";
        if (this.flags != null) {
            for (Flag flag : this.flags.values()) {
                flagStr = (String)flagStr + flag.toString() + ",";
            }
        }
        if (((String)flagStr).endsWith(",")) {
            flagStr = ((String)flagStr).substring(0, ((String)flagStr).length() - 1);
        }
        if (!((String)(lastAccessed = TimeUtil.timeToString(System.currentTimeMillis() / 1000L - this.lastAccessed))).equals("Not yet known")) {
            lastAccessed = (String)lastAccessed + " ago";
        }
        String creationString = new Timestamp(this.creation).toString();
        return String.format("%s %s\u00a7f \u00a72Id=%d Location=[%s %d,%d,%d] Created=%s Flags=%s LastAccessed=%s", this.typeToString(), this.blockId > 0 ? LWC.materialToString(this.blockMaterial) : "Not yet cached", this.id, this.world, this.x, this.y, this.z, creationString, flagStr, lastAccessed);
    }

    public String toShortString() {
        Object lastAccessed = TimeUtil.timeToString(System.currentTimeMillis() / 1000L - this.lastAccessed);
        if (!((String)lastAccessed).equals("Not yet known")) {
            lastAccessed = (String)lastAccessed + " ago";
        }
        String creationString = new Timestamp(this.creation).toString();
        return String.format("\u00a72Created: %s; LastAccessed: %s", creationString, lastAccessed);
    }

    public String typeToString() {
        return StringUtil.capitalizeFirstLetter(this.type.toString());
    }

    public void setIsEntity(boolean isEntity) {
        this.isEntity = isEntity;
        this.blockId = 5000;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
        if (this.entityId != null) {
            this.isEntity = true;
        }
        this.modified = true;
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public static enum Type {
        PUBLIC,
        PASSWORD,
        PRIVATE,
        RESERVED1,
        RESERVED2,
        DONATION,
        SHOWCASE;


        public static Type matchType(String text) {
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(text)) continue;
                return type;
            }
            throw new IllegalArgumentException("No Protection Type found for given type: " + text);
        }
    }
}

