/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.migration;

import com.griefcraft.lwc.LWC;
import com.griefcraft.migration.MigrationUtility;
import com.griefcraft.modules.pluginsupport.WorldGuard;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ConfigPost300
implements MigrationUtility {
    private static Logger logger = Logger.getLogger("Patcher");
    private static Map<String, String> mappings = null;

    @Override
    public void run() {
        String enforceWorldGuard;
        LWC lwc = LWC.getInstance();
        File configFile = new File("plugins/LWC/lwc.properties");
        if (!configFile.exists()) {
            return;
        }
        new File("plugins/LWC/internal.ini").delete();
        logger.info("Converting lwc.properties to new variants");
        ConfigPost300.populate();
        Properties old = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            old.load(inputStream);
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String[] oldKey = entry.getKey();
            String newKey = entry.getValue();
            try {
                lwc.getConfiguration().setProperty(newKey, Integer.parseInt(old.getProperty((String)oldKey, "")));
            }
            catch (Exception e) {
                String value = old.getProperty((String)oldKey, "");
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                    lwc.getConfiguration().setProperty(newKey, Boolean.parseBoolean(old.getProperty((String)oldKey, "")));
                    continue;
                }
                lwc.getConfiguration().setProperty(newKey, old.getProperty((String)oldKey, ""));
            }
        }
        String protectionBlacklist = old.getProperty("protection-blacklist", "").trim();
        if (!protectionBlacklist.isEmpty()) {
            String[] split;
            for (String protection : split = protectionBlacklist.replaceAll(" ", "_").split(",")) {
                lwc.getConfiguration().setProperty("protections.blocks." + protection + ".enabled", false);
            }
        }
        if (Boolean.parseBoolean(enforceWorldGuard = old.getProperty("enforce-worldguard-regions"))) {
            WorldGuard worldGuard = (WorldGuard)lwc.getModuleLoader().getModule(WorldGuard.class);
            List<String> regions = null;
            String oldRegions = old.getProperty("worldguard-allowed-regions");
            regions = Arrays.asList(oldRegions.split(","));
            worldGuard.set("worldguard.enabled", true);
            worldGuard.set("worldguard.regions", regions);
            worldGuard.save();
        }
        mappings = null;
        lwc.getConfiguration().save();
        configFile.delete();
    }

    private static void populate() {
        mappings = new HashMap<String, String>();
        mappings.put("allow-block-destruction", "protections.allowBlockDestruction");
        mappings.put("auto-update", "core.autoUpdate");
        mappings.put("database", "database.adapter");
        mappings.put("db-path", "database.path");
        mappings.put("default-menu-style", "core.defaultMenuStyle");
        mappings.put("deny-redstone", "protections.denyRedstone");
        mappings.put("flush-db-interval", "core.flushInterval");
        mappings.put("locale", "core.locale");
        mappings.put("mysql-database", "database.database");
        mappings.put("mysql-host", "database.host");
        mappings.put("mysql-pass", "database.password");
        mappings.put("mysql-user", "database.username");
        mappings.put("show-protection-notices", "core.showNotices");
        mappings.put("verbose", "core.verbose");
        mappings.put("op-is-lwcadmin", "core.opIsLWCAdmin");
    }
}

