/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.integration.currency;

import com.griefcraft.integration.ICurrency;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultCurrency
implements ICurrency {
    private Economy economy;

    public VaultCurrency() {
        this.checkEconomy();
    }

    private void checkEconomy() {
        RegisteredServiceProvider serviceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (serviceProvider != null) {
            this.economy = (Economy)serviceProvider.getProvider();
        }
    }

    @Override
    public boolean isActive() {
        if (this.economy == null) {
            this.checkEconomy();
        }
        return this.economy != null;
    }

    @Override
    public boolean usingCentralBank() {
        return false;
    }

    @Override
    public String format(double money) {
        return this.economy.format(money);
    }

    @Override
    public String getMoneyName() {
        return this.economy.currencyNameSingular();
    }

    @Override
    public double getBalance(Player player) {
        return this.economy.getBalance((OfflinePlayer)player);
    }

    @Override
    public boolean canAfford(Player player, double money) {
        return this.economy.has((OfflinePlayer)player, money);
    }

    @Override
    public boolean canCentralBankAfford(double money) {
        return false;
    }

    @Override
    public double addMoney(Player player, double money) {
        this.economy.depositPlayer((OfflinePlayer)player, money);
        return this.getBalance(player);
    }

    @Override
    public double removeMoney(Player player, double money) {
        this.economy.withdrawPlayer((OfflinePlayer)player, money);
        return this.getBalance(player);
    }
}

