/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class AdminCleanup
extends JavaModule {
    private static int BATCH_SIZE = 100;

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("cleanup")) {
            return;
        }
        event.setCancelled(true);
        boolean silent = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("silent")) {
            silent = true;
        }
        lwc.sendLocale(sender, "protection.admin.cleanup.start", "count", lwc.getPhysicalDatabase().getProtectionCount());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)lwc.getPlugin(), (Runnable)new Admin_Cleanup_Thread(lwc, sender, silent));
    }

    private static class Admin_Cleanup_Thread
    implements Runnable {
        private LWC lwc;
        private CommandSender sender;
        private boolean silent;

        public Admin_Cleanup_Thread(LWC lwc, CommandSender sender, boolean silent) {
            this.lwc = lwc;
            this.sender = sender;
            this.silent = silent;
        }

        @Override
        public void run() {
            final ArrayDeque protectionsToRemove = new ArrayDeque();
            final ArrayDeque protectionsToSave = new ArrayDeque();
            int removed = 0;
            int percentChecked = 0;
            try {
                this.sender.sendMessage("\u00a74Processing cleanup request now in a separate thread");
                final ArrayList<Protection> protections = new ArrayList<Protection>(BATCH_SIZE);
                List<Protection> allProtections = this.lwc.getPhysicalDatabase().loadProtectionsOrderedByChunk();
                Iterator<Protection> allProtectionIterator = allProtections.iterator();
                int totalProtections = allProtections.size();
                int checked = 0;
                while (allProtectionIterator.hasNext()) {
                    int percent;
                    while (Runtime.getRuntime().maxMemory() * 100L / (Runtime.getRuntime().freeMemory() + Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory()) < 5L) {
                        Thread.sleep(5000L);
                    }
                    while (allProtectionIterator.hasNext() && protections.size() < BATCH_SIZE) {
                        protections.add(allProtectionIterator.next());
                    }
                    Future getBlocks = Bukkit.getScheduler().callSyncMethod((Plugin)this.lwc.getPlugin(), (Callable)new Callable<ArrayList<Integer>>(){

                        @Override
                        public ArrayList<Integer> call() throws Exception {
                            ArrayList<Integer> toRemove = null;
                            for (Protection protection : protections) {
                                protection.uncacheBlock();
                                Block block = protection.getBlock();
                                if (protection.isEntity() || protection.getEntityId() != null || protection.getBlockId() == 5000) continue;
                                if (block == null || !lwc.isProtectable(block)) {
                                    if (toRemove == null) {
                                        toRemove = new ArrayList<Integer>();
                                    }
                                    toRemove.add(protection.getId());
                                    if (silent) continue;
                                    lwc.sendLocale(sender, "protection.admin.cleanup.removednoexist", "protection", protection.toString());
                                    continue;
                                }
                                if (protection.getBlockMaterial() == block.getType()) continue;
                                protectionsToSave.addLast(new ProtectionAndMaterial(protection, block.getType()));
                                lwc.log("Updating material to " + String.valueOf(block.getType()) + " for block at " + block.getX() + "," + block.getY() + "," + block.getZ());
                            }
                            return toRemove;
                        }
                    });
                    ArrayList newToRemove = (ArrayList)getBlocks.get();
                    if (newToRemove != null) {
                        protectionsToRemove.addAll(newToRemove);
                        removed += newToRemove.size();
                    }
                    if (percentChecked != (percent = (int)((double)(checked += protections.size()) / (double)totalProtections * 20.0))) {
                        percentChecked = percent;
                        this.sender.sendMessage("\u00a74Cleanup @ " + percent * 5 + "% [ " + checked + "/" + totalProtections + " protections ] [ removed " + removed + " protections ]");
                    }
                    protections.clear();
                }
                final int totalToRemove = protectionsToRemove.size();
                while (!protectionsToRemove.isEmpty()) {
                    Bukkit.getScheduler().callSyncMethod((Plugin)this.lwc.getPlugin(), (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            ArrayDeque<Integer> batchRemove = new ArrayDeque<Integer>();
                            for (int count = 0; !protectionsToRemove.isEmpty() && count < 20000; ++count) {
                                int protectionId = (Integer)protectionsToRemove.removeFirst();
                                batchRemove.add(protectionId);
                            }
                            if (!batchRemove.isEmpty()) {
                                lwc.getPhysicalDatabase().batchDeleteProtections(batchRemove);
                            }
                            sender.sendMessage("\u00a72REMOVED " + (totalToRemove - protectionsToRemove.size()) + " / " + totalToRemove);
                            return null;
                        }
                    }).get();
                }
                final int totalToSave = protectionsToSave.size();
                while (!protectionsToSave.isEmpty()) {
                    Bukkit.getScheduler().callSyncMethod((Plugin)this.lwc.getPlugin(), (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            int oldDone = totalToSave - protectionsToSave.size();
                            long startTime = System.nanoTime();
                            while (!protectionsToSave.isEmpty() && System.nanoTime() - startTime < 30000000L) {
                                ProtectionAndMaterial protectionAndMaterial = (ProtectionAndMaterial)protectionsToSave.removeFirst();
                                protectionAndMaterial.getProtection().setBlockMaterial(protectionAndMaterial.getMaterial());
                                protectionAndMaterial.getProtection().saveNow();
                            }
                            int newDone = totalToSave - protectionsToSave.size();
                            if (protectionsToSave.isEmpty() || newDone / 50 != oldDone / 50) {
                                sender.sendMessage("\u00a72UPDATED " + newDone + " / " + totalToSave);
                            }
                            return null;
                        }
                    }).get();
                }
                final int totalChecked = checked;
                Bukkit.getScheduler().runTask((Plugin)this.lwc.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        sender.sendMessage("Resetting cache...");
                        lwc.getPhysicalDatabase().precache();
                        sender.sendMessage("Cleanup completed. Removed " + totalToRemove + " protections out of " + totalChecked + " checked protections.");
                    }
                });
            }
            catch (Exception e) {
                this.sender.sendMessage("Exception caught during cleanup: " + e.getMessage());
                this.lwc.getPlugin().getLogger().log(Level.SEVERE, "Exception caught during cleanup", e);
            }
        }
    }

    private static class ProtectionAndMaterial {
        private final Protection protection;
        private final Material material;

        public ProtectionAndMaterial(Protection protection, Material material) {
            this.protection = protection;
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public Protection getProtection() {
            return this.protection;
        }
    }
}

