/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.google.common.base.Objects;
import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.lwc.BlockMap;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Action;
import com.griefcraft.model.Flag;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.BlockUtil;
import com.griefcraft.util.UUIDRegistry;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Lectern;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityKnockbackByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class LWCPlayerListener
implements Listener {
    private LWCPlugin plugin;
    private static final boolean HAS_CHISELED_BOOKSHELF = Material.getMaterial((String)"CHISELED_BOOKSHELF") != null;
    private UUID lastEntityInteract;
    private boolean lastEntityInteractResult;
    private Inventory lastItemMoveSource;
    private Inventory lastItemMoveDestination;
    private boolean lastItemMoveResult;

    public LWCPlayerListener(LWCPlugin plugin) {
        this.plugin = plugin;
        new BukkitRunnable(){

            public void run() {
                LWCPlayerListener.this.onTick();
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    protected void onTick() {
        this.lastItemMoveSource = null;
        this.lastItemMoveDestination = null;
        this.lastEntityInteract = null;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent e) {
        Hanging entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable((Entity)entity)) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection == null) {
            return;
        }
        if (e.getCause() != HangingBreakEvent.RemoveCause.ENTITY || !(e.getRemover() instanceof Player)) {
            e.setCancelled(true);
            return;
        }
        Player p = (Player)e.getRemover();
        if (!lwc.canDestoryProtection(p, protection)) {
            e.setCancelled(true);
            return;
        }
        protection.remove();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent e) {
        Entity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity)) {
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection == null) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onMinecartBreak(VehicleDestroyEvent e) {
        Vehicle entity = e.getVehicle();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable((Entity)entity)) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection == null) {
            return;
        }
        if (!(e.getAttacker() instanceof Player)) {
            e.setCancelled(true);
            return;
        }
        Player p = (Player)e.getAttacker();
        if (!lwc.canDestoryProtection(p, protection)) {
            e.setCancelled(true);
            return;
        }
        protection.remove();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (event instanceof HangingBreakByEntityEvent) {
            return;
        }
        Hanging entity = event.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable((Entity)entity)) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityPushedByEntityAttack(EntityKnockbackByEntityEvent e) {
        LivingEntity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable((Entity)entity)) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection != null) {
            Player player;
            Projectile projectile;
            ProjectileSource projectileSource;
            Entity source = e.getSourceEntity();
            if (source instanceof Projectile && (projectileSource = (projectile = (Projectile)source).getShooter()) instanceof Entity) {
                Entity realSource;
                source = realSource = (Entity)projectileSource;
            }
            if (!(source instanceof Player) || !lwc.canAccessProtection(player = (Player)source, protection)) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProtectedEntityDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || e instanceof EntityDamageByEntityEvent || !lwc.isProtectable(entity)) {
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProtectedEntityDamageByEntity(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable(entity)) {
            return;
        }
        Player player = p = e.getDamager() instanceof Player ? (Player)e.getDamager() : null;
        if (p != null && this.onPlayerEntityInteract(p, entity, e.isCancelled(), true)) {
            e.setCancelled(true);
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection == null) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || p == null) {
            e.setCancelled(true);
            return;
        }
        if (!lwc.canDestoryProtection(p, protection)) {
            ItemFrame frame;
            ItemStack item;
            if ((e.getCause() == EntityDamageEvent.DamageCause.CUSTOM || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) && entity instanceof ItemFrame && (item = (frame = (ItemFrame)entity).getItem()) != null && item.getType() != Material.AIR) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable((Entity)entity)) {
            return;
        }
        Protection protection = lwc.findProtection((Entity)entity);
        if (protection != null) {
            protection.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent e) {
        Protection protection;
        ArmorStand entity = e.getRightClicked();
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable((Entity)entity)) {
            return;
        }
        Player p = e.getPlayer();
        if (this.onPlayerEntityInteract(p, (Entity)entity, e.isCancelled(), true)) {
            e.setCancelled(true);
        }
        if ((protection = lwc.findProtection((Entity)entity)) == null) {
            return;
        }
        if (!e.isCancelled() && !lwc.canAccessProtectionContents(p, protection)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityInteract(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable(entity)) {
            return;
        }
        Player p = e.getPlayer();
        if (this.onPlayerEntityInteract(p, entity, e.isCancelled(), e.getHand() == EquipmentSlot.HAND)) {
            e.setCancelled(true);
            return;
        }
        Protection protection = lwc.findProtection(entity);
        if (protection == null) {
            return;
        }
        if (!lwc.canAccessProtectionContents(p, protection)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAtEntityInteract(PlayerInteractAtEntityEvent e) {
        Protection protection;
        Entity entity = e.getRightClicked();
        LWC lwc = LWC.getInstance();
        if (entity instanceof Player || !lwc.isProtectable(entity)) {
            return;
        }
        Player p = e.getPlayer();
        if (this.onPlayerEntityInteract(p, entity, e.isCancelled(), e.getHand() == EquipmentSlot.HAND)) {
            e.setCancelled(true);
        }
        if ((protection = lwc.findProtection(entity)) == null) {
            return;
        }
        if (!lwc.canAccessProtectionContents(p, protection)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void storageMinecraftInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof StorageMinecart) && !(holder instanceof HopperMinecart)) {
            return;
        }
        Entity entity = (Entity)holder;
        LWC lwc = LWC.getInstance();
        if (!lwc.isProtectable(entity)) {
            return;
        }
        if (this.onPlayerEntityInteract((Player)event.getPlayer(), entity, event.isCancelled(), true)) {
            event.setCancelled(true);
        }
    }

    private boolean onPlayerEntityInteract(Player player, Entity entity, boolean cancelled, boolean showMessage) {
        if (entity.getUniqueId().equals(this.lastEntityInteract)) {
            return this.lastEntityInteractResult;
        }
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.findProtection(entity);
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        try {
            Player owner;
            Module.Result result;
            boolean hasPendingAction;
            Set<String> actions = lwcPlayer.getActionNames();
            boolean canAccess = lwc.canAccessProtectionContents(player, protection);
            int actionCount = actions.size();
            boolean hasInteracted = actions.contains("interacted");
            boolean bl = hasPendingAction = hasInteracted && actionCount > 1 || !hasInteracted && actionCount > 0;
            if (cancelled) {
                if (hasPendingAction) {
                    lwc.sendLocale((CommandSender)player, "lwc.pendingaction", new Object[0]);
                }
                return false;
            }
            if (protection != null) {
                Action action = new Action();
                action.setName("interacted");
                action.setPlayer(lwcPlayer);
                action.setProtection(protection);
                lwcPlayer.addAction(action);
            }
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            Block fakeBlock = EntityBlock.getEntityBlock(entity);
            PlayerInteractEvent fakeEvent = new PlayerInteractEvent(player, org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK, null, fakeBlock, null);
            if (protection != null) {
                evt = new LWCProtectionInteractEvent(fakeEvent, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCProtectionInteractEvent)evt).getResult();
            } else {
                evt = new LWCBlockInteractEvent(fakeEvent, fakeBlock, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCBlockInteractEvent)evt).getResult();
            }
            if (result == Module.Result.ALLOW) {
                return false;
            }
            if (!(protection == null || canAccess || !lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOnline", false) || (owner = protection.getBukkitOwner()) != null && owner.isOnline())) {
                return false;
            }
            if (protection != null && !canAccess && lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOffline", false) && (owner = protection.getBukkitOwner()) != null && owner.isOnline()) {
                return false;
            }
            if (result == Module.Result.DEFAULT) {
                canAccess = lwc.enforceAccess(player, protection, fakeBlock, canAccess, showMessage);
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                this.lastEntityInteract = entity.getUniqueId();
                this.lastEntityInteractResult = true;
                return true;
            }
        }
        catch (Exception e) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
            return true;
        }
        this.lastEntityInteract = entity.getUniqueId();
        this.lastEntityInteractResult = false;
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUIDRegistry.updateCache(player.getUniqueId(), player.getName());
    }

    @EventHandler(ignoreCancelled=true)
    public void onMoveItem(InventoryMoveItemEvent event) {
        boolean result;
        if (Objects.equal((Object)this.lastItemMoveSource, (Object)event.getSource()) && Objects.equal((Object)this.lastItemMoveDestination, (Object)event.getDestination())) {
            result = this.lastItemMoveResult;
        } else {
            result = this.handleMoveItemEvent(event.getSource(), event.getDestination());
            this.lastItemMoveSource = event.getSource();
            this.lastItemMoveDestination = event.getDestination();
            this.lastItemMoveResult = result;
        }
        if (result) {
            event.setCancelled(true);
        }
    }

    private boolean handleMoveItemEvent(Inventory sourceInventory, Inventory destinationInventory) {
        String denyHoppersString;
        LWC lwc = LWC.getInstance();
        Protection sourceProtection = null;
        Entity sourceEntity = null;
        InventoryHolder sourceHolder = sourceInventory.getHolder();
        if (sourceHolder instanceof BlockState) {
            BlockState sourceBlock = (BlockState)sourceHolder;
            sourceProtection = lwc.findProtection(sourceBlock.getLocation());
        } else if (sourceHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)sourceHolder;
            sourceProtection = lwc.findProtection(doubleChest.getLocation());
        } else if (sourceHolder instanceof Entity) {
            Entity entity = (Entity)sourceHolder;
            if (lwc.isProtectable(entity)) {
                sourceEntity = entity;
                sourceProtection = lwc.findProtection(sourceEntity);
            }
        } else {
            return false;
        }
        Protection destinationProtection = null;
        Entity destinationEntity = null;
        InventoryHolder destinationHolder = destinationInventory.getHolder();
        if (destinationHolder instanceof BlockState) {
            BlockState destinationBlock = (BlockState)destinationHolder;
            destinationProtection = lwc.findProtection(destinationBlock.getLocation());
        } else if (destinationHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)destinationHolder;
            destinationProtection = lwc.findProtection(doubleChest.getLocation());
        } else if (destinationHolder instanceof Entity) {
            Entity destEntity = (Entity)destinationHolder;
            if (lwc.isProtectable(destEntity)) {
                destinationEntity = destEntity;
                destinationProtection = lwc.findProtection(destinationEntity);
            }
        } else {
            return false;
        }
        if (sourceProtection != null) {
            if (destinationProtection != null && sourceProtection.hasSameOwner(destinationProtection)) {
                return false;
            }
            denyHoppersString = null;
            denyHoppersString = !sourceProtection.isEntity() ? lwc.resolveProtectionConfiguration(BlockMap.instance().getMaterial(sourceProtection.getBlockId()), "denyHoppers") : lwc.resolveProtectionConfiguration(sourceEntity.getType(), "denyHoppers");
            boolean denyHoppers = Boolean.parseBoolean(denyHoppersString);
            if (denyHoppers ^ (sourceProtection.hasFlag(Flag.Type.HOPPER) || sourceProtection.hasFlag(Flag.Type.HOPPEROUT))) {
                return true;
            }
        }
        if (destinationProtection != null) {
            denyHoppersString = null;
            denyHoppersString = !destinationProtection.isEntity() ? lwc.resolveProtectionConfiguration(BlockMap.instance().getMaterial(destinationProtection.getBlockId()), "denyHoppers") : lwc.resolveProtectionConfiguration(destinationEntity.getType(), "denyHoppers");
            boolean denyHoppers = Boolean.parseBoolean(denyHoppersString);
            if (denyHoppers ^ (destinationProtection.hasFlag(Flag.Type.HOPPER) || destinationProtection.hasFlag(Flag.Type.HOPPERIN))) {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.isCancelled() || !LWC.ENABLED) {
            return;
        }
        Player player = event.getPlayer();
        LWCDropItemEvent evt = new LWCDropItemEvent(player, event);
        this.plugin.getLWC().getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        BlockState state;
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        if (event.getAction() != org.bukkit.event.block.Action.LEFT_CLICK_BLOCK && event.getAction() != org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        try {
            state = block.getState();
        }
        catch (NullPointerException e) {
            lwc.log("Invalid Tile Entity detected at " + String.valueOf(block.getLocation()));
            lwc.log("This is either an issue with your world or a bug in Bukkit");
            return;
        }
        if (state instanceof InventoryHolder && lwc.isProtectable(block) && !lwc.hasPermission(player, "lwc.protect") && lwc.hasPermission(player, "lwc.deny") && !lwc.isAdmin(player) && !lwc.isMod(player)) {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.blocked", new Object[0]);
            event.setCancelled(true);
            return;
        }
        try {
            Player owner;
            Module.Result result;
            boolean ignoreRightClick;
            boolean ignoreLeftClick;
            boolean hasPendingAction;
            BlockData blockData;
            Lectern lectern;
            ItemStack book;
            boolean canAccess;
            Set<String> actions = lwcPlayer.getActionNames();
            Protection protection = lwc.findProtection(block.getLocation());
            boolean bl = canAccess = protection == null || lwc.canAccessProtection(player, protection);
            if (!(protection == null || block.getType() != Material.LECTERN || !(state instanceof Lectern) || event.getItem() == null || event.getItem().getType() != Material.WRITTEN_BOOK && event.getItem().getType() != Material.WRITABLE_BOOK || (book = (lectern = (Lectern)state).getInventory().getItem(0)) != null && book.getType() != Material.AIR)) {
                boolean bl2 = canAccess = lwc.canAccessProtectionContents(player, protection) || protection.getType() == Protection.Type.DONATION;
            }
            if (HAS_CHISELED_BOOKSHELF && protection != null && block.getType() == Material.CHISELED_BOOKSHELF && (blockData = block.getBlockData()) instanceof ChiseledBookshelf) {
                ChiseledBookshelf blockData2 = (ChiseledBookshelf)blockData;
                if (state instanceof org.bukkit.block.ChiseledBookshelf) {
                    RayTraceResult hit;
                    org.bukkit.block.ChiseledBookshelf bookshelf = (org.bukkit.block.ChiseledBookshelf)state;
                    if (event.getBlockFace() == blockData2.getFacing() && (hit = player.rayTraceBlocks(6.0)) != null && block.equals((Object)hit.getHitBlock())) {
                        boolean occupied;
                        Vector relativePosition = hit.getHitPosition().subtract(block.getLocation().toVector());
                        float x = BlockUtil.getRelativeHitCoordinatesForBlockFace(relativePosition, blockData2.getFacing());
                        float y = (float)relativePosition.getY();
                        int slot = (x < 0.375f ? 0 : (x < 0.6875f ? 1 : 2)) + ((double)y >= 0.5 ? 0 : 3);
                        ItemStack inSlot = bookshelf.getInventory().getItem(slot);
                        boolean bl3 = occupied = inSlot != null && inSlot.getType() != Material.AIR || blockData2.isSlotOccupied(slot);
                        canAccess = occupied ? lwc.canAccessProtectionContents(player, protection) : lwc.canAccessProtectionContents(player, protection) || protection.getType() == Protection.Type.DONATION;
                    }
                }
            }
            int actionCount = actions.size();
            boolean hasInteracted = actions.contains("interacted");
            boolean bl4 = hasPendingAction = hasInteracted && actionCount > 1 || !hasInteracted && actionCount > 0;
            if (event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_BLOCK ? (ignoreLeftClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreLeftClick"))) : event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK && (ignoreRightClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(block, "ignoreRightClick")))) {
                return;
            }
            if (event.useInteractedBlock() == Event.Result.DENY) {
                if (hasPendingAction) {
                    lwc.sendLocale((CommandSender)player, "lwc.pendingaction", new Object[0]);
                }
                return;
            }
            if (protection != null) {
                Action action = new Action();
                action.setName("interacted");
                action.setPlayer(lwcPlayer);
                action.setProtection(protection);
                lwcPlayer.addAction(action);
            }
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            if (protection != null) {
                evt = new LWCProtectionInteractEvent(event, protection, actions, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCProtectionInteractEvent)evt).getResult();
            } else {
                evt = new LWCBlockInteractEvent(event, block, actions);
                lwc.getModuleLoader().dispatchEvent(evt);
                result = ((LWCBlockInteractEvent)evt).getResult();
            }
            if (result == Module.Result.ALLOW) {
                return;
            }
            if (!(protection == null || canAccess || !lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOnline", false) || (owner = protection.getBukkitOwner()) != null && owner.isOnline())) {
                return;
            }
            if (protection != null && !canAccess && lwc.getConfiguration().getBoolean("optional.onlyProtectWhenOwnerIsOffline", false) && (owner = protection.getBukkitOwner()) != null && owner.isOnline()) {
                return;
            }
            if (result == Module.Result.DEFAULT) {
                canAccess = lwc.enforceAccess(player, protection, block, canAccess, event.getHand() == EquipmentSlot.HAND);
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                event.setCancelled(true);
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWCPlayer.removePlayer(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent event) {
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.findProtection((BlockState)event.getLectern());
        if (protection == null) {
            return;
        }
        boolean canAccess = lwc.canAccessProtectionContents(event.getPlayer(), protection);
        canAccess = lwc.enforceAccess(event.getPlayer(), protection, event.getLectern().getBlock(), canAccess, true);
        if (!canAccess) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        boolean canAccessContents;
        Location location;
        Player player;
        LWC lwc;
        block19: {
            lwc = LWC.getInstance();
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            Inventory inventory = event.getInventory();
            if (inventory == null || event.getSlot() < 0) {
                return;
            }
            InventoryHolder holder = null;
            try {
                holder = event.getInventory().getHolder();
            }
            catch (AbstractMethodError e) {
                lwc.log("Caught issue with Bukkit's Inventory.getHolder() method! This is occuring NEAR the player: " + player.getName());
                lwc.log("This player is located at: " + player.getLocation().toString());
                lwc.log("This should be reported to the Bukkit developers.");
                e.printStackTrace();
                return;
            }
            try {
                if (holder instanceof BlockState) {
                    location = ((BlockState)holder).getLocation();
                    break block19;
                }
                if (holder instanceof DoubleChest) {
                    location = ((DoubleChest)holder).getLocation();
                    break block19;
                }
                return;
            }
            catch (Exception e) {
                Location ploc = player.getLocation();
                String holderName = holder != null ? holder.getClass().getSimpleName() : "Unknown Block";
                lwc.log("Exception with getting the location of a " + holderName + " has occurred NEAR the player: " + player.getName() + " [" + ploc.getBlockX() + " " + ploc.getBlockY() + " " + ploc.getBlockZ() + "]");
                lwc.log("The exact location of the block is not possible to obtain. This is caused by a Minecraft or Bukkit exception normally.");
                e.printStackTrace();
                return;
            }
        }
        Protection protection = lwc.findProtection(location);
        if (protection == null) {
            return;
        }
        if (protection.getType() != Protection.Type.DONATION && protection.getType() != Protection.Type.SHOWCASE) {
            return;
        }
        if (protection.getType() != Protection.Type.SHOWCASE && event.getAction() != InventoryAction.COLLECT_TO_CURSOR) {
            ItemStack item;
            if (event.getSlotType() != InventoryType.SlotType.CONTAINER) {
                return;
            }
            if (event.getSlot() != event.getRawSlot()) {
                return;
            }
            try {
                item = event.getCurrentItem();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return;
            }
            ItemStack cursor = event.getCursor();
            if (item == null || item.getType() == null || item.getType() == Material.AIR) {
                return;
            }
            if (player.getInventory().getItemInMainHand() == null && !event.isRightClick() && !event.isShiftClick()) {
                return;
            }
            if (cursor != null && item.isSimilar(cursor)) {
                return;
            }
        }
        if (!(canAccessContents = lwc.canAccessProtectionContents(player, protection))) {
            event.setCancelled(true);
        }
    }
}

