/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.model;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.History;
import com.griefcraft.model.Mode;
import com.griefcraft.model.Protection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class LWCPlayer
implements CommandSender {
    private LWC lwc;
    private Player player;
    private static final Map<UUID, LWCPlayer> playerCache = new HashMap<UUID, LWCPlayer>();
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Set<Mode> modes = new HashSet<Mode>();
    private final Set<Protection> accessibleProtections = new HashSet<Protection>();

    public LWCPlayer(LWC lwc, Player player) {
        this.lwc = lwc;
        this.player = player;
    }

    public static LWCPlayer getPlayer(Player player) {
        LWCPlayer lwcPlayer = playerCache.get(player.getUniqueId());
        if (lwcPlayer == null) {
            lwcPlayer = new LWCPlayer(LWC.getInstance(), player);
            playerCache.put(player.getUniqueId(), lwcPlayer);
        }
        return lwcPlayer;
    }

    public static void removePlayer(Player player) {
        playerCache.remove(player.getUniqueId());
    }

    public Player getBukkitPlayer() {
        return this.player;
    }

    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    public String getName() {
        return this.player.getName();
    }

    public boolean enableMode(Mode mode) {
        return this.modes.add(mode);
    }

    public boolean disableMode(Mode mode) {
        return this.modes.remove(mode);
    }

    public void disableAllModes() {
        this.modes.clear();
    }

    public boolean hasAction(String name) {
        return this.actions.containsKey(name);
    }

    public Action getAction(String name) {
        return this.actions.get(name);
    }

    public boolean addAction(Action action) {
        this.actions.put(action.getName(), action);
        return true;
    }

    public boolean removeAction(Action action) {
        this.actions.remove(action.getName());
        return true;
    }

    public void removeAllActions() {
        this.actions.clear();
    }

    public Mode getMode(String name) {
        for (Mode mode : this.modes) {
            if (!mode.getName().equals(name)) continue;
            return mode;
        }
        return null;
    }

    public boolean hasMode(String name) {
        return this.getMode(name) != null;
    }

    public Set<Mode> getModes() {
        return new HashSet<Mode>(this.modes);
    }

    public Map<String, Action> getActions() {
        return new HashMap<String, Action>(this.actions);
    }

    public Set<String> getActionNames() {
        return Collections.unmodifiableSet(this.actions.keySet());
    }

    public Set<Protection> getAccessibleProtections() {
        return new HashSet<Protection>(this.accessibleProtections);
    }

    public boolean isProtectionAccessible(Protection p) {
        return this.accessibleProtections.contains(p);
    }

    public boolean addAccessibleProtection(Protection protection) {
        return this.accessibleProtections.add(protection);
    }

    public boolean removeAccessibleProtection(Protection protection) {
        return this.accessibleProtections.remove(protection);
    }

    public void removeAllAccessibleProtections() {
        this.accessibleProtections.clear();
    }

    public History createHistoryObject() {
        History history = new History();
        history.setPlayer(this.player.getName());
        history.setStatus(History.Status.INACTIVE);
        return history;
    }

    public void sendLocale(String key, Object ... args) {
        this.lwc.sendLocale((CommandSender)this.player, key, args);
    }

    public List<History> getRelatedHistory() {
        return this.lwc.getPhysicalDatabase().loadHistory(this.player);
    }

    public List<History> getRelatedHistory(int page) {
        return this.lwc.getPhysicalDatabase().loadHistory(this.player, (page - 1) * 15, 15);
    }

    public List<History> getRelatedHistory(History.Type type) {
        ArrayList<History> related = new ArrayList<History>();
        for (History history : this.getRelatedHistory()) {
            if (history.getType() != type) continue;
            related.add(history);
        }
        return related;
    }

    public void sendMessage(String s) {
        this.player.sendMessage(s);
    }

    public void sendMessage(String ... s) {
        for (String _s : s) {
            this.sendMessage(_s);
        }
    }

    public Server getServer() {
        return this.player.getServer();
    }

    public boolean isPermissionSet(String s) {
        return this.player.isPermissionSet(s);
    }

    public boolean isPermissionSet(Permission permission) {
        return this.player.isPermissionSet(permission);
    }

    public boolean hasPermission(String s) {
        return this.player.hasPermission(s);
    }

    public boolean hasPermission(Permission permission) {
        return this.player.hasPermission(permission);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String s, boolean b) {
        return this.player.addAttachment(plugin, s, b);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.player.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String s, boolean b, int i) {
        return this.player.addAttachment(plugin, s, b, i);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int i) {
        return this.player.addAttachment(plugin, i);
    }

    public void removeAttachment(PermissionAttachment permissionAttachment) {
        this.player.removeAttachment(permissionAttachment);
    }

    public void recalculatePermissions() {
        this.player.recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.player.getEffectivePermissions();
    }

    public boolean isOp() {
        return this.player.isOp();
    }

    public void setOp(boolean b) {
        this.player.setOp(b);
    }

    public CommandSender.Spigot spigot() {
        return this.player.spigot();
    }

    public void sendMessage(UUID target, String message) {
        this.player.sendMessage(target, message);
    }

    public void sendMessage(UUID target, String ... message) {
        this.player.sendMessage(target, message);
    }
}

