/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.limits;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCReloadEvent;
import com.griefcraft.util.config.Configuration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class LimitsV2
extends JavaModule {
    private static final Set<Material> SIGNS = new HashSet<Material>(List.of(Material.MANGROVE_WALL_SIGN, Material.CRIMSON_WALL_SIGN, Material.WARPED_WALL_SIGN, Material.ACACIA_WALL_SIGN, Material.BIRCH_WALL_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_WALL_SIGN, Material.OAK_WALL_SIGN, Material.MANGROVE_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.ACACIA_SIGN, Material.BIRCH_SIGN, Material.DARK_OAK_SIGN, Material.JUNGLE_SIGN, Material.OAK_SIGN));
    public static final int UNLIMITED = Integer.MAX_VALUE;
    private boolean enabled = true;
    private final Configuration configuration = Configuration.load("limitsv2.yml");
    private final List<Limit> defaultLimits = new LinkedList<Limit>();
    private final Map<String, List<Limit>> playerLimits = new HashMap<String, List<Limit>>();
    private final Map<String, List<Limit>> groupLimits = new HashMap<String, List<Limit>>();

    public LimitsV2() {
        this.enabled = LWC.getInstance().getConfiguration().getBoolean("optional.useProtectionLimits", true);
        if (this.enabled) {
            this.loadLimits();
        }
    }

    @Override
    public void onReload(LWCReloadEvent event) {
        if (this.enabled) {
            this.reload();
        }
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        Block block;
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        if (this.hasReachedLimit(player, (block = event.getBlock()).getType())) {
            lwc.sendLocale((CommandSender)player, "protection.exceeded", new Object[0]);
            event.setCancelled(true);
        }
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        String playerName;
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("limits")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (args.length == 0) {
            if (args.length == 0 && !(sender instanceof Player)) {
                sender.sendMessage("\u00a74You are not a player!");
                return;
            }
            playerName = sender.getName();
        } else if (lwc.isAdmin(sender)) {
            playerName = args[0];
        } else {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        Player player = lwc.getPlugin().getServer().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage("\u00a74That player is not online!");
            return;
        }
        this.sendLimits(sender, player, this.getPlayerLimits(player));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void reload() {
        this.loadLimits();
    }

    public void sendLimits(CommandSender sender, Player target, List<Limit> limits) {
        for (Limit limit : limits) {
            String currentProtected;
            if (limit == null) continue;
            String stringLimit = limit.getLimit() == Integer.MAX_VALUE ? "Unlimited" : Integer.toString(limit.getLimit());
            String colour = "\u00a7e";
            if (target != null) {
                Material material = null;
                if (limit instanceof BlockLimit) {
                    material = ((BlockLimit)limit).getMaterial();
                } else if (limit instanceof SignLimit) {
                    material = Material.OAK_SIGN;
                }
                boolean reachedLimit = this.hasReachedLimit(target, material);
                String string = colour = reachedLimit ? "\u00a74" : "\u00a72";
            }
            if (limit instanceof DefaultLimit) {
                currentProtected = target != null ? Integer.toString(limit.getProtectionCount(target, null)) + "/" : "";
                sender.sendMessage("Default: " + colour + currentProtected + stringLimit);
                continue;
            }
            if (limit instanceof BlockLimit) {
                BlockLimit blockLimit = (BlockLimit)limit;
                String currentProtected2 = target != null ? Integer.toString(limit.getProtectionCount(target, blockLimit.getMaterial())) + "/" : "";
                sender.sendMessage(LWC.materialToString(blockLimit.getMaterial()) + ": " + colour + currentProtected2 + stringLimit);
                continue;
            }
            if (limit instanceof SignLimit) {
                currentProtected = target != null ? Integer.toString(limit.getProtectionCount(target, null)) + "/" : "";
                sender.sendMessage("Sign: " + colour + currentProtected + stringLimit);
                continue;
            }
            sender.sendMessage(limit.getClass().getSimpleName() + ": \u00a7e" + stringLimit);
        }
    }

    public boolean hasReachedLimit(Player player, Material material) {
        Limit limit = this.getEffectiveLimit(player, material);
        if (limit == null) {
            return false;
        }
        int neverPassThisNumber = limit.getLimit();
        int protections = limit.getProtectionCount(player, material);
        return protections >= neverPassThisNumber;
    }

    private List<Limit> findLimitsViaPermissions(Player player) {
        LinkedList<Limit> limits = new LinkedList<Limit>();
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            int count;
            String[] split;
            String permission = pai.getPermission();
            boolean value = pai.getValue();
            if (!value || !permission.startsWith("lwc.protect.") || (split = permission.substring("lwc.protect.".length()).split(".")).length != 2) continue;
            String matchName = split[0];
            String strCount = split[1];
            try {
                count = Integer.parseInt(strCount);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (matchName.equals("*")) {
                limits.add(new DefaultLimit(this, count));
                continue;
            }
            if (matchName.equals("sign")) {
                limits.add(new SignLimit(this, count));
                continue;
            }
            Material material = Material.matchMaterial((String)matchName);
            if (material == null) continue;
            limits.add(new BlockLimit(this, material, count));
        }
        return limits;
    }

    public List<Limit> getPlayerLimits(Player player) {
        Object matched;
        LWC lwc = LWC.getInstance();
        LinkedList<Limit> limits = new LinkedList<Limit>();
        String playerName = player.getName().toLowerCase();
        if (this.playerLimits.containsKey(playerName)) {
            limits.addAll((Collection)this.playerLimits.get(playerName));
        }
        for (Limit limit : this.findLimitsViaPermissions(player)) {
            matched = this.findLimit(limits, limit);
            if (matched != null) {
                if (limit.getLimit() <= ((Limit)matched).getLimit()) continue;
                limits.remove(matched);
                limits.add(limit);
                continue;
            }
            limits.add(limit);
        }
        for (String group : lwc.getPermissions().getGroups(player)) {
            if (!this.groupLimits.containsKey(group.toLowerCase())) continue;
            for (Limit limit : this.groupLimits.get(group.toLowerCase())) {
                Limit matched2 = this.findLimit(limits, limit);
                if (matched2 != null) {
                    if (limit.getLimit() <= matched2.getLimit()) continue;
                    limits.remove(matched2);
                    limits.add(limit);
                    continue;
                }
                limits.add(limit);
            }
        }
        for (Limit limit : this.defaultLimits) {
            matched = this.findLimit(limits, limit);
            if (matched != null) continue;
            limits.add(limit);
        }
        return limits;
    }

    public Limit getEffectiveLimit(Player player, Material material) {
        return this.getEffectiveLimit(this.getPlayerLimits(player), material);
    }

    public List<Limit> getDefaultLimits() {
        return Collections.unmodifiableList(this.defaultLimits);
    }

    public Map<String, List<Limit>> getPlayerLimits() {
        return Collections.unmodifiableMap(this.playerLimits);
    }

    public Map<String, List<Limit>> getGroupLimits() {
        return Collections.unmodifiableMap(this.groupLimits);
    }

    private List<Limit> orderLimits(List<Limit> limits) {
        Limit defaultLimit = null;
        for (Limit limit : limits) {
            if (!(limit instanceof DefaultLimit)) continue;
            defaultLimit = limit;
            break;
        }
        limits.remove(defaultLimit);
        limits.add(0, defaultLimit);
        return limits;
    }

    private Limit getEffectiveLimit(List<Limit> limits, Material material) {
        if (limits == null) {
            return null;
        }
        Limit defaultLimit = null;
        for (Limit limit : limits) {
            BlockLimit blockLimit;
            if (limit instanceof DefaultLimit) {
                defaultLimit = limit;
                continue;
            }
            if (limit instanceof SignLimit) {
                if (!SIGNS.contains(material)) continue;
                return limit;
            }
            if (!(limit instanceof BlockLimit) || (blockLimit = (BlockLimit)limit).getMaterial() != material) continue;
            return blockLimit;
        }
        return defaultLimit;
    }

    private void loadLimits() {
        this.defaultLimits.clear();
        this.playerLimits.clear();
        this.groupLimits.clear();
        this.defaultLimits.addAll(this.findLimits("defaults"));
        try {
            for (String player : this.configuration.getKeys("players")) {
                this.playerLimits.put(player.toLowerCase(), this.findLimits("players." + player));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (String group : this.configuration.getKeys("groups")) {
                this.groupLimits.put(group.toLowerCase(), this.findLimits("groups." + group));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private List<Limit> findLimits(String node) {
        LinkedList<Limit> limits = new LinkedList<Limit>();
        List<String> keys = this.configuration.getKeys(node);
        for (String key : keys) {
            String value = this.configuration.getString(node + "." + key);
            int limit = value.equalsIgnoreCase("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(value);
            if (key.equalsIgnoreCase("default")) {
                limits.add(new DefaultLimit(this, limit));
                continue;
            }
            if (key.equalsIgnoreCase("sign")) {
                limits.add(new SignLimit(this, limit));
                continue;
            }
            Material material = Material.matchMaterial((String)key);
            if (material == null) continue;
            limits.add(new BlockLimit(this, material, limit));
        }
        this.orderLimits(limits);
        return limits;
    }

    private Limit findLimit(List<Limit> limits, Limit compare) {
        for (Limit limit : limits) {
            if (limit == null || !limit.getClass().isInstance(compare)) continue;
            if (limit instanceof BlockLimit) {
                BlockLimit cmp1 = (BlockLimit)limit;
                BlockLimit cmp2 = (BlockLimit)compare;
                if (cmp1.getMaterial() != cmp2.getMaterial()) continue;
                return limit;
            }
            return limit;
        }
        return null;
    }

    public abstract class Limit {
        private final int limit;

        public Limit(LimitsV2 this$0, int limit) {
            this.limit = limit;
        }

        public abstract int getProtectionCount(Player var1, Material var2);

        public int getLimit() {
            return this.limit;
        }
    }

    public final class BlockLimit
    extends Limit {
        private final Material material;

        public BlockLimit(LimitsV2 this$0, Material material, int limit) {
            super(this$0, limit);
            this.material = material;
        }

        @Override
        public int getProtectionCount(Player player, Material material) {
            return LWC.getInstance().getPhysicalDatabase().getProtectionCount(player.getName(), material);
        }

        public Material getMaterial() {
            return this.material;
        }
    }

    public final class SignLimit
    extends Limit {
        public SignLimit(LimitsV2 this$0, int limit) {
            super(this$0, limit);
        }

        @Override
        public int getProtectionCount(Player player, Material material) {
            LWC lwc = LWC.getInstance();
            int count = 0;
            for (Material m : SIGNS) {
                count += lwc.getPhysicalDatabase().getProtectionCount(player.getName(), m);
            }
            return count;
        }
    }

    public final class DefaultLimit
    extends Limit {
        public DefaultLimit(LimitsV2 this$0, int limit) {
            super(this$0, limit);
        }

        @Override
        public int getProtectionCount(Player player, Material material) {
            return LWC.getInstance().getPhysicalDatabase().getProtectionCount(player.getName());
        }
    }
}

