/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.migration;

import com.griefcraft.model.History;
import com.griefcraft.model.Protection;
import com.griefcraft.sql.PhysDB;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DatabaseMigrator {
    private static Logger logger = Logger.getLogger("LWCMigrator");

    public boolean migrate(PhysDB fromDatabase, PhysDB toDatabase) {
        try {
            List<History> tmp;
            toDatabase.getConnection().setAutoCommit(false);
            int startProtections = toDatabase.getProtectionCount();
            int protectionCount = fromDatabase.getProtectionCount();
            int historyCount = fromDatabase.getHistoryCount();
            int expectedProtections = protectionCount + startProtections;
            if (protectionCount > 0) {
                tmp = fromDatabase.loadProtections();
                for (Protection protection : tmp) {
                    protection.saveNow();
                }
                toDatabase.getConnection().commit();
                protectionCount = fromDatabase.getProtectionCount();
                if (expectedProtections != protectionCount) {
                    logger.info("Weird, only " + protectionCount + " protections are in the database? Continuing...");
                }
            }
            for (Map.Entry entry : fromDatabase.loadBlockMappings().entrySet()) {
                toDatabase.addBlockMapping((Integer)entry.getKey(), (String)entry.getValue());
            }
            if (historyCount > 0) {
                tmp = fromDatabase.loadHistory();
                for (History history : tmp) {
                    history.setExists(false);
                    history.sync();
                }
            }
            fromDatabase.getConnection().close();
            toDatabase.getConnection().setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

