/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.create;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.StringUtil;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CreateModule
extends JavaModule {
    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("create")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)event.getPlayer());
        if (!lwc.isProtectable(block)) {
            return;
        }
        PhysDB physDb = lwc.getPhysicalDatabase();
        Action action = player.getAction("create");
        String actionData = action.getData();
        String[] split = actionData.split(" ");
        String protectionType = split[0].toLowerCase();
        String protectionData = StringUtil.join(split, 1);
        if (!lwc.hasPermission((CommandSender)event.getPlayer(), "lwc.create." + protectionType, "lwc.create", "lwc.protect")) {
            lwc.sendLocale(player, "protection.accessdenied", new Object[0]);
            lwc.removeModes(player);
            event.setResult(Module.Result.CANCEL);
            return;
        }
        String worldName = block.getWorld().getName();
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        Entity entity = null;
        if (block instanceof EntityBlock) {
            entity = ((EntityBlock)block).getEntity();
        }
        lwc.removeModes(player);
        LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player.getBukkitPlayer(), block);
        lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled()) {
            return;
        }
        Protection protection = null;
        if (protectionType.equals("public")) {
            protection = entity != null ? physDb.registerEntityProtection(entity, Protection.Type.PUBLIC, worldName, player.getUniqueId().toString(), "", blockX, blockY, blockZ) : physDb.registerProtection(block.getType(), Protection.Type.PUBLIC, worldName, player.getUniqueId().toString(), "", blockX, blockY, blockZ);
            lwc.sendLocale(player, "protection.interact.create.finalize", new Object[0]);
        } else if (protectionType.equals("password")) {
            String password = lwc.encrypt(protectionData);
            protection = entity != null ? physDb.registerEntityProtection(entity, Protection.Type.PASSWORD, worldName, player.getUniqueId().toString(), password, blockX, blockY, blockZ) : physDb.registerProtection(block.getType(), Protection.Type.PASSWORD, worldName, player.getUniqueId().toString(), password, blockX, blockY, blockZ);
            player.addAccessibleProtection(protection);
            lwc.sendLocale(player, "protection.interact.create.finalize", new Object[0]);
            lwc.sendLocale(player, "protection.interact.create.password", new Object[0]);
        } else if (protectionType.equals("private") || protectionType.equals("donation") || protectionType.equals("showcase")) {
            String[] rights = protectionData.split(" ");
            protection = entity != null ? physDb.registerEntityProtection(entity, Protection.Type.matchType(protectionType), worldName, player.getUniqueId().toString(), "", blockX, blockY, blockZ) : physDb.registerProtection(block.getType(), Protection.Type.matchType(protectionType), worldName, player.getUniqueId().toString(), "", blockX, blockY, blockZ);
            lwc.sendLocale(player, "protection.interact.create.finalize", new Object[0]);
            lwc.processRightsModifications(player, protection, rights);
        }
        if (protection != null) {
            protection.removeCache();
            LWC.getInstance().getProtectionCache().addProtection(protection);
            lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
        }
        event.setResult(Module.Result.CANCEL);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("c", "create")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!(sender instanceof Player)) {
            return;
        }
        if (args.length == 0) {
            lwc.sendLocale(sender, "help.creation", new Object[0]);
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        String full = StringUtil.join(args, 0).trim();
        String type = args[0].toLowerCase();
        String data = StringUtil.join(args, 1);
        event.setCancelled(true);
        if (!lwc.hasPermission(sender, "lwc.create." + type, "lwc.create", "lwc.protect")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        try {
            switch (Protection.Type.matchType(type)) {
                case PASSWORD: {
                    if (args.length < 2) {
                        lwc.sendSimpleUsage(player, "/lwc -c password <Password>");
                        return;
                    }
                    String hiddenPass = StringUtil.transform(data, '*');
                    lwc.sendLocale(player, "protection.create.password", "password", hiddenPass);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            lwc.sendLocale(player, "help.creation", new Object[0]);
            return;
        }
        Action action = new Action();
        action.setName("create");
        action.setPlayer(player);
        action.setData(full);
        player.removeAllActions();
        player.addAction(action);
        lwc.sendLocale(player, "protection.create.finalize", "type", lwc.getPlugin().getMessageParser().parseMessage(type, new Object[0]));
    }
}

