/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.proxy.Player;
import de.cubeside.connection.GlobalClient;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.cubeside.connection.event.GlobalDataEvent;
import de.cubeside.connection.event.GlobalPlayerDisconnectedEvent;
import de.cubeside.connection.event.GlobalPlayerJoinedEvent;
import de.cubeside.connection.event.GlobalServerConnectedEvent;
import de.cubeside.connection.event.GlobalServerDisconnectedEvent;
import java.util.ArrayDeque;

public class GlobalClientVelocity
extends GlobalClient {
    private final GlobalClientPlugin plugin;
    private boolean stoppingServer;
    protected final ArrayDeque<Runnable> tasks = new ArrayDeque();
    protected final Object sync = new Object();
    protected boolean running = true;

    public GlobalClientVelocity(GlobalClientPlugin connectionPlugin) {
        super(null);
        this.plugin = connectionPlugin;
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, (Runnable)new MainThread()).schedule();
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(Runnable r) {
        Object object = this.sync;
        synchronized (object) {
            boolean wasEmpty = this.tasks.isEmpty();
            this.tasks.addLast(r);
            if (wasEmpty) {
                this.sync.notifyAll();
            }
        }
    }

    @Override
    public void setServer(final String host, final int port, final String account, final String password) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                GlobalClientVelocity.super.setServer(host, port, account, password);
                for (Player p : GlobalClientVelocity.this.plugin.getServer().getAllPlayers()) {
                    GlobalClientVelocity.this.onPlayerOnline(p.getUniqueId(), p.getUsername(), System.currentTimeMillis());
                }
            }
        });
    }

    @Override
    protected void runInMainThread(Runnable r) {
        if (!this.stoppingServer) {
            this.schedule(r);
        }
    }

    @Override
    protected void processData(GlobalServer source, String channel, GlobalPlayer targetPlayer, GlobalServer targetServer, byte[] data) {
        this.plugin.getServer().getEventManager().fire((Object)new GlobalDataEvent(source, targetPlayer, channel, data));
    }

    @Subscribe(priority=-126)
    public void onPlayerJoin(PostLoginEvent e) {
        final Player p = e.getPlayer();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                GlobalPlayer existing = GlobalClientVelocity.this.getPlayer(p.getUniqueId());
                if (existing == null || !existing.isOnServer(GlobalClientVelocity.this.getThisServer())) {
                    GlobalClientVelocity.this.onPlayerOnline(p.getUniqueId(), p.getUsername(), System.currentTimeMillis());
                }
            }
        });
    }

    @Subscribe(priority=126)
    public void onPlayerQuit(DisconnectEvent e) {
        final Player p = e.getPlayer();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                GlobalPlayer existing = GlobalClientVelocity.this.getPlayer(p.getUniqueId());
                if (existing != null && existing.isOnServer(GlobalClientVelocity.this.getThisServer())) {
                    GlobalClientVelocity.this.onPlayerOffline(p.getUniqueId());
                }
            }
        });
    }

    @Override
    protected void onPlayerJoined(GlobalServer server, GlobalPlayer player, boolean joinedTheNetwork) {
        this.plugin.getServer().getEventManager().fire((Object)new GlobalPlayerJoinedEvent(server, player, joinedTheNetwork));
    }

    @Override
    protected void onPlayerDisconnected(GlobalServer server, GlobalPlayer player, boolean leftTheNetwork) {
        this.plugin.getServer().getEventManager().fire((Object)new GlobalPlayerDisconnectedEvent(server, player, leftTheNetwork));
    }

    @Override
    protected void onServerConnected(GlobalServer server) {
        this.plugin.getServer().getEventManager().fire((Object)new GlobalServerConnectedEvent(server));
    }

    @Override
    protected void onServerDisconnected(GlobalServer server) {
        this.plugin.getServer().getEventManager().fire((Object)new GlobalServerDisconnectedEvent(server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.stoppingServer = true;
        super.shutdown();
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            this.sync.notifyAll();
        }
    }

    private class MainThread
    implements Runnable {
        private MainThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable task = null;
            while (true) {
                Object object = GlobalClientVelocity.this.sync;
                synchronized (object) {
                    task = GlobalClientVelocity.this.tasks.pollFirst();
                    if (task == null) {
                        if (GlobalClientVelocity.this.running) {
                            try {
                                GlobalClientVelocity.this.sync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            return;
                        }
                    }
                }
                if (task == null) continue;
                try {
                    task.run();
                    continue;
                }
                catch (Throwable t) {
                    GlobalClientVelocity.this.plugin.getLogger().error("Exception in Client thread", t);
                    continue;
                }
                break;
            }
        }
    }
}

