/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.permissions;

import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.ServerConfig;
import de.cubeside.globalserver.permissions.GroupPermissions;
import de.cubeside.globalserver.permissions.GroupsConfig;
import de.cubeside.globalserver.permissions.impl.CircularDependenciesException;
import de.cubeside.globalserver.permissions.impl.PermissionSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class GlobalPermissions {
    public static final Logger LOGGER = LogManager.getLogger("Permissions");
    private final PermissionSystem permissionSystem;
    private final File groupsFile = new File("groups.yml");
    private final Yaml configYaml;
    private GroupsConfig groupsConfig;

    public GlobalPermissions(GlobalServer globalServer) {
        this.permissionSystem = new PermissionSystem();
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
        loaderOptions.setNestingDepthLimit(Integer.MAX_VALUE);
        Constructor constructor = new Constructor(ServerConfig.class, loaderOptions);
        TypeDescription groupsConfigDescription = new TypeDescription(GroupsConfig.class);
        groupsConfigDescription.addPropertyParameters("groups", String.class, GroupPermissions.class);
        constructor.addTypeDescription(groupsConfigDescription);
        TypeDescription goupPermissionsDescription = new TypeDescription(GroupPermissions.class);
        goupPermissionsDescription.addPropertyParameters("permissions", String.class, Boolean.class);
        constructor.addTypeDescription(goupPermissionsDescription);
        this.configYaml = new Yaml(constructor);
        this.reload();
    }

    public synchronized void reload() {
        if (this.groupsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.groupsFile), Charset.forName("UTF-8")));){
                this.groupsConfig = this.configYaml.loadAs(reader, GroupsConfig.class);
            }
            catch (Exception e) {
                LOGGER.error("Could not parse permission groups config!", (Throwable)e);
            }
        }
        if (this.groupsConfig == null) {
            this.groupsConfig = new GroupsConfig();
            LOGGER.info("Generating new permission groups config!");
            if (!this.groupsFile.exists()) {
                this.saveConfig();
            }
        }
        this.reloadAllGroups();
    }

    private void reloadAllGroups() {
        try {
            this.permissionSystem.editGroups(editor -> {
                editor.removeAllGroups();
                for (Map.Entry<String, GroupPermissions> e : this.groupsConfig.getGroups().entrySet()) {
                    String groupName = e.getKey();
                    for (Map.Entry<String, Boolean> p : e.getValue().getPermissions().entrySet()) {
                        editor.addPermissionToGroup(groupName, p.getKey(), p.getValue());
                    }
                }
            });
            LOGGER.info("Permissions reloaded!");
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not load permission groups because of circular dependencies: " + e.getMessage());
            try {
                this.permissionSystem.editGroups(editor -> editor.removeAllGroups());
            }
            catch (CircularDependenciesException e1) {
                throw new RuntimeException("should be impossible");
            }
        }
    }

    public synchronized void saveConfig() {
        String output = this.configYaml.dumpAsMap(this.groupsConfig);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.groupsFile), Charset.forName("UTF-8")));){
            writer.write(output);
        }
        catch (Exception e) {
            LOGGER.error("Could not save config!", (Throwable)e);
        }
    }

    public synchronized Collection<String> getAllGroups() {
        return new ArrayList<String>(this.groupsConfig.getGroups().keySet());
    }

    public synchronized boolean hasGroup(String groupName) {
        return this.groupsConfig.getGroups().containsKey(groupName);
    }

    public synchronized boolean addGroup(String groupName) {
        if (this.hasGroup(groupName)) {
            return false;
        }
        try {
            this.permissionSystem.editGroups(editor -> editor.createGroup(groupName));
            this.groupsConfig.getGroups().put(groupName, new GroupPermissions());
            this.saveConfig();
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not update permission groups because of circular dependencies: " + e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized int getGroupPriority(String groupName) {
        GroupPermissions perms = this.groupsConfig.getGroups().get(groupName);
        return perms == null ? 0 : perms.getPriority();
    }

    public synchronized Map<String, Boolean> getGroupPermissions(String groupName) {
        GroupPermissions perms = this.groupsConfig.getGroups().get(groupName);
        return perms == null ? Map.of() : Collections.unmodifiableMap(perms.getPermissions());
    }

    public synchronized boolean setGroupPriority(String groupName, int prio) {
        GroupPermissions perms = this.groupsConfig.getGroups().get(groupName);
        if (perms == null) {
            return false;
        }
        try {
            this.permissionSystem.editGroups(editor -> editor.setGroupPriority(groupName, prio));
            perms.setPriority(prio);
            this.saveConfig();
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not update permission groups because of circular dependencies: " + e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean addGroupPermission(String groupName, String permission, boolean value) {
        GroupPermissions perms = this.groupsConfig.getGroups().get(groupName);
        if (perms == null) {
            return false;
        }
        try {
            this.permissionSystem.editGroups(editor -> editor.addPermissionToGroup(groupName, permission, value));
            perms.getPermissions().put(permission, value);
            this.saveConfig();
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not update permission groups because of circular dependencies: " + e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean removeGroupPermission(String groupName, String permission) {
        GroupPermissions perms = this.groupsConfig.getGroups().get(groupName);
        if (perms == null) {
            return false;
        }
        try {
            this.permissionSystem.editGroups(editor -> editor.removePermissionFromGroup(groupName, permission));
            perms.getPermissions().remove(permission);
            this.saveConfig();
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not update permission groups because of circular dependencies: " + e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean removeGroup(String groupName) {
        GroupPermissions perms = this.groupsConfig.getGroups().get(groupName);
        if (perms == null) {
            return false;
        }
        try {
            this.permissionSystem.editGroups(editor -> editor.removeGroup(groupName));
            this.groupsConfig.getGroups().remove(groupName);
            this.saveConfig();
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not update permission groups because of circular dependencies: " + e.getMessage());
            return false;
        }
        return true;
    }

    public PermissionSystem getPermissionSystem() {
        return this.permissionSystem;
    }
}

