/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ServiceLoader;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.OSUtils;

public class Diag {
    public static void main(String[] args) {
        Diag.diag(System.out);
    }

    public static void diag(PrintStream out) {
        TerminalProvider provider;
        out.println("System properties");
        out.println("=================");
        out.println("os.name =         " + System.getProperty("os.name"));
        out.println("OSTYPE =          " + System.getenv("OSTYPE"));
        out.println("MSYSTEM =         " + System.getenv("MSYSTEM"));
        out.println("PWD =             " + System.getenv("PWD"));
        out.println("ConEmuPID =       " + System.getenv("ConEmuPID"));
        out.println("WSL_DISTRO_NAME = " + System.getenv("WSL_DISTRO_NAME"));
        out.println("WSL_INTEROP =     " + System.getenv("WSL_INTEROP"));
        out.println();
        out.println("OSUtils");
        out.println("=================");
        out.println("IS_WINDOWS = " + OSUtils.IS_WINDOWS);
        out.println("IS_CYGWIN =  " + OSUtils.IS_CYGWIN);
        out.println("IS_MSYSTEM = " + OSUtils.IS_MSYSTEM);
        out.println("IS_WSL =     " + OSUtils.IS_WSL);
        out.println("IS_WSL1 =    " + OSUtils.IS_WSL1);
        out.println("IS_WSL2 =    " + OSUtils.IS_WSL2);
        out.println("IS_CONEMU =  " + OSUtils.IS_CONEMU);
        out.println("IS_OSX =     " + OSUtils.IS_OSX);
        out.println();
        out.println("FFM Support");
        out.println("=================");
        try {
            provider = TerminalProvider.load("ffm");
            Diag.testProvider(out, provider);
        }
        catch (Throwable t2) {
            out.println("FFM support not available: " + t2);
        }
        out.println();
        out.println("JnaSupport");
        out.println("=================");
        try {
            provider = TerminalProvider.load("jna");
            Diag.testProvider(out, provider);
        }
        catch (Throwable t3) {
            out.println("JNA support not available: " + t3);
        }
        out.println();
        out.println("Jansi2Support");
        out.println("=================");
        try {
            provider = TerminalProvider.load("jansi");
            Diag.testProvider(out, provider);
        }
        catch (Throwable t4) {
            out.println("Jansi 2 support not available: " + t4);
        }
        out.println();
        out.println("JniSupport");
        out.println("=================");
        try {
            provider = TerminalProvider.load("jni");
            Diag.testProvider(out, provider);
        }
        catch (Throwable t5) {
            out.println("JNI support not available: " + t5);
        }
        out.println();
        out.println("Exec Support");
        out.println("=================");
        try {
            provider = TerminalProvider.load("exec");
            Diag.testProvider(out, provider);
        }
        catch (Throwable t6) {
            out.println("Exec support not available: " + t6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testProvider(PrintStream out, TerminalProvider provider) {
        block19: {
            try {
                out.println("StdIn stream =    " + provider.isSystemStream(SystemStream.Input));
                out.println("StdOut stream =   " + provider.isSystemStream(SystemStream.Output));
                out.println("StdErr stream =   " + provider.isSystemStream(SystemStream.Error));
            }
            catch (Throwable t2) {
                out.println("Unable to check stream: " + t2);
            }
            try {
                out.println("StdIn stream name =     " + provider.systemStreamName(SystemStream.Input));
                out.println("StdOut stream name =    " + provider.systemStreamName(SystemStream.Output));
                out.println("StdErr stream name =    " + provider.systemStreamName(SystemStream.Error));
            }
            catch (Throwable t2) {
                out.println("Unable to check stream names: " + t2);
            }
            try (Terminal terminal = provider.sysTerminal("diag", "xterm", false, StandardCharsets.UTF_8, false, Terminal.SignalHandler.SIG_DFL, false, SystemStream.Output);){
                if (terminal != null) {
                    Attributes attr = terminal.enterRawMode();
                    try {
                        out.println("Terminal size: " + terminal.getSize());
                        Future t2 = new ForkJoinPool(1).submit(() -> terminal.reader().read(1L));
                        int r = (Integer)((ForkJoinTask)t2).get(1000L, TimeUnit.MILLISECONDS);
                        StringBuilder sb = new StringBuilder();
                        sb.append("The terminal seems to work: ");
                        sb.append("terminal ").append(terminal.getClass().getName());
                        if (terminal instanceof AbstractPosixTerminal) {
                            sb.append(" with pty ").append(((AbstractPosixTerminal)terminal).getPty().getClass().getName());
                        }
                        out.println(sb);
                        terminal.setAttributes(attr);
                        break block19;
                    }
                    catch (Throwable t3) {
                        try {
                            out.println("Unable to read from terminal: " + t3);
                            t3.printStackTrace();
                            break block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            terminal.setAttributes(attr);
                        }
                    }
                }
                out.println("Not supported by provider");
            }
            catch (Throwable t2) {
                out.println("Unable to open terminal: " + t2);
                t2.printStackTrace();
            }
        }
    }

    static <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

