/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.commands.builtin.account;

import de.cubeside.globalserver.ClientConfig;
import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.commands.ServerCommand;
import de.cubeside.globalserver.commands.SubCommand;
import de.iani.cubesideutils.commands.ArgsParser;
import java.util.ArrayList;
import java.util.Collection;

public class AccountRemoveGroupCommand
extends SubCommand {
    @Override
    public String getUsage() {
        return "<account> <group>";
    }

    @Override
    public boolean onCommand(GlobalServer server, ServerCommand command, String commandString, ArgsParser args) {
        if (args.remaining() != 2) {
            return false;
        }
        String accountName = args.getNext().toLowerCase().trim();
        String group = args.getNext();
        ClientConfig account = server.getAccount(accountName);
        if (account == null) {
            GlobalServer.LOGGER.info("Account " + accountName + " does not exist!");
            return true;
        }
        account.getGroups().remove(group);
        server.saveConfig();
        GlobalServer.LOGGER.info("Account " + accountName + " has no longer group " + group + ".");
        server.reloadGroupsForAccount(accountName);
        return true;
    }

    @Override
    public Collection<String> onTabComplete(GlobalServer server, ServerCommand command, ArgsParser args) {
        ClientConfig account;
        if (args.remaining() == 1) {
            ArrayList<String> result = new ArrayList<String>();
            for (ClientConfig e : server.getAccounts()) {
                result.add(e.getLogin());
            }
            return result;
        }
        if (args.remaining() == 2 && (account = server.getAccount(args.getNext())) != null) {
            return account.getAllowedChannels();
        }
        return null;
    }
}

