/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.collections;

import de.iani.cubesideutils.collections.GeneralHashMap;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;

public class LinkedGeneralHashMap<K, V>
extends GeneralHashMap<K, V> {
    private final boolean accessOrder;
    private transient LinkedEntry head;
    private transient LinkedEntry tail;

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity, float loadFactor) {
        super(hasher, equality, initialCapacity, loadFactor);
        this.head = null;
        this.tail = null;
        this.accessOrder = false;
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity) {
        super(hasher, equality, initialCapacity);
        this.head = null;
        this.tail = null;
        this.accessOrder = false;
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality) {
        super(hasher, equality);
        this.head = null;
        this.tail = null;
        this.accessOrder = false;
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, Map<? extends K, ? extends V> m4) {
        super(hasher, equality);
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
        this.putAll(m4);
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity, float loadFactor, boolean accessOrder) {
        super(hasher, equality, initialCapacity, loadFactor);
        this.head = null;
        this.tail = null;
        this.accessOrder = accessOrder;
    }

    LinkedEntry[] newElementArray(int s2) {
        return new LinkedEntry[s2];
    }

    @Override
    public boolean containsValue(Object value) {
        LinkedEntry entry = this.head;
        if (null == value) {
            while (null != entry) {
                if (null == entry.value) {
                    return true;
                }
                entry = entry.chainForward;
            }
        } else {
            while (null != entry) {
                if (value.equals(entry.value)) {
                    return true;
                }
                entry = entry.chainForward;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        LinkedEntry m4 = (LinkedEntry)this.getEntry(key);
        if (m4 == null) {
            return null;
        }
        if (this.accessOrder && this.tail != m4) {
            LinkedEntry p = m4.chainBackward;
            LinkedEntry n = m4.chainForward;
            n.chainBackward = p;
            if (p != null) {
                p.chainForward = n;
            } else {
                this.head = n;
            }
            m4.chainForward = null;
            m4.chainBackward = this.tail;
            this.tail.chainForward = m4;
            this.tail = m4;
        }
        return (V)m4.value;
    }

    @Override
    GeneralHashMap.Entry createEntry(K key, int index, V value) {
        LinkedEntry m4 = new LinkedEntry(key, value);
        m4.next = this.elementData[index];
        this.elementData[index] = m4;
        this.linkEntry(m4);
        return m4;
    }

    @Override
    GeneralHashMap.Entry createHashedEntry(K key, int index, int hash) {
        LinkedEntry m4 = new LinkedEntry(key, hash);
        m4.next = this.elementData[index];
        this.elementData[index] = m4;
        this.linkEntry(m4);
        return m4;
    }

    @Override
    public V put(K key, V value) {
        V result = this.putImpl(key, value);
        if (this.removeEldestEntry(this.head)) {
            this.remove(this.head.key);
        }
        return result;
    }

    @Override
    V putImpl(K key, V value) {
        int hash;
        int index;
        LinkedEntry m4;
        if (this.elementCount == 0) {
            this.tail = null;
            this.head = null;
        }
        if ((m4 = (LinkedEntry)this.findEntry(key, index = ((hash = this.computeHashCode(key)) & Integer.MAX_VALUE) % this.elementData.length, hash)) == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            }
            m4 = (LinkedEntry)this.createHashedEntry(key, index, hash);
        } else {
            this.linkEntry(m4);
        }
        Object result = m4.value;
        m4.value = value;
        return (V)result;
    }

    void linkEntry(LinkedEntry m4) {
        if (this.tail == m4) {
            return;
        }
        if (this.head == null) {
            this.head = this.tail = m4;
            return;
        }
        LinkedEntry p = m4.chainBackward;
        LinkedEntry n = m4.chainForward;
        if (p == null) {
            if (n != null) {
                if (this.accessOrder) {
                    this.head = n;
                    n.chainBackward = null;
                    m4.chainBackward = this.tail;
                    m4.chainForward = null;
                    this.tail.chainForward = m4;
                    this.tail = m4;
                }
            } else {
                m4.chainBackward = this.tail;
                m4.chainForward = null;
                this.tail.chainForward = m4;
                this.tail = m4;
            }
            return;
        }
        if (n == null) {
            return;
        }
        if (this.accessOrder) {
            p.chainForward = n;
            n.chainBackward = p;
            m4.chainForward = null;
            m4.chainBackward = this.tail;
            this.tail.chainForward = m4;
            this.tail = m4;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new LinkedEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return LinkedGeneralHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return LinkedGeneralHashMap.this.size();
                }

                @Override
                public void clear() {
                    LinkedGeneralHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (LinkedGeneralHashMap.this.containsKey(key)) {
                        LinkedGeneralHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return LinkedGeneralHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return LinkedGeneralHashMap.this.size();
                }

                @Override
                public void clear() {
                    LinkedGeneralHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }
            };
        }
        return this.values;
    }

    @Override
    public V remove(Object key) {
        LinkedEntry m4 = (LinkedEntry)this.removeEntry(key);
        if (m4 == null) {
            return null;
        }
        LinkedEntry p = m4.chainBackward;
        LinkedEntry n = m4.chainForward;
        if (p != null) {
            p.chainForward = n;
        } else {
            this.head = n;
        }
        if (n != null) {
            n.chainBackward = p;
        } else {
            this.tail = p;
        }
        return (V)m4.value;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    class LinkedEntry
    extends GeneralHashMap.Entry {
        LinkedEntry chainForward;
        LinkedEntry chainBackward;

        LinkedEntry(K theKey, V theValue) {
            super(theKey, theValue);
            this.chainForward = null;
            this.chainBackward = null;
        }

        LinkedEntry(K theKey, int hash) {
            super(theKey, hash);
            this.chainForward = null;
            this.chainBackward = null;
        }

        @Override
        public Object clone() {
            LinkedEntry entry = (LinkedEntry)super.clone();
            entry.chainBackward = this.chainBackward;
            entry.chainForward = this.chainForward;
            LinkedEntry lnext = (LinkedEntry)entry.next;
            if (lnext != null) {
                entry.next = (LinkedEntry)lnext.clone();
            }
            return entry;
        }
    }

    final class LinkedEntrySet
    extends GeneralHashMap.EntrySet {
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }
    }

    private class ValueIterator
    extends AbstractMapIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            this.makeNext();
            return this.currentEntry.value;
        }
    }

    private class KeyIterator
    extends AbstractMapIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            this.makeNext();
            return this.currentEntry.key;
        }
    }

    private class EntryIterator
    extends AbstractMapIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private class AbstractMapIterator {
        int expectedModCount;
        LinkedEntry futureEntry;
        LinkedEntry currentEntry;

        AbstractMapIterator() {
            this.expectedModCount = LinkedGeneralHashMap.this.modCount;
            this.futureEntry = LinkedGeneralHashMap.this.head;
        }

        public boolean hasNext() {
            return this.futureEntry != null;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != LinkedGeneralHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentEntry = this.futureEntry;
            this.futureEntry = this.futureEntry.chainForward;
        }

        public void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            LinkedGeneralHashMap.this.removeEntry(this.currentEntry);
            LinkedEntry lhme = this.currentEntry;
            LinkedEntry p = lhme.chainBackward;
            LinkedEntry n = lhme.chainForward;
            if (p != null) {
                p.chainForward = n;
                if (n != null) {
                    n.chainBackward = p;
                } else {
                    LinkedGeneralHashMap.this.tail = p;
                }
            } else {
                LinkedGeneralHashMap.this.head = n;
                if (n != null) {
                    n.chainBackward = null;
                } else {
                    LinkedGeneralHashMap.this.tail = null;
                }
            }
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

