/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.util.Calendar;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.codec.LocalDateTimeCodec;
import org.mariadb.jdbc.plugin.codec.LocalTimeCodec;
import org.mariadb.jdbc.util.CharsetEncodingLength;

public class StringColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public StringColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected StringColumn(StringColumn prev) {
        super(prev, true);
    }

    @Override
    public int getDisplaySize() {
        if (this.charset != 63) {
            Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
            if (maxWidth != null) {
                return (int)(this.columnLength / (long)maxWidth.intValue());
            }
            return (int)(this.columnLength / 4L);
        }
        return (int)this.columnLength;
    }

    @Override
    public StringColumn useAliasAsName() {
        return new StringColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return this.isBinary() ? "byte[]" : String.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        if (this.dataType == DataType.NULL) {
            return 0;
        }
        if (this.dataType == DataType.STRING) {
            return this.isBinary() ? -3 : 1;
        }
        if (this.columnLength <= 0L || this.getDisplaySize() > 0xFFFFFF) {
            return this.isBinary() ? -4 : -1;
        }
        return this.isBinary() ? -3 : 12;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        switch (this.dataType) {
            case STRING: {
                if (this.isBinary()) {
                    return "BINARY";
                }
                return "CHAR";
            }
            case VARSTRING: 
            case VARCHAR: {
                if (this.isBinary()) {
                    return "VARBINARY";
                }
                if (this.columnLength < 0L) {
                    return "LONGTEXT";
                }
                if (this.getDisplaySize() <= 65532) {
                    return "VARCHAR";
                }
                if (this.getDisplaySize() <= 65535) {
                    return "TEXT";
                }
                if (this.getDisplaySize() <= 0xFFFFFF) {
                    return "MEDIUMTEXT";
                }
                return "LONGTEXT";
            }
        }
        return this.dataType.name();
    }

    @Override
    public int getPrecision() {
        Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
        if (maxWidth == null) {
            return (int)this.columnLength / 4;
        }
        return (int)(this.columnLength / (long)maxWidth.intValue());
    }

    @Override
    public Object getDefaultText(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        if (this.isBinary()) {
            byte[] arr = new byte[length.get()];
            buf.readBytes(arr);
            return arr;
        }
        return buf.readString(length.get());
    }

    @Override
    public Object getDefaultBinary(ReadableByteBuf buf, MutableInt length, Context context) throws SQLDataException {
        if (this.isBinary()) {
            byte[] arr = new byte[length.get()];
            buf.readBytes(arr);
            return arr;
        }
        return buf.readString(length.get());
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return !"0".equals(buf.readAscii(length.get()));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return !"0".equals(buf.readAscii(length.get()));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result;
        if (this.isBinary()) {
            byte b = buf.readByte();
            if (length.get() > 1) {
                buf.skip(length.get() - 1);
            }
            return b;
        }
        String str = buf.readString(length.get());
        try {
            result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValue();
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, this.dataType}));
        }
        if ((long)((byte)result) != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeByteText(buf, length);
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str = buf.readString(length.get());
        try {
            return new BigDecimal(str).setScale(0, RoundingMode.DOWN).shortValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Short", str));
        }
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeShortText(buf, length);
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str = buf.readString(length.get());
        try {
            return new BigDecimal(str).setScale(0, RoundingMode.DOWN).intValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", str));
        }
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeIntText(buf, length);
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str = buf.readString(length.get());
        try {
            return new BigInteger(str).longValueExact();
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str));
        }
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeLongText(buf, length);
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String val = buf.readString(length.get());
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Float", val));
        }
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeFloatText(buf, length);
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str2 = buf.readString(length.get());
        try {
            return Double.parseDouble(str2);
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Double", str2));
        }
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeDoubleText(buf, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        String val = buf.readString(length.get());
        if ("0000-00-00".equals(val)) {
            return null;
        }
        String[] stDatePart = val.split("[- ]");
        if (stDatePart.length < 3) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Date", new Object[]{val, this.dataType}));
        }
        try {
            int year = Integer.parseInt(stDatePart[0]);
            int month = Integer.parseInt(stDatePart[1]);
            int dayOfMonth = Integer.parseInt(stDatePart[2]);
            if (cal == null) {
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(1, year);
                c.set(2, month - 1);
                c.set(5, dayOfMonth);
                return new Date(c.getTimeInMillis());
            }
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.clear();
                cal.set(1, year);
                cal.set(2, month - 1);
                cal.set(5, dayOfMonth);
                return new Date(cal.getTimeInMillis());
            }
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Date", new Object[]{val, this.dataType}));
        }
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        return this.decodeDateText(buf, length, cal, context);
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal, Context context) throws SQLDataException {
        Calendar c = cal == null ? Calendar.getInstance() : cal;
        int offset = c.getTimeZone().getOffset(0L);
        int[] parts = LocalTimeCodec.parseTime(buf, length, this);
        long timeInMillis = ((long)parts[1] * 3600000L + (long)parts[2] * 60000L + (long)parts[3] * 1000L + (long)(parts[4] / 1000000)) * (long)parts[0] - (long)offset;
        return new Time(timeInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        Time t2;
        int[] parts = LocalTimeCodec.parseTime(buf, length, this);
        if (calParam == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setLenient(true);
            if (parts[0] == -1) {
                cal.set(1970, 0, 1, parts[0] * parts[1], parts[0] * parts[2], parts[0] * parts[3] - 1);
                t2 = new Time(cal.getTimeInMillis() + (long)(1000 - parts[4]));
            } else {
                cal.set(1970, 0, 1, parts[1], parts[2], parts[3]);
                t2 = new Time(cal.getTimeInMillis() + (long)(parts[4] / 1000000));
            }
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.setLenient(true);
                if (parts[0] == -1) {
                    calParam.set(1970, 0, 1, parts[0] * parts[1], parts[0] * parts[2], parts[0] * parts[3] - 1);
                    t2 = new Time(calParam.getTimeInMillis() + (long)(1000 - parts[4]));
                } else {
                    calParam.set(1970, 0, 1, parts[1], parts[2], parts[3]);
                    t2 = new Time(calParam.getTimeInMillis() + (long)(parts[4] / 1000000));
                }
            }
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        Timestamp timestamp;
        int begin;
        int pos = buf.pos();
        int nanoBegin = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (begin = 0; begin < length.get(); ++begin) {
            byte b = buf.readByte();
            if (b == 45 || b == 32 || b == 58) {
                ++partIdx;
                continue;
            }
            if (b == 46) {
                ++partIdx;
                nanoBegin = begin;
                continue;
            }
            if (b < 48 || b > 57) {
                buf.pos(pos);
                throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{buf.readString(length.get()), this.dataType}));
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
            length.set(-1);
            return null;
        }
        if (nanoBegin > 0) {
            for (begin = 0; begin < 6 - (length.get() - nanoBegin - 1); ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
        }
        if (calParam == null) {
            Calendar c = Calendar.getInstance();
            c.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
            timestamp = new Timestamp(c.getTime().getTime());
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                timestamp = new Timestamp(calParam.getTime().getTime());
            }
        }
        timestamp.setNanos(timestampsPart[6] * 1000);
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam, Context context) throws SQLDataException {
        String val = buf.readString(length.get());
        try {
            Timestamp timestamp;
            int[] parts = LocalDateTimeCodec.parseTimestamp(val);
            if (parts == null) {
                length.set(-1);
                return null;
            }
            int year = parts[0];
            int month = parts[1];
            int dayOfMonth = parts[2];
            int hour = parts[3];
            int minutes = parts[4];
            int seconds = parts[5];
            int microseconds = parts[6] / 1000;
            if (calParam == null) {
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
                timestamp = new Timestamp(cal.getTimeInMillis());
            } else {
                Calendar calendar = calParam;
                synchronized (calendar) {
                    calParam.clear();
                    calParam.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
                    timestamp = new Timestamp(calParam.getTimeInMillis());
                }
            }
            timestamp.setNanos(microseconds * 1000);
            return timestamp;
        }
        catch (DateTimeException dte) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{val, this.dataType}));
        }
    }
}

