/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.image;

import de.iani.cubesideutils.image.ImageProcessing;
import de.iani.cubesideutils.image.IndexedColorTable;
import java.awt.image.BufferedImage;

public class FloydSteinbergDithering
implements ImageProcessing {
    private IndexedColorTable colorTable;
    private int ditherReductionFactor;

    public FloydSteinbergDithering(IndexedColorTable colorTable) {
        this(colorTable, 1);
    }

    public FloydSteinbergDithering(IndexedColorTable colorTable, int ditherReductionFactor) {
        if (ditherReductionFactor < 1) {
            throw new IllegalArgumentException("ditherReductionFactor must be postive");
        }
        this.colorTable = colorTable;
        this.ditherReductionFactor = ditherReductionFactor;
    }

    @Override
    public void apply(BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int updated;
                int oldColor = image.getRGB(x, y);
                int nearestColor = this.colorTable.getRGBForIndex(this.colorTable.getNearestIndex(oldColor));
                image.setRGB(x, y, nearestColor);
                int a = oldColor >> 24 & 0xFF;
                int r = oldColor >> 16 & 0xFF;
                int g2 = oldColor >> 8 & 0xFF;
                int b = oldColor & 0xFF;
                int na = nearestColor >> 24 & 0xFF;
                int nr = nearestColor >> 16 & 0xFF;
                int ng = nearestColor >> 8 & 0xFF;
                int nb = nearestColor & 0xFF;
                int errA = a - na;
                int errR = r - nr;
                int errG = g2 - ng;
                int errB = b - nb;
                if (x + 1 < image.getWidth()) {
                    updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x + 1, y), errA, errR, errG, errB, 7, this.ditherReductionFactor);
                    image.setRGB(x + 1, y, updated);
                }
                if (y + 1 >= image.getHeight()) continue;
                updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x, y + 1), errA, errR, errG, errB, 5, this.ditherReductionFactor);
                image.setRGB(x, y + 1, updated);
                if (x - 1 >= 0) {
                    updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x - 1, y + 1), errA, errR, errG, errB, 3, this.ditherReductionFactor);
                    image.setRGB(x - 1, y + 1, updated);
                }
                if (x + 1 >= image.getWidth()) continue;
                updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x + 1, y + 1), errA, errR, errG, errB, 1, this.ditherReductionFactor);
                image.setRGB(x + 1, y + 1, updated);
            }
        }
    }

    private static int adjustPixel(int colorRgb, int errA, int errR, int errG, int errB, int mul, int ditherReductionFactor) {
        int a = FloydSteinbergDithering.clampToByte((colorRgb >> 24 & 0xFF) + errA * mul / (16 * ditherReductionFactor));
        int r = FloydSteinbergDithering.clampToByte((colorRgb >> 16 & 0xFF) + errR * mul / (16 * ditherReductionFactor));
        int g2 = FloydSteinbergDithering.clampToByte((colorRgb >> 8 & 0xFF) + errG * mul / (16 * ditherReductionFactor));
        int b = FloydSteinbergDithering.clampToByte((colorRgb & 0xFF) + errB * mul / (16 * ditherReductionFactor));
        return a << 24 | r << 16 | g2 << 8 | b;
    }

    private static int clampToByte(int value) {
        return Math.min(Math.max(value, 0), 255);
    }
}

