/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.event;

import de.cubeside.globalserver.event.AbstractEventHandler;
import de.cubeside.globalserver.event.ClassEventHandlerList;
import de.cubeside.globalserver.event.Event;
import de.cubeside.globalserver.event.EventHandler;
import de.cubeside.globalserver.event.Listener;
import de.cubeside.globalserver.event.ReflectionEventHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventBus {
    public static final Logger LOGGER = LogManager.getLogger("EventBus");
    private final ConcurrentHashMap<Class<?>, ClassEventHandlerList<?>> eventHandlerLists = new ConcurrentHashMap(16, 0.75f, 1);

    public <E extends Event> boolean dispatchEvent(E event) {
        ClassEventHandlerList<?> list = this.getEventHandlerList(event.getClass());
        AbstractEventHandler<?>[] handler = list.getEventHandlers();
        int l = handler.length;
        for (int i = 0; i < l; ++i) {
            try {
                handler[i].handle(event);
                continue;
            }
            catch (Throwable t2) {
                LOGGER.error("Exception while handling event for " + event.getClass().getTypeName(), t2);
            }
        }
        return l > 0;
    }

    public <T extends Event> ClassEventHandlerList<T> getEventHandlerList(Class<T> eventClass) {
        ClassEventHandlerList<?> list = this.eventHandlerLists.get(eventClass);
        if (list != null) {
            return list;
        }
        return this.addKnownClass(eventClass);
    }

    private synchronized <T extends Event> ClassEventHandlerList<T> addKnownClass(Class<T> eventClass) {
        ClassEventHandlerList<T> list = new ClassEventHandlerList<T>(eventClass);
        this.eventHandlerLists.put(eventClass, list);
        Class<T> superclass = eventClass.getSuperclass();
        if (superclass != null && Event.class.isAssignableFrom(superclass)) {
            ClassEventHandlerList<T> superlist = this.getEventHandlerList(superclass);
            superlist.addSubclass(list);
            for (AbstractEventHandler<T> e : superlist.getEventHandlers()) {
                list.registerHandler(e);
            }
        }
        return list;
    }

    public <T extends Event> void registerHandler(AbstractEventHandler<T> handler) {
        this.getEventHandlerList(handler.getEventClass()).registerHandler(handler);
    }

    public <T extends Event> void registerHandlers(Listener listener) {
        for (Method m4 : listener.getClass().getDeclaredMethods()) {
            EventHandler eventHandlerAnnotation = m4.getAnnotation(EventHandler.class);
            if (eventHandlerAnnotation == null) continue;
            Class<?>[] parameters = m4.getParameterTypes();
            int priority = eventHandlerAnnotation.priority();
            if (parameters.length != 1 || !Event.class.isAssignableFrom(parameters[0])) {
                throw new IllegalArgumentException("EventHandler " + m4.getName() + " is invalid. EventHandlers must have exatly 1 argument and it must be a subclass of Event.");
            }
            boolean isStatic = Modifier.isStatic(m4.getModifiers());
            m4.setAccessible(true);
            this.registerHandler(new ReflectionEventHandler(parameters[0], priority, isStatic ? null : listener, m4));
        }
    }

    public <T extends Event> void removeHandler(AbstractEventHandler<T> handler) {
        this.getEventHandlerList(handler.getEventClass()).removeHandler(handler);
    }

    public <T extends Event> void removeHandlers(Listener listener) {
        for (Method m4 : listener.getClass().getDeclaredMethods()) {
            EventHandler eventHandlerAnnotation = m4.getAnnotation(EventHandler.class);
            if (eventHandlerAnnotation == null) continue;
            Class<?>[] parameters = m4.getParameterTypes();
            int priority = eventHandlerAnnotation.priority();
            if (parameters.length != 1 || !Event.class.isAssignableFrom(parameters[0])) {
                throw new IllegalArgumentException("EventHandler " + m4.getName() + " is invalid. EventHandlers must have exatly 1 argument and it must be a subclass of Event.");
            }
            boolean isStatic = Modifier.isStatic(m4.getModifiers());
            m4.setAccessible(true);
            this.removeHandler(new ReflectionEventHandler(parameters[0], priority, isStatic ? null : listener, m4));
        }
    }
}

