/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.plugin;

import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.plugin.Plugin;
import de.cubeside.globalserver.plugin.PluginClassLoader;
import de.cubeside.globalserver.plugin.PluginContextException;
import de.cubeside.globalserver.plugin.PluginDescription;
import java.net.MalformedURLException;

public class PluginContext {
    private final GlobalServer server;
    private final PluginDescription description;
    private final PluginClassLoader classLoader;
    private Plugin mainClassInstance;

    public PluginContext(GlobalServer server, PluginDescription description) throws PluginContextException {
        this.server = server;
        this.description = description;
        try {
            this.classLoader = new PluginClassLoader(server, description, this.getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new PluginContextException("Could not create classloader for plugin " + description.getName() + ": " + e.getMessage(), e);
        }
    }

    void createMainClassInstance() throws PluginContextException {
        try {
            Class<?> main = this.classLoader.loadClass(this.description.getMainClass());
            if (!Plugin.class.isAssignableFrom(main)) {
                throw new ReflectiveOperationException("The specified class does not implement Plugin");
            }
            this.mainClassInstance = (Plugin)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | NoClassDefFoundError | ReflectiveOperationException e) {
            throw new PluginContextException("Could not instantiate the main class '" + this.description.getMainClass() + "' for the plugin " + this.description.getName(), e);
        }
    }

    public PluginDescription getDescription() {
        return this.description;
    }

    public PluginClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Plugin getMainClassInstance() {
        return this.mainClassInstance;
    }

    public GlobalServer getServer() {
        return this.server;
    }
}

