/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt.io;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.ByteArrayTag;
import de.iani.cubesideutils.nbt.ByteTag;
import de.iani.cubesideutils.nbt.CompoundTag;
import de.iani.cubesideutils.nbt.DoubleTag;
import de.iani.cubesideutils.nbt.FloatTag;
import de.iani.cubesideutils.nbt.IntArrayTag;
import de.iani.cubesideutils.nbt.IntTag;
import de.iani.cubesideutils.nbt.ListTag;
import de.iani.cubesideutils.nbt.LongArrayTag;
import de.iani.cubesideutils.nbt.LongTag;
import de.iani.cubesideutils.nbt.ShortTag;
import de.iani.cubesideutils.nbt.StringTag;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;

public class SnbtWriter
extends FilterWriter {
    private static final Pattern NON_QUOTE_PATTERN = Pattern.compile("[a-zA-Z_.+\\-]+");

    public SnbtWriter(Writer out) {
        super(out);
    }

    public void writeNbt(CompoundTag nbt) throws IOException {
        this.writeInternal(nbt);
    }

    private void writeInternal(BaseTag<?> tag) throws IOException {
        switch (tag.getType()) {
            case BYTE: {
                this.append(Byte.toString(((ByteTag)tag).getData())).write(98);
                break;
            }
            case SHORT: {
                this.append(Short.toString(((ShortTag)tag).getData())).write(115);
                break;
            }
            case INT: {
                this.write(Integer.toString(((IntTag)tag).getData()));
                break;
            }
            case LONG: {
                this.append(Long.toString(((LongTag)tag).getData())).write(76);
                break;
            }
            case FLOAT: {
                this.append(Float.toString(((FloatTag)tag).getData())).write(102);
                break;
            }
            case DOUBLE: {
                this.append(Double.toString(((DoubleTag)tag).getData())).write(100);
                break;
            }
            case BYTE_ARRAY: {
                byte[] data = ((ByteArrayTag)tag).getData();
                this.write("[B;");
                for (int i = 0; i < data.length; ++i) {
                    if (i > 0) {
                        this.write(44);
                    }
                    this.write(Byte.toString(data[i]));
                    this.write(98);
                }
                this.write(93);
                break;
            }
            case STRING: {
                this.writeEscapedString(((StringTag)tag).getData());
                break;
            }
            case LIST: {
                ListTag list = (ListTag)tag;
                this.write(91);
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.write(44);
                    }
                    this.writeInternal((BaseTag)list.get(i));
                }
                this.write(93);
                break;
            }
            case COMPOUND: {
                this.write(123);
                boolean first = true;
                CompoundTag compound = (CompoundTag)tag;
                for (Map.Entry entry : compound.entrySet()) {
                    if (!first) {
                        this.append(',');
                    }
                    first = false;
                    this.writeEscapedString((String)entry.getKey());
                    this.write(58);
                    this.writeInternal((BaseTag)entry.getValue());
                    first = false;
                }
                this.write(125);
                break;
            }
            case INT_ARRAY: {
                int[] data = ((IntArrayTag)tag).getData();
                this.write("[I;");
                for (int i = 0; i < data.length; ++i) {
                    if (i > 0) {
                        this.write(44);
                    }
                    this.write(Integer.toString(data[i]));
                }
                this.write(93);
                break;
            }
            case LONG_ARRAY: {
                long[] data = ((LongArrayTag)tag).getData();
                this.write("[L;");
                for (int i = 0; i < data.length; ++i) {
                    if (i > 0) {
                        this.write(44);
                    }
                    this.write(Long.toString(data[i]));
                    this.write(108);
                }
                this.write(93);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag type: " + String.valueOf((Object)tag.getType()));
            }
        }
    }

    private void writeEscapedString(String string) throws IOException {
        if (NON_QUOTE_PATTERN.matcher(string).matches() && !string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
            this.write(string);
        } else {
            this.write(34);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\\' || c == '\"') {
                    this.write(92);
                }
                this.write(c);
            }
            this.write(34);
        }
    }
}

