/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ClientConfig;
import de.cubeside.globalserver.ClientPacketType;
import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.OnlinePlayer;
import de.cubeside.globalserver.ServerPacketType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientConnection
extends Thread {
    protected static final Logger LOGGER = LogManager.getLogger("Client");
    private final SecureRandom random = new SecureRandom();
    private final GlobalServer server;
    private byte[] randomNumberServer;
    private byte[] randomNumberClient;
    private final Socket socket;
    private OutputStream socketos;
    private DataOutputStream os;
    private InputStream socketis;
    private DataInputStream is;
    private String account;
    private ClientConfig client;
    private HashMap<UUID, OnlinePlayer> playersOnline;
    private final Object sendSync = new Object();

    public ClientConnection(GlobalServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.playersOnline = new HashMap();
        try {
            socket.setSoTimeout(30000);
        }
        catch (SocketException e) {
            LOGGER.error("Could not set socket timeout!");
        }
    }

    @Override
    public void run() {
        LOGGER.info("Processing login request from " + this.socket.getInetAddress().getHostAddress());
        this.randomNumberServer = new byte[32];
        this.randomNumberClient = new byte[32];
        this.random.nextBytes(this.randomNumberServer);
        try {
            this.socketos = this.socket.getOutputStream();
            this.socketis = this.socket.getInputStream();
            this.os = new DataOutputStream(this.socketos);
            this.is = new DataInputStream(this.socketis);
            this.os.write(this.randomNumberServer);
            this.is.readFully(this.randomNumberClient);
            this.account = this.is.readUTF();
            byte[] password = new byte[32];
            this.is.readFully(password);
            ClientConfig result = this.server.processLogin(this, this.account, password, this.randomNumberServer, this.randomNumberClient);
            if (result == null) {
                LOGGER.info("Login for '" + this.account + "' failed from " + this.socket.getInetAddress().getHostAddress());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            while (true) {
                ClientPacketType packetType = ClientPacketType.valueOf(this.is.readByte());
                switch (packetType) {
                    case PING: {
                        this.sendPong();
                        break;
                    }
                    case PONG: {
                        break;
                    }
                    case PLAYER_ONLINE: {
                        long mostSigBits = this.is.readLong();
                        long leastSigBits = this.is.readLong();
                        UUID uuid = new UUID(mostSigBits, leastSigBits);
                        String name = this.is.readUTF();
                        long joinTime = this.is.readLong();
                        this.server.processPlayerOnline(this, uuid, name, joinTime);
                        break;
                    }
                    case PLAYER_OFFLINE: {
                        long mostSigBits = this.is.readLong();
                        long leastSigBits = this.is.readLong();
                        UUID uuid = new UUID(mostSigBits, leastSigBits);
                        this.server.processPlayerOffline(this, uuid);
                        break;
                    }
                    case SERVER_OFFLINE: {
                        LOGGER.info("Connection for '" + this.account + "' from " + this.socket.getInetAddress().getHostAddress() + " closed remotely.");
                        this.server.removeConnection(this);
                        this.socket.close();
                        return;
                    }
                    case DATA: {
                        int dataSize;
                        String channel = this.is.readUTF();
                        byte flags = this.is.readByte();
                        UUID targetUuid = null;
                        if ((flags & 1) != 0) {
                            long mostSigBits = this.is.readLong();
                            long leastSigBits = this.is.readLong();
                            targetUuid = new UUID(mostSigBits, leastSigBits);
                        }
                        String targetServer = null;
                        if ((flags & 2) != 0) {
                            targetServer = this.is.readUTF();
                        }
                        boolean allowRestricted = false;
                        if ((flags & 4) != 0) {
                            allowRestricted = true;
                        }
                        boolean toAllUnrestrictedServers = false;
                        if ((flags & 8) != 0) {
                            toAllUnrestrictedServers = true;
                        }
                        if ((dataSize = this.is.readInt()) > 10000000 || dataSize < 0) {
                            LOGGER.info("Oversized data packet received from '" + this.account + "' from " + this.socket.getInetAddress().getHostAddress() + " (" + dataSize + " bytes).");
                            this.socket.close();
                            break;
                        }
                        byte[] data = new byte[dataSize];
                        this.is.readFully(data);
                        this.server.processData(this, channel, targetUuid, targetServer, data, allowRestricted, toAllUnrestrictedServers);
                        break;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.server.removeConnection(this);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof SocketTimeoutException) {
                LOGGER.info("Connection for '" + this.account + "' from " + this.socket.getInetAddress().getHostAddress() + " timed out.");
            } else if (e instanceof IOException) {
                LOGGER.info("Connection for '" + this.account + "' from " + this.socket.getInetAddress().getHostAddress() + " closed: " + e.getMessage());
            } else {
                LOGGER.error("Exception in handler thread for '" + this.account + "' from " + this.socket.getInetAddress().getHostAddress() + ".", e);
            }
            return;
        }
    }

    public SecretKey generateSecretKey(SecureRandom random) {
        KeyGenerator keygeneratorAES;
        try {
            keygeneratorAES = KeyGenerator.getInstance("AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("No AES?", e);
        }
        keygeneratorAES.init(128, random);
        return keygeneratorAES.generateKey();
    }

    public void closeConnection() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getAccount() {
        return this.account;
    }

    public ClientConfig getClient() {
        return this.client;
    }

    void setClient(ClientConfig client) {
        this.client = client;
    }

    public OnlinePlayer addPlayer(UUID uuid, String name, long joinTime) {
        if (this.playersOnline.containsKey(uuid)) {
            return null;
        }
        OnlinePlayer joined = new OnlinePlayer(uuid, name, joinTime);
        this.playersOnline.put(uuid, joined);
        return joined;
    }

    public OnlinePlayer removePlayer(UUID uuid) {
        return this.playersOnline.remove(uuid);
    }

    public boolean hasPlayer(UUID uuid) {
        return this.playersOnline.containsKey(uuid);
    }

    public Collection<OnlinePlayer> getPlayers() {
        return this.playersOnline.values();
    }

    public void sendLoginResultAndActivateEncryption(boolean success, ClientConfig config) throws IOException {
        int i;
        byte[] secret;
        this.os.writeByte(success ? 0 : 1);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(this.randomNumberServer);
            if (config != null) {
                digest.update(config.getPassword().getBytes(StandardCharsets.UTF_8));
            }
            digest.update(this.randomNumberClient);
            secret = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        SecureRandom secureRandom = new SecureRandom();
        SecretKey kpOut = this.generateSecretKey(secureRandom);
        SecretKey kpIn = this.generateSecretKey(secureRandom);
        byte[] out = new byte[32];
        byte[] encoded = kpOut.getEncoded();
        for (i = 0; i < 16; ++i) {
            out[i] = (byte)(secret[i] ^ encoded[i]);
        }
        encoded = kpIn.getEncoded();
        for (i = 0; i < 16; ++i) {
            out[i + 16] = (byte)(secret[i + 16] ^ encoded[i]);
        }
        this.os.write(out);
        try {
            Cipher cipherAESout = Cipher.getInstance("AES/CFB8/NoPadding");
            cipherAESout.init(1, (Key)kpOut, new IvParameterSpec(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
            this.os = new DataOutputStream(new CipherOutputStream(new BufferedOutputStream(this.socketos), cipherAESout));
            Cipher cipherAESin = Cipher.getInstance("AES/CFB8/NoPadding");
            cipherAESin.init(2, (Key)kpIn, new IvParameterSpec(new byte[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}));
            this.is = new DataInputStream(new CipherInputStream(new BufferedInputStream(this.socketis), cipherAESin));
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPing() {
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.PING.ordinal());
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send PING");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPong() {
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.PONG.ordinal());
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send PONG");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendServerOnline(String server) {
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.SERVER_ONLINE.ordinal());
                    this.os.writeUTF(server);
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send SERVER_ONLINE");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendServerOffline(String server) {
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.SERVER_OFFLINE.ordinal());
                    this.os.writeUTF(server);
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send SERVER_OFFLINE");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPlayerOnline(String server, UUID uuid, String name, long joinTime) {
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.PLAYER_ONLINE.ordinal());
                    this.os.writeUTF(server);
                    this.os.writeLong(uuid.getMostSignificantBits());
                    this.os.writeLong(uuid.getLeastSignificantBits());
                    this.os.writeUTF(name);
                    this.os.writeLong(joinTime);
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send PLAYER_ONLINE");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPlayerOffline(String server, UUID uuid) {
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.PLAYER_OFFLINE.ordinal());
                    this.os.writeUTF(server);
                    this.os.writeLong(uuid.getMostSignificantBits());
                    this.os.writeLong(uuid.getLeastSignificantBits());
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send PLAYER_OFFLINE");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(ClientConnection fromServer, String channel, UUID targetUuid, ClientConnection targetServer, byte[] data) {
        if (fromServer == null) {
            throw new NullPointerException("fromServer");
        }
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        Object object = this.sendSync;
        synchronized (object) {
            if (this.os != null) {
                try {
                    this.os.writeByte(ServerPacketType.DATA.ordinal());
                    this.os.writeUTF(fromServer.getAccount());
                    this.os.writeUTF(channel);
                    int flags = (targetUuid != null ? 1 : 0) + (targetServer != null ? 2 : 0);
                    this.os.writeByte(flags);
                    if (targetUuid != null) {
                        this.os.writeLong(targetUuid.getMostSignificantBits());
                        this.os.writeLong(targetUuid.getLeastSignificantBits());
                    }
                    if (targetServer != null) {
                        this.os.writeUTF(targetServer.getAccount());
                    }
                    this.os.writeInt(data.length);
                    this.os.write(data);
                    this.os.flush();
                }
                catch (IOException e) {
                    LOGGER.error("Could not send DATA");
                }
            }
        }
    }

    public OnlinePlayer getPlayer(UUID uuid) {
        return this.playersOnline.get(uuid);
    }
}

