/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt.io;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.ByteArrayTag;
import de.iani.cubesideutils.nbt.ByteTag;
import de.iani.cubesideutils.nbt.CompoundTag;
import de.iani.cubesideutils.nbt.DoubleTag;
import de.iani.cubesideutils.nbt.FloatTag;
import de.iani.cubesideutils.nbt.IntArrayTag;
import de.iani.cubesideutils.nbt.IntTag;
import de.iani.cubesideutils.nbt.ListTag;
import de.iani.cubesideutils.nbt.LongArrayTag;
import de.iani.cubesideutils.nbt.LongTag;
import de.iani.cubesideutils.nbt.ShortTag;
import de.iani.cubesideutils.nbt.StringTag;
import de.iani.cubesideutils.nbt.TagType;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class SnbtReader
extends FilterReader {
    private int lookAhead = Integer.MIN_VALUE;
    private int lookAhead2 = Integer.MIN_VALUE;
    private boolean lastStringEscaped = false;

    public SnbtReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.lookAhead == Integer.MIN_VALUE) {
            return super.read();
        }
        int c = this.lookAhead;
        this.lookAhead = this.lookAhead2;
        this.lookAhead2 = Integer.MIN_VALUE;
        return c;
    }

    private void pushLookAhead(char c) {
        if (this.lookAhead == Integer.MIN_VALUE) {
            this.lookAhead = c;
        } else if (this.lookAhead2 == Integer.MIN_VALUE) {
            this.lookAhead2 = this.lookAhead;
            this.lookAhead = c;
        } else {
            throw new IllegalStateException("lookahead overflow");
        }
    }

    public int readSkipSpace() throws IOException {
        int c = this.read();
        while (c == 32) {
            c = this.read();
        }
        return c;
    }

    public CompoundTag readNbt() throws IOException {
        char c = (char)this.readSkipSpace();
        if (c != '{') {
            throw new IOException("nbt must start with a compound");
        }
        CompoundTag tag = new CompoundTag();
        this.readInternal(tag);
        return tag;
    }

    private void readInternal(BaseTag<?> tag) throws IOException {
        switch (tag.getType()) {
            case BYTE_ARRAY: {
                char c = (char)this.readSkipSpace();
                if (c == ']') {
                    return;
                }
                this.pushLookAhead(c);
                ArrayList<Byte> tempList = new ArrayList<Byte>();
                do {
                    BaseTag<?> subtag;
                    if ((subtag = this.readAnyValue()).getType() != TagType.BYTE) {
                        throw new IOException("unexpected " + subtag.getType() + "; expected byte");
                    }
                    tempList.add(((ByteTag)subtag).getData());
                    c = (char)this.readSkipSpace();
                    if (c != ']') continue;
                    byte[] temp = new byte[tempList.size()];
                    for (int i = 0; i < temp.length; ++i) {
                        temp[i] = (Byte)tempList.get(i);
                    }
                    ((ByteArrayTag)tag).setData(temp);
                    return;
                } while (c == ',');
                throw new IOException(", expected");
            }
            case LIST: {
                ListTag list = (ListTag)tag;
                list.clear();
                char c = (char)this.readSkipSpace();
                if (c == ']') {
                    return;
                }
                this.pushLookAhead(c);
                do {
                    BaseTag<?> subtag = this.readAnyValue();
                    list.add(subtag);
                    c = (char)this.readSkipSpace();
                    if (c != ']') continue;
                    return;
                } while (c == ',');
                throw new IOException(", expected");
            }
            case COMPOUND: {
                CompoundTag compound = (CompoundTag)tag;
                compound.clear();
                char c = (char)this.readSkipSpace();
                if (c == '}') {
                    return;
                }
                this.pushLookAhead(c);
                do {
                    String name = this.readMaybeEscapedString();
                    c = (char)this.readSkipSpace();
                    if (c != ':') {
                        throw new IOException(": expected");
                    }
                    BaseTag<?> subtag = this.readAnyValue();
                    compound.put(name, subtag);
                    c = (char)this.readSkipSpace();
                    if (c != '}') continue;
                    return;
                } while (c == ',');
                throw new IOException(", expected");
            }
            case INT_ARRAY: {
                char c = (char)this.readSkipSpace();
                if (c == ']') {
                    return;
                }
                this.pushLookAhead(c);
                ArrayList<Integer> tempList = new ArrayList<Integer>();
                do {
                    BaseTag<?> subtag;
                    if ((subtag = this.readAnyValue()).getType() == TagType.INT) {
                        tempList.add(((IntTag)subtag).getData());
                    } else if (subtag.getType() == TagType.SHORT) {
                        tempList.add(Integer.valueOf(((ShortTag)subtag).getData()));
                    } else if (subtag.getType() == TagType.BYTE) {
                        tempList.add(Integer.valueOf(((ByteTag)subtag).getData()));
                    } else {
                        throw new IOException("unexpected " + subtag.getType() + "; expected int");
                    }
                    c = (char)this.readSkipSpace();
                    if (c != ']') continue;
                    int[] temp = new int[tempList.size()];
                    for (int i = 0; i < temp.length; ++i) {
                        temp[i] = (Integer)tempList.get(i);
                    }
                    ((IntArrayTag)tag).setData(temp);
                    return;
                } while (c == ',');
                throw new IOException(", expected");
            }
            case LONG_ARRAY: {
                char c = (char)this.readSkipSpace();
                if (c == ']') {
                    return;
                }
                this.pushLookAhead(c);
                ArrayList<Long> tempList = new ArrayList<Long>();
                do {
                    BaseTag<?> subtag;
                    if ((subtag = this.readAnyValue()).getType() == TagType.LONG) {
                        tempList.add(((LongTag)subtag).getData());
                    } else if (subtag.getType() == TagType.INT) {
                        tempList.add(Long.valueOf(((IntTag)subtag).getData()));
                    } else if (subtag.getType() == TagType.SHORT) {
                        tempList.add(Long.valueOf(((ShortTag)subtag).getData()));
                    } else if (subtag.getType() == TagType.BYTE) {
                        tempList.add(Long.valueOf(((ByteTag)subtag).getData()));
                    } else {
                        throw new IOException("unexpected " + subtag.getType() + "; expected long");
                    }
                    c = (char)this.readSkipSpace();
                    if (c != ']') continue;
                    long[] temp = new long[tempList.size()];
                    for (int i = 0; i < temp.length; ++i) {
                        temp[i] = (Long)tempList.get(i);
                    }
                    ((LongArrayTag)tag).setData(temp);
                    return;
                } while (c == ',');
                throw new IOException(", expected");
            }
        }
        throw new IllegalArgumentException("unknown tag type: " + tag.getType());
    }

    private BaseTag<?> readAnyValue() throws IOException {
        char c = (char)this.readSkipSpace();
        if (c == '{') {
            CompoundTag compound = new CompoundTag();
            this.readInternal(compound);
            return compound;
        }
        if (c == '[') {
            c = (char)this.read();
            if (c == 'B' || c == 'I' || c == 'L') {
                char c2 = (char)this.read();
                if (c2 == ';') {
                    if (c == 'B') {
                        ByteArrayTag array = new ByteArrayTag();
                        this.readInternal(array);
                        return array;
                    }
                    if (c == 'I') {
                        IntArrayTag array = new IntArrayTag();
                        this.readInternal(array);
                        return array;
                    }
                    if (c == 'L') {
                        LongArrayTag array = new LongArrayTag();
                        this.readInternal(array);
                        return array;
                    }
                } else {
                    this.pushLookAhead(c2);
                    this.pushLookAhead(c);
                }
            } else {
                this.pushLookAhead(c);
            }
            ListTag list = new ListTag();
            this.readInternal(list);
            return list;
        }
        this.pushLookAhead(c);
        String s2 = this.readMaybeEscapedString();
        if (!this.lastStringEscaped && !s2.isEmpty()) {
            if (s2.equalsIgnoreCase("true")) {
                return new ByteTag(1);
            }
            if (s2.equalsIgnoreCase("false")) {
                return new ByteTag(0);
            }
            char lastChar = s2.charAt(s2.length() - 1);
            if (lastChar == 'b' || lastChar == 'B') {
                try {
                    byte b = Byte.parseByte(s2.substring(0, s2.length() - 1));
                    return new ByteTag(b);
                }
                catch (NumberFormatException b) {}
            } else if (lastChar == 's' || lastChar == 'S') {
                try {
                    short sh = Short.parseShort(s2.substring(0, s2.length() - 1));
                    return new ShortTag(sh);
                }
                catch (NumberFormatException sh) {}
            } else if (lastChar == 'l' || lastChar == 'L') {
                try {
                    long l = Long.parseLong(s2.substring(0, s2.length() - 1));
                    return new LongTag(l);
                }
                catch (NumberFormatException l) {}
            } else if (lastChar == 'f' || lastChar == 'F') {
                try {
                    float f = Float.parseFloat(s2.substring(0, s2.length() - 1));
                    return new FloatTag(f);
                }
                catch (NumberFormatException f) {}
            } else if (lastChar == 'd' || lastChar == 'D') {
                try {
                    double d = Double.parseDouble(s2.substring(0, s2.length() - 1));
                    return new DoubleTag(d);
                }
                catch (NumberFormatException d) {}
            } else if (s2.indexOf(46) >= 0) {
                try {
                    double d = Double.parseDouble(s2);
                    return new DoubleTag(d);
                }
                catch (NumberFormatException d) {}
            } else {
                try {
                    int i = Integer.parseInt(s2);
                    return new IntTag(i);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new StringTag(s2);
    }

    private String readMaybeEscapedString() throws IOException {
        this.lastStringEscaped = false;
        char c = (char)this.readSkipSpace();
        if (c == '\"' || c == '\'') {
            this.lastStringEscaped = true;
            char endChar = c;
            StringBuilder sb = new StringBuilder();
            boolean escapeNext = false;
            while (true) {
                c = (char)this.read();
                if (escapeNext) {
                    sb.append(c);
                    escapeNext = false;
                    continue;
                }
                if (c == '\\') {
                    escapeNext = true;
                    continue;
                }
                if (c == endChar) break;
                sb.append(c);
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (c == '}' || c == ']' || c == ':' || c == ';' || c == ',' || c == ' ') {
                this.pushLookAhead(c);
                return sb.toString();
            }
            sb.append(c);
            c = (char)this.read();
        }
    }
}

