/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.event;

import de.cubeside.globalserver.event.AbstractEventHandler;
import de.cubeside.globalserver.event.Event;
import java.util.ArrayList;
import java.util.Comparator;

public class ClassEventHandlerList<E extends Event> {
    private final Comparator<? super AbstractEventHandler<? super E>> HANDLER_COMPARATOR = (a, b) -> a.getPriority() - b.getPriority();
    private final Class<? extends Event> eventClass;
    private final ArrayList<ClassEventHandlerList<? extends E>> subclasses;
    private final ArrayList<AbstractEventHandler<? super E>> handlers;
    private volatile AbstractEventHandler<? super E>[] handlerList;

    public ClassEventHandlerList(Class<E> eventClass) {
        this.eventClass = eventClass;
        this.subclasses = new ArrayList();
        this.handlers = new ArrayList();
    }

    public void addSubclass(ClassEventHandlerList<? extends E> list) {
        this.subclasses.add(list);
    }

    public Class<? extends Event> getEventClass() {
        return this.eventClass;
    }

    public synchronized void registerHandler(AbstractEventHandler<? super E> handler) {
        this.handlers.add(handler);
        this.handlers.sort(this.HANDLER_COMPARATOR);
        this.handlerList = null;
        if (this.subclasses.size() > 0) {
            for (ClassEventHandlerList<? super E> classEventHandlerList : this.subclasses) {
                classEventHandlerList.registerHandler(handler);
            }
        }
    }

    public synchronized void removeHandler(AbstractEventHandler<? super E> handler) {
        this.handlers.remove(handler);
        this.handlerList = null;
        if (this.subclasses.size() > 0) {
            for (ClassEventHandlerList<? super E> classEventHandlerList : this.subclasses) {
                classEventHandlerList.removeHandler(handler);
            }
        }
    }

    public AbstractEventHandler<? super E>[] getEventHandlers() {
        AbstractEventHandler<? super E>[] list = this.handlerList;
        if (list != null) {
            return list;
        }
        return this.recreateHandlerList();
    }

    private synchronized AbstractEventHandler<? super E>[] recreateHandlerList() {
        if (this.handlerList != null) {
            return this.handlerList;
        }
        this.handlerList = this.handlers.toArray(new AbstractEventHandler[this.handlers.size()]);
        return this.handlerList;
    }
}

