/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.internal.InternalPrintWriter;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerPrintWriter
extends PrintWriter {
    private static final String FQCN = LoggerPrintWriter.class.getName();
    private final InternalPrintWriter writer;

    protected LoggerPrintWriter(ExtendedLogger logger, boolean autoFlush, String fqcn, Level level, Marker marker) {
        super(new StringWriter());
        this.writer = new InternalPrintWriter(logger, autoFlush, fqcn == null ? FQCN : fqcn, level, marker);
    }

    protected LoggerPrintWriter(Writer writer, boolean autoFlush, ExtendedLogger logger, String fqcn, Level level, Marker marker) {
        super(writer);
        this.writer = new InternalPrintWriter(writer, autoFlush, logger, fqcn == null ? FQCN : fqcn, level, marker);
    }

    @Override
    public LoggerPrintWriter append(char c) {
        this.writer.append(c);
        return this;
    }

    @Override
    public LoggerPrintWriter append(CharSequence csq) {
        this.writer.append(csq);
        return this;
    }

    @Override
    public LoggerPrintWriter append(CharSequence csq, int start, int end) {
        this.writer.append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return this.writer.checkError();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public LoggerPrintWriter format(Locale l, String format, Object ... args) {
        this.writer.format(l, format, args);
        return this;
    }

    @Override
    public LoggerPrintWriter format(String format, Object ... args) {
        this.writer.format(format, args);
        return this;
    }

    @Override
    public void print(boolean b) {
        this.writer.print(b);
    }

    @Override
    public void print(char c) {
        this.writer.print(c);
    }

    @Override
    public void print(char[] s2) {
        this.writer.print(s2);
    }

    @Override
    public void print(double d) {
        this.writer.print(d);
    }

    @Override
    public void print(float f) {
        this.writer.print(f);
    }

    @Override
    public void print(int i) {
        this.writer.print(i);
    }

    @Override
    public void print(long l) {
        this.writer.print(l);
    }

    @Override
    public void print(Object obj) {
        this.writer.print(obj);
    }

    @Override
    public void print(String s2) {
        this.writer.print(s2);
    }

    @Override
    public LoggerPrintWriter printf(Locale l, String format, Object ... args) {
        this.writer.printf(l, format, args);
        return this;
    }

    @Override
    public LoggerPrintWriter printf(String format, Object ... args) {
        this.writer.printf(format, args);
        return this;
    }

    @Override
    public void println() {
        this.writer.println();
    }

    @Override
    public void println(boolean x) {
        this.writer.println(x);
    }

    @Override
    public void println(char x) {
        this.writer.println(x);
    }

    @Override
    public void println(char[] x) {
        this.writer.println(x);
    }

    @Override
    public void println(double x) {
        this.writer.println(x);
    }

    @Override
    public void println(float x) {
        this.writer.println(x);
    }

    @Override
    public void println(int x) {
        this.writer.println(x);
    }

    @Override
    public void println(long x) {
        this.writer.println(x);
    }

    @Override
    public void println(Object x) {
        this.writer.println(x);
    }

    @Override
    public void println(String x) {
        this.writer.println(x);
    }

    public String toString() {
        return LoggerPrintWriter.class.getSimpleName() + this.writer.toString();
    }

    @Override
    public void write(char[] buf) {
        this.writer.write(buf);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.writer.write(buf, off, len);
    }

    @Override
    public void write(int c) {
        this.writer.write(c);
    }

    @Override
    public void write(String s2) {
        this.writer.write(s2);
    }

    @Override
    public void write(String s2, int off, int len) {
        this.writer.write(s2, off, len);
    }
}

