/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.permissions;

import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.ServerConfig;
import de.cubeside.globalserver.permissions.GroupPermissions;
import de.cubeside.globalserver.permissions.GroupsConfig;
import de.cubeside.globalserver.permissions.impl.CircularDependenciesException;
import de.cubeside.globalserver.permissions.impl.PermissionSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class GlobalPermissions {
    public static final Logger LOGGER = LogManager.getLogger((String)"Permissions");
    private final PermissionSystem permissionSystem;
    private final File groupsFile = new File("groups.yml");
    private final Yaml configYaml;
    private GroupsConfig groupsConfig;

    public GlobalPermissions(GlobalServer globalServer) {
        this.permissionSystem = new PermissionSystem();
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
        loaderOptions.setNestingDepthLimit(Integer.MAX_VALUE);
        Constructor constructor = new Constructor(ServerConfig.class, loaderOptions);
        TypeDescription groupsConfigDescription = new TypeDescription(GroupsConfig.class);
        groupsConfigDescription.addPropertyParameters("groups", new Class[]{String.class, GroupPermissions.class});
        constructor.addTypeDescription(groupsConfigDescription);
        TypeDescription goupPermissionsDescription = new TypeDescription(GroupPermissions.class);
        goupPermissionsDescription.addPropertyParameters("permissions", new Class[]{String.class, Boolean.class});
        constructor.addTypeDescription(goupPermissionsDescription);
        this.configYaml = new Yaml((BaseConstructor)constructor);
        if (this.groupsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.groupsFile), Charset.forName("UTF-8")));){
                this.groupsConfig = (GroupsConfig)this.configYaml.loadAs((Reader)reader, GroupsConfig.class);
                this.saveConfig();
            }
            catch (Exception e) {
                LOGGER.error("Could not parse permission groups config!", (Throwable)e);
            }
        }
        if (this.groupsConfig == null) {
            this.groupsConfig = new GroupsConfig();
            LOGGER.info("Generating new permission groups config!");
            if (!this.groupsFile.exists()) {
                this.saveConfig();
            }
        }
        this.reloadAllGroups();
    }

    private void reloadAllGroups() {
        try {
            this.permissionSystem.editGroups(editor -> {
                editor.removeAllGroups();
                for (Map.Entry<String, GroupPermissions> e : this.groupsConfig.getGroups().entrySet()) {
                    String groupName = e.getKey();
                    for (Map.Entry<String, Boolean> p : e.getValue().getPermissions().entrySet()) {
                        editor.addPermissionToGroup(groupName, p.getKey(), p.getValue());
                    }
                }
            });
            LOGGER.info("Permissions loaded!");
        }
        catch (CircularDependenciesException e) {
            LOGGER.error("Could not update permission groups because of circular dependencies!", (Object)e.getMessage());
        }
    }

    public void saveConfig() {
        String output = this.configYaml.dumpAsMap((Object)this.groupsConfig);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.groupsFile), Charset.forName("UTF-8")));){
            writer.write(output);
        }
        catch (Exception e) {
            LOGGER.error("Could not save config!", (Throwable)e);
        }
    }
}

