/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.permissions.impl;

import de.cubeside.globalserver.permissions.impl.CalculatedUserPermissions;
import de.cubeside.globalserver.permissions.impl.CircularDependenciesException;
import de.cubeside.globalserver.permissions.impl.MapWrapperWithCachedHash;
import de.cubeside.globalserver.permissions.impl.PermissionGroup;
import de.cubeside.globalserver.permissions.impl.PermissionUser;
import de.cubeside.globalserver.utils.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class PermissionSystem {
    private final ConcurrentHashMap<String, PermissionGroup> groups = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, PermissionUser> users = new ConcurrentHashMap();
    private final ConcurrentHashMap<MapWrapperWithCachedHash<HashMap<String, Boolean>>, CalculatedUserPermissions> calculatedUserPerms = new ConcurrentHashMap();

    public PermissionGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public Collection<PermissionGroup> getGroups() {
        return new ArrayList<PermissionGroup>(this.groups.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionUser createOrEditUser(String name, Consumer<UserEditor> consumer) {
        PermissionUser user;
        PermissionUser permissionUser = user = this.users.computeIfAbsent(name, PermissionUser::new);
        synchronized (permissionUser) {
            consumer.accept(new UserEditor(user));
            user.commit();
            HashMap<String, Boolean> perms = user.getDirectPermissions();
            MapWrapperWithCachedHash<HashMap<String, Boolean>> wrappedPerms = new MapWrapperWithCachedHash<HashMap<String, Boolean>>(perms);
            PermissionSystem permissionSystem = this;
            synchronized (permissionSystem) {
                CalculatedUserPermissions calculated = this.calculatedUserPerms.computeIfAbsent(wrappedPerms, p -> new CalculatedUserPermissions((HashMap)p.getMap(), this.groups));
                user.setCalculatedPermissions(calculated);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadUser(String name) {
        PermissionUser user = this.users.remove(name);
        if (user != null) {
            PermissionSystem permissionSystem = this;
            synchronized (permissionSystem) {
                user.setCalculatedPermissions(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editGroups(Consumer<GroupEditor> consumer) throws CircularDependenciesException {
        PermissionSystem permissionSystem = this;
        synchronized (permissionSystem) {
            GroupEditor editor = new GroupEditor();
            consumer.accept(editor);
            try {
                editor.checkDependencies();
            }
            catch (CircularDependenciesException e) {
                editor.rollback();
                throw e;
            }
            editor.commit();
        }
    }

    public class UserEditor {
        private PermissionUser user;

        public UserEditor(PermissionUser user) {
            this.user = user;
        }

        public void addPermissionToUser(String permission, boolean value) {
            this.user.addEditorPermission(permission, value);
        }

        public void removePermissionFromUser(String permission) {
            this.user.removeEditorPermission(permission);
        }

        public void removeAllPermissions(String permission) {
            this.user.removeEditorAllPermissions(permission);
        }
    }

    public class GroupEditor {
        private HashMap<String, PermissionGroup> editorGroups;
        private HashSet<String> removedGroups;
        private HashSet<String> newGroups;

        public GroupEditor() {
            this.editorGroups = new HashMap<String, PermissionGroup>(PermissionSystem.this.groups);
            this.removedGroups = new HashSet();
            this.newGroups = new HashSet();
        }

        void rollback() {
            for (PermissionGroup group : this.editorGroups.values()) {
                group.cancelPermissionUpdates();
            }
        }

        void commit() {
            for (PermissionGroup group : this.editorGroups.values()) {
                group.commitPermissionUpdates(this.editorGroups);
            }
            PermissionSystem.this.groups.putAll(this.editorGroups);
            Iterator<PermissionGroup> it = PermissionSystem.this.groups.values().iterator();
            while (it.hasNext()) {
                PermissionGroup group;
                group = it.next();
                if (this.editorGroups.containsKey(group.getName())) continue;
                it.remove();
            }
            Iterator<CalculatedUserPermissions> it2 = PermissionSystem.this.calculatedUserPerms.values().iterator();
            while (it2.hasNext()) {
                CalculatedUserPermissions perms = it2.next();
                if (perms.getUseCounter() == 0) {
                    it2.remove();
                    continue;
                }
                perms.calculate(PermissionSystem.this.groups, this.removedGroups.isEmpty() && this.newGroups.isEmpty());
            }
        }

        void checkDependencies() throws CircularDependenciesException {
            ArrayDeque<PermissionGroup> groupStack = new ArrayDeque<PermissionGroup>();
            for (PermissionGroup group : this.editorGroups.values()) {
                group.updateDependencies(this.editorGroups, this.removedGroups.isEmpty() && this.newGroups.isEmpty(), groupStack);
                if (groupStack.isEmpty()) continue;
                throw new IllegalStateException("groupStack should be empty");
            }
        }

        public void removeAllGroups() {
            for (String groupName : this.editorGroups.keySet()) {
                if (this.newGroups.remove(groupName)) continue;
                this.removedGroups.add(groupName);
            }
            this.editorGroups.clear();
        }

        public void removeGroup(String groupName) {
            Preconditions.notNull(groupName, "groupName may not be null");
            if (this.editorGroups.remove(groupName) != null && !this.newGroups.remove(groupName)) {
                this.removedGroups.add(groupName);
            }
        }

        public void createGroup(String groupName) {
            Preconditions.notNull(groupName, "groupName may not be null");
            this.createGroupInternal(groupName);
        }

        private PermissionGroup createGroupInternal(String groupName) {
            PermissionGroup group = this.editorGroups.get(groupName);
            if (group == null) {
                group = new PermissionGroup(PermissionSystem.this, groupName);
                this.editorGroups.put(groupName, group);
                if (!this.removedGroups.remove(groupName)) {
                    this.newGroups.add(groupName);
                }
            }
            return group;
        }

        public void addPermissionToGroup(String groupName, String permission, boolean value) {
            Preconditions.notNull(groupName, "groupName may not be null");
            Preconditions.notNull(permission, "permission may not be null");
            PermissionGroup group = this.createGroupInternal(groupName);
            group.addEditorPermission(permission, value);
        }

        public void removePermissionFromGroup(String groupName, String permission) {
            Preconditions.notNull(groupName, "groupName may not be null");
            Preconditions.notNull(permission, "permission may not be null");
            PermissionGroup group = this.editorGroups.get(groupName);
            if (group == null) {
                return;
            }
            group.removeEditorPermission(permission);
        }

        public void setGroupPriority(String groupName, int priority) {
            Preconditions.notNull(groupName, "groupName may not be null");
            PermissionGroup group = this.createGroupInternal(groupName);
            group.setPriority(priority);
        }
    }
}

