/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.permissions.impl;

import de.cubeside.globalserver.permissions.impl.CircularDependenciesException;
import de.cubeside.globalserver.permissions.impl.PermissionGroupComparator;
import de.cubeside.globalserver.permissions.impl.PermissionSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PermissionGroup {
    private final String name;
    private int priority;
    private final HashMap<String, Boolean> directPermissions = new HashMap();
    private HashSet<String> directDependencies = new HashSet();
    private HashMap<String, Boolean> editorDirectPermissions;
    private HashSet<String> editorDirectDependencies;
    private boolean haveToRecalculatePermissions;
    volatile HashMap<String, Boolean> resolvedPermissions = new HashMap();

    public PermissionGroup(PermissionSystem permissionSystem, String name) {
        this.name = name;
    }

    void addEditorPermission(String permission, boolean value) {
        if (this.editorDirectPermissions == null) {
            this.editorDirectPermissions = new HashMap<String, Boolean>(this.directPermissions);
        }
        this.editorDirectPermissions.put(permission, value);
    }

    void removeEditorPermission(String permission) {
        if (this.editorDirectPermissions == null) {
            this.editorDirectPermissions = new HashMap<String, Boolean>(this.directPermissions);
        }
        this.editorDirectPermissions.remove(permission);
    }

    boolean updateDependencies(HashMap<String, PermissionGroup> editorGroups, boolean hasNoNewOrRemovedGroups, ArrayDeque<PermissionGroup> groupStack) throws CircularDependenciesException {
        if (groupStack.contains(this)) {
            throw new CircularDependenciesException(this, groupStack);
        }
        if (this.editorDirectDependencies != null) {
            return this.haveToRecalculatePermissions;
        }
        if (this.editorDirectPermissions == null && hasNoNewOrRemovedGroups) {
            this.editorDirectDependencies = this.directDependencies;
            groupStack.addLast(this);
            for (String dependencyName : this.editorDirectDependencies) {
                PermissionGroup dependency = editorGroups.get(dependencyName);
                if (dependency == null) continue;
                this.haveToRecalculatePermissions |= dependency.updateDependencies(editorGroups, hasNoNewOrRemovedGroups, groupStack);
            }
            if (groupStack.removeLast() != this) {
                throw new IllegalStateException("broken group stack");
            }
            return this.haveToRecalculatePermissions;
        }
        if (this.editorDirectPermissions != null) {
            this.haveToRecalculatePermissions = true;
        }
        groupStack.addLast(this);
        this.editorDirectDependencies = new HashSet();
        HashMap<String, Boolean> perms = this.editorDirectPermissions != null ? this.editorDirectPermissions : this.directPermissions;
        for (String permission : perms.keySet()) {
            PermissionGroup dependency = editorGroups.get(permission);
            if (dependency == null) continue;
            this.editorDirectDependencies.add(permission);
            this.haveToRecalculatePermissions |= dependency.updateDependencies(editorGroups, hasNoNewOrRemovedGroups, groupStack);
        }
        if (groupStack.removeLast() != this) {
            throw new IllegalStateException("broken group stack");
        }
        return this.haveToRecalculatePermissions;
    }

    void commitPermissionUpdates(HashMap<String, PermissionGroup> editorGroups) {
        if (this.editorDirectPermissions != null) {
            this.directPermissions.clear();
            this.directPermissions.putAll(this.editorDirectPermissions);
            this.editorDirectPermissions = null;
        }
        if (this.editorDirectDependencies != null && this.editorDirectDependencies != this.directDependencies) {
            this.directDependencies = this.editorDirectDependencies;
        }
        this.editorDirectDependencies = null;
        if (this.haveToRecalculatePermissions) {
            ArrayList<PermissionGroup> groupsByPriority = new ArrayList<PermissionGroup>();
            for (String dependencyName : this.directDependencies) {
                PermissionGroup dependency = editorGroups.get(dependencyName);
                if (dependency == null) continue;
                dependency.commitPermissionUpdates(editorGroups);
                groupsByPriority.add(dependency);
            }
            groupsByPriority.sort(PermissionGroupComparator.INSTANCE);
            HashMap<String, Boolean> resultingRermissions = new HashMap<String, Boolean>();
            HashSet<String> setByThisPriority = new HashSet<String>();
            for (int i = 0; i < groupsByPriority.size(); ++i) {
                Boolean dependencyValue;
                PermissionGroup dependency = (PermissionGroup)groupsByPriority.get(i);
                boolean nextHasSamePriority = false;
                if (i < groupsByPriority.size() - 1) {
                    PermissionGroup next = (PermissionGroup)groupsByPriority.get(i + 1);
                    if (next.priority == dependency.priority) {
                        nextHasSamePriority = true;
                    }
                }
                if ((dependencyValue = this.directPermissions.get(dependency.name)) == null) {
                    throw new IllegalStateException("dependencyValue may not be null here");
                }
                for (Map.Entry<String, Boolean> e : dependency.resolvedPermissions.entrySet()) {
                    Boolean old;
                    String permission = e.getKey();
                    Boolean permissionValue = e.getValue();
                    if (dependencyValue == Boolean.FALSE) {
                        Boolean bl = permissionValue = permissionValue == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if ((old = resultingRermissions.put(permission, permissionValue)) != null && old != permissionValue && setByThisPriority.contains(permission)) {
                        permissionValue = Boolean.FALSE;
                        resultingRermissions.put(permission, permissionValue);
                    }
                    if (!nextHasSamePriority) continue;
                    setByThisPriority.add(permission);
                }
                if (nextHasSamePriority) continue;
                setByThisPriority.clear();
            }
            for (Map.Entry<String, Boolean> e : this.directPermissions.entrySet()) {
                String permission = e.getKey();
                Boolean permissionValue = e.getValue();
                resultingRermissions.put(permission, permissionValue);
            }
            this.resolvedPermissions = resultingRermissions;
        }
        this.haveToRecalculatePermissions = false;
    }

    void cancelPermissionUpdates() {
        this.editorDirectPermissions = null;
        this.editorDirectDependencies = null;
        this.haveToRecalculatePermissions = false;
    }

    public boolean hasPermission(String permission) {
        return this.resolvedPermissions.get(permission) == Boolean.TRUE;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }
}

