/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.commands;

import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.commands.ServerCommand;
import de.cubeside.globalserver.commands.SubCommand;
import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.StringUtilCore;
import de.iani.cubesideutils.commands.AbstractCommandRouter;
import de.iani.cubesideutils.commands.ArgsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class CommandRouterCommand
extends AbstractCommandRouter<SubCommand, Void>
implements ServerCommand {
    public static final String UNKNOWN_COMMAND_MESSAGE = "Unknown command. Type \"/help\" for help.";
    private final String command;

    public CommandRouterCommand(String command) {
        super(true);
        this.command = command;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public SubCommand getSubCommand(String path) {
        String[] args = path.split(" ");
        Pair commandMapAndArg = this.matchCommandMap(null, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        return nr == args.length ? (SubCommand)currentMap.executor : null;
    }

    @Override
    public Collection<String> tabComplete(GlobalServer server, ArgsParser argsParser) {
        String[] args = argsParser.toArray();
        Pair commandMapAndArg = this.matchCommandMap(null, args, 1);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        String partial = args.length > 0 ? args[args.length - 1] : "";
        Collection<Object> options = null;
        ArrayList optionsList = null;
        options = currentMap.executor != null ? ((SubCommand)currentMap.executor).onTabComplete(server, this, new ArgsParser(args, nr)) : Collections.emptyList();
        if (nr == args.length - 1 && currentMap.subCommands != null) {
            for (Map.Entry e : currentMap.subCommands.entrySet()) {
                AbstractCommandRouter.CommandMap subcmd;
                String key = (String)e.getKey();
                if (!StringUtilCore.startsWithIgnoreCase((String)key, (String)partial) || !this.isAnySubCommandDisplayable(subcmd = (AbstractCommandRouter.CommandMap)e.getValue())) continue;
                if (optionsList == null) {
                    optionsList = options == null ? new ArrayList() : new ArrayList(options);
                    options = optionsList;
                }
                optionsList.add(key);
            }
        }
        if (options != null) {
            optionsList = StringUtilCore.copyPartialMatches((String)partial, options);
            Collections.sort(optionsList);
        }
        return optionsList;
    }

    @Override
    public void execute(GlobalServer server, ArgsParser argsParser) {
        String[] args = argsParser.toArray();
        Pair commandMapAndArg = this.matchCommandMap(null, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        SubCommand toExecute = (SubCommand)currentMap.executor;
        if (toExecute != null) {
            if (toExecute.onCommand(server, this, this.getCommandString(currentMap), new ArgsParser(args, nr))) {
                return;
            }
            this.showHelp(args);
            return;
        }
        this.showHelp(currentMap);
    }

    private String getCommandString(AbstractCommandRouter.CommandMap currentMap) {
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append('/').append(this.command).append(' ');
        ArrayList<AbstractCommandRouter.CommandMap> hierarchy = new ArrayList<AbstractCommandRouter.CommandMap>();
        AbstractCommandRouter.CommandMap map = currentMap;
        while (map != null) {
            hierarchy.add(map);
            map = map.parent;
        }
        for (int i = hierarchy.size() - 2; i >= 0; --i) {
            prefixBuilder.append(((AbstractCommandRouter.CommandMap)hierarchy.get((int)i)).name).append(' ');
        }
        return prefixBuilder.toString();
    }

    public void showHelp(String[] args) {
        Pair commandMapAndArg = this.matchCommandMap(null, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        this.showHelp(currentMap);
    }

    private void showHelp(AbstractCommandRouter.CommandMap currentMap) {
        if (currentMap.subCommands != null) {
            String prefix = this.getCommandString(currentMap);
            for (AbstractCommandRouter.CommandMap subcmd : currentMap.subcommandsOrdered) {
                String key = subcmd.name;
                if (subcmd.executor == null) {
                    if (!this.isAnySubCommandDisplayable(subcmd)) continue;
                    GlobalServer.LOGGER.info(prefix + key + " ...");
                    continue;
                }
                GlobalServer.LOGGER.info(prefix + key + " " + ((SubCommand)subcmd.executor).getUsage());
            }
        }
        if (currentMap.executor != null) {
            SubCommand executor = (SubCommand)currentMap.executor;
            String prefix = this.getCommandString(currentMap);
            GlobalServer.LOGGER.info(prefix + executor.getUsage());
        }
    }

    private boolean isAnySubCommandDisplayable(AbstractCommandRouter.CommandMap cmd) {
        if (cmd.executor != null) {
            return true;
        }
        if (cmd.subcommandsOrdered == null) {
            return false;
        }
        return !cmd.subcommandsOrdered.isEmpty();
    }
}

