/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.plugin;

import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.plugin.PluginClassLoader;
import de.cubeside.globalserver.plugin.PluginDescription;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Plugin {
    private final GlobalServer server;
    private final Logger logger;
    private final PluginDescription description;
    private final File dataFolder;

    public Plugin() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader;
            this.logger = LogManager.getLogger((String)pluginClassLoader.getPlugin().getName());
            this.server = pluginClassLoader.getServer();
            this.description = pluginClassLoader.getPlugin();
            this.dataFolder = new File(this.server.getPluginFolder(), this.description.getName());
        } else {
            this.logger = LogManager.getLogger((String)this.getClass().getName());
            this.logger.warn("Plugin " + this.getClass().getName() + " was not loaded by a PluginClassLoader");
            this.server = null;
            this.description = null;
            this.dataFolder = new File("./plugindata");
        }
    }

    public abstract void onLoad();

    public void onUnload() {
    }

    public final GlobalServer getServer() {
        return this.server;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final PluginDescription getDescription() {
        return this.description;
    }

    public final File getDataFolder() {
        return this.dataFolder;
    }
}

