/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ConsoleImpl;
import de.cubeside.globalserver.GlobalServer;
import de.cubeside.globalserver.ServerCommand;
import de.iani.cubesideutils.commands.ArgsParser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class JLineConsole
implements ConsoleImpl {
    private static final Logger logger = LogManager.getLogger("Console");
    private GlobalServer server;
    private SimpleConsoleReaderThread thread;
    private volatile boolean running;
    private Terminal terminal;
    private LineReader lineReader;

    public JLineConsole(GlobalServer server) {
        this.server = server;
        this.running = true;
        logger.log(Level.INFO, "Starting console...");
        try {
            this.terminal = TerminalBuilder.builder().build();
            this.lineReader = LineReaderBuilder.builder().terminal(this.terminal).history(new DefaultHistory()).completer(new ConsoleCompleter()).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
        }
        catch (IOException e) {
            logger.log(Level.ERROR, "Error creating console", (Throwable)e);
        }
        this.thread = new SimpleConsoleReaderThread();
        this.thread.setName("console");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void appendOutput(String message) {
        this.lineReader.printAbove(message);
    }

    @Override
    public void stop() {
        this.running = false;
        if (this.terminal != null) {
            try {
                this.terminal.close();
            }
            catch (IOException e) {
                logger.error("Exception while closing the console", (Throwable)e);
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    private class ConsoleCompleter
    implements Completer {
        private ConsoleCompleter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            block9: {
                Collection<String> result;
                block8: {
                    if (line.wordIndex() != 0) break block8;
                    for (String commandName : JLineConsole.this.server.getCommandNames()) {
                        candidates.add(new Candidate(commandName));
                    }
                    break block9;
                }
                List<String> words = line.words();
                ServerCommand command = JLineConsole.this.server.getCommand(words.get(0));
                if (command == null) break block9;
                int wordCount = line.wordIndex();
                String[] wordsArray = new String[wordCount];
                for (int i = 0; i < wordCount; ++i) {
                    wordsArray[i] = words.get(i + 1);
                }
                JLineConsole.this.server.getReadLock().lock();
                try {
                    result = command.tabComplete(JLineConsole.this.server, new ArgsParser(wordsArray));
                }
                finally {
                    JLineConsole.this.server.getReadLock().unlock();
                }
                if (result != null && !result.isEmpty()) {
                    for (String suggestion : result) {
                        candidates.add(new Candidate(suggestion));
                    }
                }
            }
        }
    }

    private class SimpleConsoleReaderThread
    extends Thread {
        private SimpleConsoleReaderThread() {
        }

        @Override
        public void run() {
            while (JLineConsole.this.running) {
                try {
                    String line = JLineConsole.this.lineReader.readLine("> ");
                    JLineConsole.this.server.processCommand(line == null ? "stop" : line);
                }
                catch (UserInterruptException e) {
                    logger.log(Level.ERROR, "User Interrupt", (Throwable)e);
                }
                catch (EndOfFileException e) {
                    JLineConsole.this.running = false;
                }
            }
            logger.log(Level.INFO, "Console shutdown completed.");
        }
    }
}

