/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorUtil {
    private IteratorUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static <T> T first(Iterable<T> of) {
        return of.iterator().next();
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        return () -> new Iterator<T>(){
            private Iterator<T>[] iterators;
            private int index;
            private int incremented;
            {
                this.iterators = (Iterator[])Arrays.stream(iterables).map(iterable -> iterable.iterator()).toArray(i -> new Iterator[iterables.length]);
                this.index = 0;
                this.incremented = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.index >= this.iterators.length) {
                    return false;
                }
                if (this.iterators[this.index].hasNext()) {
                    return true;
                }
                ++this.index;
                ++this.incremented;
                return this.hasNext();
            }

            @Override
            public T next() {
                try {
                    Object result = this.iterators[this.index].next();
                    this.incremented = 0;
                    return result;
                }
                catch (NoSuchElementException e) {
                    if (this.hasNext()) {
                        return this.next();
                    }
                    throw e;
                }
            }

            @Override
            public void remove() {
                int index = this.index - this.incremented;
                if (index >= this.iterators.length) {
                    throw new IllegalStateException();
                }
                this.iterators[index].remove();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> concatUnmodifiable(final Iterable<? extends T> ... iterables) {
        return () -> new Iterator<T>(){
            private Iterator<T>[] iterators;
            private int index;
            {
                this.iterators = (Iterator[])Arrays.stream(iterables).map(iterable -> iterable.iterator()).toArray(i -> new Iterator[iterables.length]);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.index >= this.iterators.length) {
                    return false;
                }
                if (this.iterators[this.index].hasNext()) {
                    return true;
                }
                ++this.index;
                return this.hasNext();
            }

            @Override
            public T next() {
                try {
                    return this.iterators[this.index].next();
                }
                catch (NoSuchElementException e) {
                    if (this.hasNext()) {
                        return this.next();
                    }
                    throw e;
                }
            }
        };
    }
}

