/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver.plugin;

import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import de.cubeside.globalserver.plugin.PluginDependency;
import de.cubeside.globalserver.plugin.PluginDescriptionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;

public class PluginDescription {
    private final File jarFile;
    private final String name;
    private final String mainClass;
    private final Semver version;
    private final List<PluginDependency> dependencies;
    private static final String IDENTIFIER = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern CLASS_NAME = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");

    public PluginDescription(File jarFile) throws PluginDescriptionException {
        Object loadbefore;
        Object softdepends;
        Object loaderOptions;
        this.jarFile = jarFile;
        Object root = null;
        try (JarFile jarJarFile = new JarFile(jarFile);){
            JarEntry pluginYmlEntry = jarJarFile.getJarEntry("plugin.yml");
            if (pluginYmlEntry == null) {
                throw new PluginDescriptionException("The plugin jar " + jarFile.getName() + " does not contain a plugin.yml");
            }
            loaderOptions = new LoaderOptions();
            loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
            loaderOptions.setNestingDepthLimit(Integer.MAX_VALUE);
            root = new Yaml((BaseConstructor)new SafeConstructor(loaderOptions)).load((Reader)new InputStreamReader((InputStream)new BufferedInputStream(jarJarFile.getInputStream(pluginYmlEntry)), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new PluginDescriptionException("Could not load plugin jar " + jarFile.getName() + ": " + e.getMessage(), e);
        }
        catch (YAMLException e) {
            throw new PluginDescriptionException("Could not load the plugin.yml in the plugin jar " + jarFile.getName() + ": " + e.getMessage(), e);
        }
        if (!(root instanceof Map)) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " has no root map");
        }
        Map map = (Map)root;
        loaderOptions = map.get("name");
        if (!(loaderOptions instanceof String)) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " is missing the required field 'name'");
        }
        String pluginName = (String)loaderOptions;
        Object v = map.get("main");
        if (!(v instanceof String)) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " is missing the required field 'main'");
        }
        String mainClass = (String)v;
        if (!PluginDescription.isValidClassName(mainClass)) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " contains an invalid main class name: " + mainClass);
        }
        Object versionObject = map.get("version");
        if (!(versionObject instanceof String) && !(versionObject instanceof Number)) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " is missing the required field 'version'");
        }
        this.name = pluginName.trim();
        if (this.name.isEmpty()) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " contains an invalid plugin name");
        }
        this.mainClass = mainClass.trim();
        try {
            this.version = new Semver(versionObject.toString().trim(), Semver.SemverType.NPM);
        }
        catch (SemverException e) {
            throw new PluginDescriptionException("The plugin.yml in the plugin jar " + jarFile.getName() + " contains an invalid version: " + e.getMessage(), e);
        }
        ArrayList<PluginDependency> dependencies = new ArrayList<PluginDependency>();
        Object depends = map.get("depend");
        if (depends instanceof String) {
            depends = List.of(depends);
        }
        if (depends instanceof List) {
            List l = (List)depends;
            for (Object e : l) {
                if (!(e instanceof String)) continue;
                String s = (String)e;
                dependencies.add(new PluginDependency(s, new Requirement[]{Requirement.buildNPM((String)"*")}, PluginDependency.LoadOrder.BEFORE, PluginDependency.Type.REQUIRED));
            }
        }
        if ((softdepends = map.get("softdepend")) instanceof String) {
            softdepends = List.of(depends);
        }
        if (softdepends instanceof List) {
            List l = (List)softdepends;
            for (Object e : l) {
                if (!(e instanceof String)) continue;
                String s = (String)e;
                dependencies.add(new PluginDependency(s, new Requirement[]{Requirement.buildNPM((String)"*")}, PluginDependency.LoadOrder.BEFORE, PluginDependency.Type.OPTIONAL));
            }
        }
        if ((loadbefore = map.get("load-before")) instanceof String) {
            loadbefore = List.of(depends);
        }
        if (loadbefore instanceof List) {
            List l = (List)loadbefore;
            for (Object e : l) {
                if (!(e instanceof String)) continue;
                String s = (String)e;
                dependencies.add(new PluginDependency(s, new Requirement[]{Requirement.buildNPM((String)"*")}, PluginDependency.LoadOrder.AFTER, PluginDependency.Type.OPTIONAL));
            }
        }
        this.dependencies = Collections.unmodifiableList(dependencies);
    }

    public String getName() {
        return this.name;
    }

    public Semver getVersion() {
        return this.version;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public List<PluginDependency> getDependencies() {
        return this.dependencies;
    }

    private static boolean isValidClassName(String className) {
        return CLASS_NAME.matcher(className).matches();
    }
}

