/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.TimestampCodec;

public class DateCodec
implements Codec<java.sql.Date> {
    public static final DateCodec INSTANCE = new DateCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATE, new DataType[]{DataType.NEWDATE, DataType.DATETIME, DataType.TIMESTAMP, DataType.YEAR, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return java.sql.Date.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(java.sql.Date.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof java.sql.Date || Date.class.equals(value.getClass());
    }

    @Override
    public java.sql.Date decodeText(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case YEAR: {
                short y = (short)buf.atoi(length);
                if (column.getLength() == 2L) {
                    y = y <= 69 ? (short)(y + 2000) : (short)(y + 1900);
                }
                return java.sql.Date.valueOf(y + "-01-01");
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: 
            case DATE: {
                String val = buf.readString(length);
                if ("0000-00-00".equals(val)) {
                    return null;
                }
                String[] stDatePart = val.split("[- ]");
                if (stDatePart.length < 3) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Date", new Object[]{val, column.getType()}));
                }
                return this.getDate(column, cal, val, stDatePart);
            }
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp lt = TimestampCodec.INSTANCE.decodeText(buf, length, column, cal);
                String st = lt.toString();
                return java.sql.Date.valueOf(st.substring(0, 10));
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{column.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.sql.Date getDate(Column column, Calendar cal, String val, String[] stDatePart) throws SQLDataException {
        try {
            Calendar c;
            int year = Integer.parseInt(stDatePart[0]);
            int month = Integer.parseInt(stDatePart[1]);
            int dayOfMonth = Integer.parseInt(stDatePart[2]);
            Calendar calendar = c = cal == null ? Calendar.getInstance() : cal;
            synchronized (calendar) {
                c.clear();
                c.set(1, year);
                c.set(2, month - 1);
                c.set(5, dayOfMonth);
                return new java.sql.Date(c.getTimeInMillis());
            }
        }
        catch (NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Date", new Object[]{val, column.getType()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.Date decodeBinary(ReadableByteBuf buf, int length, Column column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case YEAR: {
                int v = buf.readShort();
                if (column.getLength() == 2L) {
                    v = v <= 69 ? (v += 2000) : (v += 1900);
                }
                return java.sql.Date.valueOf(v + "-01-01");
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String val = buf.readString(length);
                String[] stDatePart = val.split("[- ]");
                if (stDatePart.length < 3) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Date", new Object[]{val, column.getType()}));
                }
                return this.getDate(column, cal, val, stDatePart);
            }
            case DATE: {
                Calendar c;
                if (length == 0) {
                    return null;
                }
                Calendar calendar = c = cal == null ? Calendar.getInstance() : cal;
                synchronized (calendar) {
                    c.clear();
                    c.set(1, buf.readShort());
                    c.set(2, buf.readByte() - 1);
                    c.set(5, buf.readByte());
                    return new java.sql.Date(c.getTimeInMillis());
                }
            }
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp lt = TimestampCodec.INSTANCE.decodeBinary(buf, length, column, cal);
                if (lt == null) {
                    return null;
                }
                String st = lt.toString();
                return java.sql.Date.valueOf(st.substring(0, 10));
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar providedCal, Long maxLength) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        cal.setTimeInMillis(((Date)value).getTime());
        encoder.writeByte(4);
        encoder.writeShort((short)cal.get(1));
        encoder.writeByte(cal.get(2) + 1 & 0xFF);
        encoder.writeByte(cal.get(5) & 0xFF);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATE.get();
    }
}

