/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.globalserver;

import de.cubeside.globalserver.ArgsParser;
import de.cubeside.globalserver.ClientConfig;
import de.cubeside.globalserver.ClientConnection;
import de.cubeside.globalserver.Console;
import de.cubeside.globalserver.JLineConsole;
import de.cubeside.globalserver.OnlinePlayer;
import de.cubeside.globalserver.ServerCommand;
import de.cubeside.globalserver.ServerConfig;
import de.cubeside.globalserver.ServerListener;
import de.cubeside.globalserver.command.AccountAddAllowedChannelCommand;
import de.cubeside.globalserver.command.AccountInfoCommand;
import de.cubeside.globalserver.command.AccountRemoveAllowedChannelCommand;
import de.cubeside.globalserver.command.AccountSetPasswordCommand;
import de.cubeside.globalserver.command.AccountSetRestrictedCommand;
import de.cubeside.globalserver.command.AccountsCommand;
import de.cubeside.globalserver.command.CreateAccountCommand;
import de.cubeside.globalserver.command.HelpCommand;
import de.cubeside.globalserver.command.ListCommand;
import de.cubeside.globalserver.command.ServersCommand;
import de.cubeside.globalserver.command.StopCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class GlobalServer {
    public static final Logger LOGGER;
    private ServerListener listener;
    private static Console console;
    private boolean running;
    private File configFile = new File("config.yml");
    private Yaml configYaml;
    private ServerConfig serverConfig;
    private HashMap<String, ClientConfig> clientConfigs;
    private ArrayList<ClientConnection> pendingConnections;
    private ArrayList<ClientConnection> connections;
    private HashMap<String, ServerCommand> commands;
    private final Object sync = new Object();

    public GlobalServer() {
        console = new JLineConsole(this);
        LOGGER.info("Starting GlobalServer...");
        Constructor constructor = new Constructor(ServerConfig.class);
        TypeDescription serverConfigDescription = new TypeDescription(ServerConfig.class);
        serverConfigDescription.addPropertyParameters("clientConfigs", new Class[]{ClientConfig.class});
        constructor.addTypeDescription(serverConfigDescription);
        this.configYaml = new Yaml((BaseConstructor)constructor);
        if (this.configFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.configFile), Charset.forName("UTF-8")));){
                this.serverConfig = (ServerConfig)this.configYaml.loadAs((Reader)reader, ServerConfig.class);
                this.saveConfig();
            }
            catch (Exception e) {
                LOGGER.error("Could not parse config!", (Throwable)e);
            }
        }
        if (this.serverConfig == null) {
            this.serverConfig = new ServerConfig();
            LOGGER.info("Generating new config!");
            if (!this.configFile.exists()) {
                this.saveConfig();
            }
        }
        this.clientConfigs = new HashMap();
        for (ClientConfig cc : this.serverConfig.getClientConfigs()) {
            this.clientConfigs.put(cc.getLogin(), cc);
        }
        this.pendingConnections = new ArrayList();
        this.connections = new ArrayList();
        this.commands = new HashMap();
        this.addCommand(new HelpCommand());
        this.addCommand(new StopCommand());
        this.addCommand(new ServersCommand());
        this.addCommand(new ListCommand());
        this.addCommand(new AccountsCommand());
        this.addCommand(new AccountInfoCommand());
        this.addCommand(new CreateAccountCommand());
        this.addCommand(new AccountSetPasswordCommand());
        this.addCommand(new AccountSetRestrictedCommand());
        this.addCommand(new AccountAddAllowedChannelCommand());
        this.addCommand(new AccountRemoveAllowedChannelCommand());
    }

    public Collection<ServerCommand> getCommands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }

    public Collection<String> getCommandNames() {
        return Collections.unmodifiableCollection(this.commands.keySet());
    }

    public ServerCommand getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    private void addCommand(ServerCommand command) {
        this.commands.put(command.getCommand().toLowerCase().trim(), command);
    }

    public void addAccount(String login, String password) {
        Objects.requireNonNull(login, "login must not be null");
        Objects.requireNonNull(password, "password must not be null");
        if (this.clientConfigs.containsKey(login)) {
            throw new IllegalArgumentException("Login name in use: " + login);
        }
        ClientConfig cfg = new ClientConfig(login, password, false, new HashSet<String>());
        this.clientConfigs.put(login, cfg);
        this.serverConfig.getClientConfigs().add(cfg);
        this.saveConfig();
    }

    public void saveConfig() {
        String output = this.configYaml.dumpAsMap((Object)this.serverConfig);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), Charset.forName("UTF-8")));){
            writer.write(output);
        }
        catch (Exception e) {
            LOGGER.error("Could not save config!", (Throwable)e);
        }
    }

    public Collection<ClientConfig> getAccounts() {
        return Collections.unmodifiableCollection(this.clientConfigs.values());
    }

    public ClientConfig getAccount(String name) {
        return this.clientConfigs.get(name);
    }

    public List<ClientConnection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        int port = this.serverConfig.getPort();
        if (port <= 0) {
            port = 25701;
            this.serverConfig.setPort(port);
            this.saveConfig();
        }
        try {
            this.listener = new ServerListener(this, port);
            this.listener.start();
        }
        catch (IOException e) {
            LOGGER.error("Could not bind to " + port + ": " + e.getMessage());
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            while (this.running) {
                for (ClientConnection cc : this.connections) {
                    cc.sendPing();
                }
                try {
                    this.sync.wait(20000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void main(String[] args) {
        new GlobalServer().run();
        LogManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommand(String line) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        int firstSpace = line.indexOf(32);
        String cmd = (firstSpace < 0 ? line : line.substring(0, firstSpace)).toLowerCase().trim();
        String args = firstSpace < 0 ? "" : line.substring(firstSpace + 1);
        Object object = this.sync;
        synchronized (object) {
            ServerCommand command = this.commands.get(cmd);
            if (command != null) {
                ArrayList<String> splitArgs = new ArrayList<String>();
                for (String s : args.trim().split(" ++")) {
                    String s2 = s.trim();
                    if (s2.length() <= 0) continue;
                    splitArgs.add(s2);
                }
                command.execute(this, new ArgsParser(splitArgs.toArray(new String[splitArgs.size()])));
            } else {
                LOGGER.info("Unknown command: " + cmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        this.listener.shutdown();
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            this.sync.notify();
            for (ClientConnection cc : new ArrayList<ClientConnection>(this.pendingConnections)) {
                cc.closeConnection();
            }
            this.pendingConnections.clear();
            for (ClientConnection cc : new ArrayList<ClientConnection>(this.connections)) {
                cc.closeConnection();
            }
            this.connections.clear();
        }
        console.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingConnection(ClientConnection connection) {
        Object object = this.sync;
        synchronized (object) {
            this.pendingConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ClientConnection connection) {
        Object object = this.sync;
        synchronized (object) {
            boolean wasOnline = this.connections.remove(connection);
            this.pendingConnections.remove(connection);
            if (wasOnline) {
                this.processServerOffline(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConfig processLogin(ClientConnection connection, String account, byte[] password, byte[] saltServer, byte[] saltClient) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            ClientConfig config = this.clientConfigs.get(account);
            if (config == null || !config.checkPassword(password, saltServer, saltClient)) {
                LOGGER.info("Login failed for '" + account + "'.");
                this.pendingConnections.remove(connection);
                connection.sendLoginResultAndActivateEncryption(false, null);
                return null;
            }
            LOGGER.info("Login successfull for '" + account + "'.");
            for (ClientConnection cc : this.connections) {
                if (!cc.getAccount().equals(account)) continue;
                cc.closeConnection();
                this.removeConnection(cc);
                break;
            }
            this.pendingConnections.remove(connection);
            this.connections.add(connection);
            connection.sendLoginResultAndActivateEncryption(true, config);
            for (ClientConnection cc : this.connections) {
                if (cc == connection) continue;
                cc.sendServerOnline(account);
                connection.sendServerOnline(cc.getAccount());
                Collection<OnlinePlayer> players = cc.getPlayers();
                for (OnlinePlayer e : players) {
                    connection.sendPlayerOnline(cc.getAccount(), e.getUuid(), e.getName(), e.getJoinTime());
                }
            }
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPlayerOnline(ClientConnection connection, UUID uuid, String name, long joinTime) {
        Object object = this.sync;
        synchronized (object) {
            if (connection.addPlayer(uuid, name, joinTime)) {
                for (ClientConnection cc : this.connections) {
                    if (cc == connection) continue;
                    cc.sendPlayerOnline(connection.getAccount(), uuid, name, joinTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPlayerOffline(ClientConnection connection, UUID uuid) {
        Object object = this.sync;
        synchronized (object) {
            if (connection.removePlayer(uuid)) {
                for (ClientConnection cc : this.connections) {
                    if (cc == connection) continue;
                    cc.sendPlayerOffline(connection.getAccount(), uuid);
                }
            }
        }
    }

    private void processServerOffline(ClientConnection connection) {
        for (ClientConnection cc : this.connections) {
            if (cc == connection) continue;
            cc.sendServerOffline(connection.getAccount());
        }
    }

    public void processData(ClientConnection connection, String channel, UUID targetUuid, String targetServer, byte[] data, boolean allowRestricted, boolean toAllUnrestrictedServers) {
        boolean fromRestricted = connection.getClient().isRestricted();
        if (!fromRestricted || connection.getClient().getAllowedChannels().contains(channel)) {
            for (ClientConnection cc : this.connections) {
                boolean explicitPlayer;
                boolean explicitServer;
                boolean toRestricted;
                if (cc == connection || (toRestricted = cc.getClient().isRestricted()) && !cc.getClient().getAllowedChannels().contains(channel)) continue;
                boolean bl = explicitServer = targetServer != null && cc.getAccount().equals(targetServer);
                if (targetServer != null && !explicitServer) continue;
                boolean bl2 = explicitPlayer = targetUuid != null && cc.hasPlayer(targetUuid);
                if (!toAllUnrestrictedServers && targetUuid != null && !explicitPlayer || !allowRestricted && (fromRestricted || toRestricted) && !explicitServer && !explicitPlayer) continue;
                cc.sendData(connection.getAccount(), channel, targetUuid, targetServer, data);
            }
        }
    }

    public static Console getConsole() {
        return console;
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        PrintStream logger = IoBuilder.forLogger((String)"System.out").setLevel(Level.INFO).buildPrintStream();
        PrintStream errorLogger = IoBuilder.forLogger((String)"System.err").setLevel(Level.ERROR).buildPrintStream();
        System.setOut(logger);
        System.setErr(errorLogger);
        LOGGER = LogManager.getLogger((String)"Server");
    }
}

