/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.ClientPacketType;
import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.cubeside.connection.ServerPacketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class GlobalClient
implements ConnectionAPI {
    private final Logger logger;
    private final String host;
    private final int port;
    private final String account;
    private final String password;
    private volatile boolean running;
    private final ClientThread connection;
    private final HashMap<String, GlobalServer> servers;
    private final HashMap<UUID, GlobalPlayer> players;
    private final Collection<GlobalServer> unmodifiableServers;
    private final Collection<GlobalPlayer> unmodifiablePlayers;

    protected GlobalClient(String host, int port, String account, String password, boolean startThread, Logger logger) {
        this.logger = logger != null ? logger : Logger.getLogger("GlobalClient");
        this.host = host;
        this.port = port;
        this.account = account;
        this.password = password;
        this.running = true;
        this.servers = new HashMap();
        this.unmodifiableServers = Collections.unmodifiableCollection(this.servers.values());
        this.players = new HashMap();
        this.unmodifiablePlayers = Collections.unmodifiableCollection(this.players.values());
        this.connection = new ClientThread();
        this.connection.setName("GlobalConnectionClient");
        this.connection.setDaemon(true);
        if (startThread) {
            this.connection.start();
        }
    }

    protected void startThread() {
        this.setServerOnline(this.account);
        this.connection.start();
    }

    protected void processData(GlobalServer source, String channel, GlobalPlayer targetPlayer, GlobalServer targetServer, byte[] data) {
        this.logger.info("Data from " + source + " in Channel " + channel + " to " + targetPlayer + "; " + targetServer + " Data: " + GlobalClient.bytesToHexString(data));
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer hexString = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    protected synchronized void setPlayerOffline(String server, UUID uuid) {
        if (!this.servers.containsKey(server)) {
            throw new IllegalArgumentException("Server " + server + " is not online.");
        }
        GlobalServer globalServer = this.servers.get(server);
        GlobalPlayer player = this.players.get(uuid);
        boolean leftTheNetwork = false;
        if (player == null) {
            throw new IllegalArgumentException("Player " + uuid + " is not online.");
        }
        if (!player.isOnServer(globalServer)) {
            throw new IllegalArgumentException("Player " + uuid + " is not on server " + server + ".");
        }
        player.removeServer(globalServer);
        if (!player.isOnAnyServer()) {
            this.players.remove(uuid);
            leftTheNetwork = true;
        }
        globalServer.removePlayer(uuid);
        this.onPlayerDisconnected(globalServer, player, leftTheNetwork);
    }

    protected synchronized void setPlayerOnline(String server, UUID uuid, String name, long joinTime) {
        if (!this.servers.containsKey(server)) {
            throw new IllegalArgumentException("Server " + server + " is not online.");
        }
        GlobalServer globalServer = this.servers.get(server);
        GlobalPlayer player = this.players.get(uuid);
        boolean joinedTheNetwork = false;
        if (player == null) {
            player = new GlobalPlayer(this, uuid, name, globalServer, joinTime);
            this.players.put(uuid, player);
            joinedTheNetwork = true;
        } else {
            if (player.isOnServer(globalServer)) {
                throw new IllegalArgumentException("Player " + uuid + " is already on server " + server + ".");
            }
            player.addServer(globalServer, joinTime);
        }
        globalServer.addPlayer(player);
        this.onPlayerJoined(globalServer, player, joinedTheNetwork);
    }

    protected abstract void onPlayerJoined(GlobalServer var1, GlobalPlayer var2, boolean var3);

    protected abstract void onPlayerDisconnected(GlobalServer var1, GlobalPlayer var2, boolean var3);

    protected abstract void onServerDisconnected(GlobalServer var1);

    protected abstract void onServerConnected(GlobalServer var1);

    protected synchronized void setServerOffine(String server) {
        if (!this.servers.containsKey(server)) {
            throw new IllegalArgumentException("Server " + server + " is not online.");
        }
        GlobalServer offline = this.servers.get(server);
        for (GlobalPlayer player : new ArrayList<GlobalPlayer>(offline.getPlayers())) {
            player.removeServer(offline);
            boolean leftTheNetwork = false;
            if (!player.isOnAnyServer()) {
                this.players.remove(player.getUniqueId());
                leftTheNetwork = true;
            }
            this.onPlayerDisconnected(offline, player, leftTheNetwork);
        }
        this.servers.remove(server);
        this.onServerDisconnected(offline);
    }

    protected synchronized void setServerOnline(String server) {
        if (this.servers.containsKey(server)) {
            throw new IllegalArgumentException("Server " + server + " is already online.");
        }
        GlobalServer joined = new GlobalServer(this, server);
        this.servers.put(server, joined);
        this.onServerConnected(joined);
    }

    protected synchronized void onPlayerOnline(UUID uuid, String name, long joinTime) {
        Objects.requireNonNull(uuid, "uuid");
        Objects.requireNonNull(name, "name");
        this.setPlayerOnline(this.account, uuid, name, joinTime);
        this.sendPlayerOnline(uuid, name, joinTime);
    }

    private void sendPlayerOnline(UUID uuid, String name, long joinTime) {
        DataOutputStream dos = this.connection.dos;
        if (dos != null) {
            try {
                dos.writeByte(ClientPacketType.PLAYER_ONLINE.ordinal());
                dos.writeLong(uuid.getMostSignificantBits());
                dos.writeLong(uuid.getLeastSignificantBits());
                dos.writeUTF(name);
                dos.writeLong(joinTime);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception sending player online!", e);
            }
        }
    }

    protected synchronized void onPlayerOffline(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        this.setPlayerOffline(this.account, uuid);
        DataOutputStream dos = this.connection.dos;
        if (dos != null) {
            try {
                dos.writeByte(ClientPacketType.PLAYER_OFFLINE.ordinal());
                dos.writeLong(uuid.getMostSignificantBits());
                dos.writeLong(uuid.getLeastSignificantBits());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception sending player offline!", e);
            }
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.sendData(channel, null, null, data);
    }

    protected synchronized void sendData(String channel, UUID targetUuid, String targetServer, byte[] data) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(data, "data");
        byte[] dataClone = (byte[])data.clone();
        DataOutputStream dos = this.connection.dos;
        if (dos != null) {
            try {
                dos.writeByte(ClientPacketType.DATA.ordinal());
                dos.writeUTF(channel);
                int flags = (targetUuid != null ? 1 : 0) + (targetServer != null ? 2 : 0);
                dos.writeByte(flags);
                if (targetUuid != null) {
                    dos.writeLong(targetUuid.getMostSignificantBits());
                    dos.writeLong(targetUuid.getLeastSignificantBits());
                }
                if (targetServer != null) {
                    dos.writeUTF(targetServer);
                }
                dos.writeInt(data.length);
                dos.write(dataClone);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception sending data!", e);
            }
        }
    }

    public void shutdown() {
        this.running = false;
        this.connection.shutdown();
    }

    protected abstract void runInMainThread(Runnable var1);

    @Override
    public Collection<GlobalServer> getServers() {
        return this.unmodifiableServers;
    }

    @Override
    public GlobalServer getServer(String name) {
        return this.servers.get(name);
    }

    @Override
    public Collection<GlobalPlayer> getPlayers() {
        return this.unmodifiablePlayers;
    }

    @Override
    public GlobalPlayer getPlayer(UUID uuid) {
        return this.players.get(uuid);
    }

    @Override
    public GlobalPlayer getPlayer(String name) {
        for (GlobalPlayer p : this.players.values()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private class ClientThread
    extends Thread {
        private Socket socket;
        private DataInputStream dis;
        private DataOutputStream dos;

        private ClientThread() {
        }

        @Override
        public void run() {
            while (GlobalClient.this.running) {
                try {
                    if (this.socket == null) {
                        DataOutputStream finalDos;
                        int i;
                        this.dis = null;
                        this.dos = null;
                        byte[] randomNumberClient = new byte[32];
                        new SecureRandom().nextBytes(randomNumberClient);
                        this.socket = new Socket(GlobalClient.this.host, GlobalClient.this.port);
                        DataInputStream dis = new DataInputStream(this.socket.getInputStream());
                        DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
                        dos.write(randomNumberClient);
                        byte[] randomNumberServer = new byte[32];
                        dis.readFully(randomNumberServer);
                        dos.writeUTF(GlobalClient.this.account);
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        digest.update(GlobalClient.this.password.getBytes(StandardCharsets.UTF_8));
                        digest.update(randomNumberServer);
                        digest.update(randomNumberClient);
                        byte[] encodedhash = digest.digest();
                        dos.write(encodedhash);
                        byte result = dis.readByte();
                        if (result == 1) {
                            GlobalClient.this.logger.severe("Login failed!");
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            dis = null;
                            dos = null;
                            this.socket = null;
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        digest.reset();
                        digest.update(randomNumberServer);
                        digest.update(GlobalClient.this.password.getBytes(StandardCharsets.UTF_8));
                        digest.update(randomNumberClient);
                        byte[] secret = digest.digest();
                        byte[] in = new byte[32];
                        dis.readFully(in);
                        byte[] keyInBytes = new byte[16];
                        byte[] keyOutBytes = new byte[16];
                        for (i = 0; i < 16; ++i) {
                            keyInBytes[i] = (byte)(secret[i] ^ in[i]);
                        }
                        for (i = 0; i < 16; ++i) {
                            keyOutBytes[i] = (byte)(secret[i + 16] ^ in[i + 16]);
                        }
                        SecretKeySpec kpOut = new SecretKeySpec(keyOutBytes, "AES");
                        SecretKeySpec kpIn = new SecretKeySpec(keyInBytes, "AES");
                        try {
                            Cipher cipherAESout = Cipher.getInstance("AES/CFB8/NoPadding");
                            cipherAESout.init(1, (Key)kpOut, new IvParameterSpec(new byte[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}));
                            finalDos = new DataOutputStream(new CipherOutputStream(this.socket.getOutputStream(), cipherAESout));
                            Cipher cipherAESin = Cipher.getInstance("AES/CFB8/NoPadding");
                            cipherAESin.init(2, (Key)kpIn, new IvParameterSpec(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
                            this.dis = new DataInputStream(new CipherInputStream(this.socket.getInputStream(), cipherAESin));
                        }
                        catch (GeneralSecurityException e) {
                            throw new Error(e);
                        }
                        GlobalClient.this.runInMainThread(new Runnable(){

                            @Override
                            public void run() {
                                ClientThread.this.sendClientsFromThisServer(finalDos);
                            }
                        });
                        GlobalClient.this.logger.info("Connection established!");
                        continue;
                    }
                    ServerPacketType packet = ServerPacketType.valueOf(this.dis.readByte());
                    switch (packet) {
                        case PING: {
                            this.sendPong();
                            break;
                        }
                        case PONG: {
                            break;
                        }
                        case SERVER_ONLINE: {
                            final String server = this.dis.readUTF();
                            GlobalClient.this.runInMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    GlobalClient.this.setServerOnline(server);
                                }
                            });
                            break;
                        }
                        case SERVER_OFFLINE: {
                            final String server = this.dis.readUTF();
                            GlobalClient.this.runInMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    GlobalClient.this.setServerOffine(server);
                                }
                            });
                            break;
                        }
                        case PLAYER_ONLINE: {
                            final String server = this.dis.readUTF();
                            long mostSigBits = this.dis.readLong();
                            long leastSigBits = this.dis.readLong();
                            final UUID uuid = new UUID(mostSigBits, leastSigBits);
                            final String name = this.dis.readUTF();
                            final long joinTime = this.dis.readLong();
                            GlobalClient.this.runInMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    GlobalClient.this.setPlayerOnline(server, uuid, name, joinTime);
                                }
                            });
                            break;
                        }
                        case PLAYER_OFFLINE: {
                            final String server = this.dis.readUTF();
                            long mostSigBits = this.dis.readLong();
                            long leastSigBits = this.dis.readLong();
                            final UUID uuid = new UUID(mostSigBits, leastSigBits);
                            GlobalClient.this.runInMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    GlobalClient.this.setPlayerOffline(server, uuid);
                                }
                            });
                            break;
                        }
                        case DATA: {
                            int dataSize;
                            final String server = this.dis.readUTF();
                            final String channel = this.dis.readUTF();
                            byte flags = this.dis.readByte();
                            UUID targetUuid = null;
                            if ((flags & 1) != 0) {
                                long mostSigBits = this.dis.readLong();
                                long leastSigBits = this.dis.readLong();
                                targetUuid = new UUID(mostSigBits, leastSigBits);
                            }
                            String targetServer = null;
                            if ((flags & 2) != 0) {
                                targetServer = this.dis.readUTF();
                            }
                            if ((dataSize = this.dis.readInt()) > 10000000 || dataSize < 0) {
                                throw new IOException("Oversized data packet received from '" + GlobalClient.this.account + "' from " + this.socket.getInetAddress().getHostAddress() + " (" + dataSize + " bytes).");
                            }
                            final byte[] data = new byte[dataSize];
                            this.dis.readFully(data);
                            final UUID finalTargetUuid = targetUuid;
                            final String finalTargetServer = targetServer;
                            GlobalClient.this.runInMainThread(new Runnable(){

                                @Override
                                public void run() {
                                    GlobalServer source = GlobalClient.this.getServer(server);
                                    GlobalPlayer targetPlayer = finalTargetUuid == null ? null : GlobalClient.this.getPlayer(finalTargetUuid);
                                    GlobalServer targetServer = finalTargetServer == null ? null : GlobalClient.this.getServer(finalTargetServer);
                                    GlobalClient.this.processData(source, channel, targetPlayer, targetServer, data);
                                }
                            });
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    if (e instanceof ConnectException) {
                        GlobalClient.this.logger.severe("Could not connect to the server!");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    } else if (GlobalClient.this.running || !(e instanceof SocketException)) {
                        if ("Connection reset".equals(e.getMessage()) || e instanceof EOFException) {
                            GlobalClient.this.logger.warning("Lost connection to the server!");
                        } else {
                            GlobalClient.this.logger.log(Level.SEVERE, "Exception while reading from the server", e);
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.socket = null;
                    }
                    this.dis = null;
                    GlobalClient.this.runInMainThread(new Runnable(){

                        @Override
                        public void run() {
                            ClientThread.this.dos = null;
                            ClientThread.this.clearServersAndPlayers();
                        }
                    });
                }
                catch (NoSuchAlgorithmException e) {
                    throw new Error(e);
                }
            }
        }

        protected synchronized void sendClientsFromThisServer(DataOutputStream dos) {
            this.dos = dos;
            for (GlobalServer s : GlobalClient.this.servers.values()) {
                if (!s.getName().equals(GlobalClient.this.account)) continue;
                for (GlobalPlayer p : s.getPlayers()) {
                    GlobalClient.this.sendPlayerOnline(p.getUniqueId(), p.getName(), p.getJoinTime(s));
                }
            }
        }

        protected synchronized void clearServersAndPlayers() {
            for (GlobalServer s : new ArrayList(GlobalClient.this.servers.values())) {
                if (s.getName().equals(GlobalClient.this.account)) continue;
                GlobalClient.this.setServerOffine(s.getName());
            }
        }

        private synchronized void sendPong() {
            DataOutputStream dos = this.dos;
            if (dos != null) {
                try {
                    dos.writeByte(ClientPacketType.PONG.ordinal());
                }
                catch (Exception e) {
                    GlobalClient.this.logger.log(Level.SEVERE, "Exception sending pong!", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Socket localSocket = this.socket;
            if (localSocket != null) {
                ClientThread clientThread = this;
                synchronized (clientThread) {
                    DataOutputStream dos = this.dos;
                    if (dos != null) {
                        try {
                            dos.writeByte(ClientPacketType.SERVER_OFFLINE.ordinal());
                        }
                        catch (Exception e) {
                            GlobalClient.this.logger.log(Level.SEVERE, "Exception sending server offline!", e);
                        }
                    }
                }
                try {
                    localSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }
    }
}

