/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.GlobalClient;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.cubeside.connection.event.GlobalDataEvent;
import de.cubeside.connection.event.GlobalPlayerDisconnectedEvent;
import de.cubeside.connection.event.GlobalPlayerJoinedEvent;
import de.cubeside.connection.event.GlobalServerConnectedEvent;
import de.cubeside.connection.event.GlobalServerDisconnectedEvent;
import java.util.ArrayDeque;
import java.util.logging.Level;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class GlobalClientBungee
extends GlobalClient
implements Listener {
    private final GlobalClientPlugin plugin;
    private boolean stoppingServer;
    protected final ArrayDeque<Runnable> tasks = new ArrayDeque();
    protected final Object sync = new Object();
    protected boolean running = true;

    public GlobalClientBungee(GlobalClientPlugin connectionPlugin) {
        super(connectionPlugin.getLogger());
        this.plugin = connectionPlugin;
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, (Runnable)new MainThread());
        this.plugin.getProxy().getPluginManager().registerListener((Plugin)this.plugin, (Listener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(Runnable r) {
        Object object = this.sync;
        synchronized (object) {
            boolean wasEmpty = this.tasks.isEmpty();
            this.tasks.addLast(r);
            if (wasEmpty) {
                this.sync.notifyAll();
            }
        }
    }

    public void setServer(final String host, final int port, final String account, final String password) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                GlobalClientBungee.super.setServer(host, port, account, password);
                for (ProxiedPlayer p : GlobalClientBungee.this.plugin.getProxy().getPlayers()) {
                    GlobalClientBungee.this.onPlayerOnline(p.getUniqueId(), p.getName(), System.currentTimeMillis());
                }
            }
        });
    }

    protected void runInMainThread(Runnable r) {
        if (!this.stoppingServer) {
            this.schedule(r);
        }
    }

    protected void processData(GlobalServer source, String channel, GlobalPlayer targetPlayer, GlobalServer targetServer, byte[] data) {
        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalDataEvent(source, targetPlayer, channel, data));
    }

    @EventHandler
    public void onPlayerJoin(PostLoginEvent e) {
        final ProxiedPlayer p = e.getPlayer();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                GlobalPlayer existing = GlobalClientBungee.this.getPlayer(p.getUniqueId());
                if (existing == null || !existing.isOnServer(GlobalClientBungee.this.getThisServer())) {
                    GlobalClientBungee.this.onPlayerOnline(p.getUniqueId(), p.getName(), System.currentTimeMillis());
                }
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerDisconnectEvent e) {
        final ProxiedPlayer p = e.getPlayer();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                GlobalPlayer existing = GlobalClientBungee.this.getPlayer(p.getUniqueId());
                if (existing != null && existing.isOnServer(GlobalClientBungee.this.getThisServer())) {
                    GlobalClientBungee.this.onPlayerOffline(p.getUniqueId());
                }
            }
        });
    }

    protected void onPlayerJoined(GlobalServer server, GlobalPlayer player, boolean joinedTheNetwork) {
        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalPlayerJoinedEvent(server, player, joinedTheNetwork));
    }

    protected void onPlayerDisconnected(GlobalServer server, GlobalPlayer player, boolean leftTheNetwork) {
        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalPlayerDisconnectedEvent(server, player, leftTheNetwork));
    }

    protected void onServerConnected(GlobalServer server) {
        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalServerConnectedEvent(server));
    }

    protected void onServerDisconnected(GlobalServer server) {
        this.plugin.getProxy().getPluginManager().callEvent((Event)new GlobalServerDisconnectedEvent(server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stoppingServer = true;
        super.shutdown();
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            this.sync.notifyAll();
        }
    }

    private class MainThread
    implements Runnable {
        private MainThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable task = null;
            while (true) {
                Object object = GlobalClientBungee.this.sync;
                synchronized (object) {
                    task = GlobalClientBungee.this.tasks.pollFirst();
                    if (task == null) {
                        if (GlobalClientBungee.this.running) {
                            try {
                                GlobalClientBungee.this.sync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            return;
                        }
                    }
                }
                if (task == null) continue;
                try {
                    task.run();
                    continue;
                }
                catch (Throwable t) {
                    GlobalClientBungee.this.plugin.getLogger().log(Level.SEVERE, "Exception in Client thread", t);
                    continue;
                }
                break;
            }
        }
    }
}

