/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import com.google.common.base.Preconditions;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.PlayerMessageAPI;
import de.cubeside.connection.event.GlobalDataEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

class PlayerMessageImplementation
implements PlayerMessageAPI,
Listener {
    private static final int MESSAGE_CHAT = 1;
    private static final int MESSAGE_CHAT_COMPONENT = 2;
    private static final int MESSAGE_ACTION_BAR = 3;
    private static final int MESSAGE_TITLE = 4;
    private static final int MESSAGE_ACTION_BAR_COMPONENT = 5;
    private static final int MESSAGE_TITLE_COMPONENT = 6;
    private GlobalClientPlugin plugin;
    private static final String CHANNEL = "GlobalClient.chat";

    public PlayerMessageImplementation(GlobalClientPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onGlobalData(GlobalDataEvent e) {
        if (e.getChannel().equals(CHANNEL)) {
            DataInputStream dis = new DataInputStream(e.getData());
            try {
                Player player;
                GlobalPlayer target = e.getTargetPlayer();
                if (target != null && (player = this.plugin.getServer().getPlayer(target.getUniqueId())) != null) {
                    byte type = dis.readByte();
                    if (type == 1) {
                        String message = dis.readUTF();
                        player.sendMessage(message);
                    } else if (type == 2) {
                        Component message = JSONComponentSerializer.json().deserialize((Object)dis.readUTF());
                        player.sendMessage(message);
                    } else if (type == 3) {
                        String message = dis.readUTF();
                        player.sendActionBar((Component)LegacyComponentSerializer.legacySection().deserialize(message));
                    } else if (type == 4) {
                        byte flags = dis.readByte();
                        String title = (flags & 1) != 0 ? dis.readUTF() : null;
                        String subtitle = (flags & 2) != 0 ? dis.readUTF() : null;
                        int fadeInTicks = dis.readInt();
                        int durationTicks = dis.readInt();
                        int fadeOutTicks = dis.readInt();
                        TextComponent titleComponent = LegacyComponentSerializer.legacySection().deserialize(title == null || title.isEmpty() ? " " : title);
                        TextComponent subtitleComponent = LegacyComponentSerializer.legacySection().deserialize(subtitle == null || subtitle.isEmpty() ? " " : subtitle);
                        Title titleToSend = Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeInTicks * 50), (Duration)Duration.ofMillis(durationTicks * 50), (Duration)Duration.ofMillis(fadeOutTicks * 50)));
                        player.showTitle(titleToSend);
                    } else if (type == 5) {
                        Component message = JSONComponentSerializer.json().deserialize((Object)dis.readUTF());
                        player.sendActionBar(message);
                    } else if (type == 6) {
                        String title = dis.readUTF();
                        String subtitle = dis.readUTF();
                        int fadeInTicks = dis.readInt();
                        int durationTicks = dis.readInt();
                        int fadeOutTicks = dis.readInt();
                        Component titleComponent = JSONComponentSerializer.json().deserialize((Object)title);
                        Component subtitleComponent = JSONComponentSerializer.json().deserialize((Object)subtitle);
                        Title titleToSend = Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeInTicks * 50), (Duration)Duration.ofMillis(durationTicks * 50), (Duration)Duration.ofMillis(fadeOutTicks * 50)));
                        player.showTitle(titleToSend);
                    }
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not parse PlayerMessage message", ex);
            }
        }
    }

    @Override
    @Deprecated
    public void sendMessage(GlobalPlayer player, String message) {
        this.sendActionBarMessage(player, (Component)LegacyComponentSerializer.legacySection().deserialize(message));
    }

    @Override
    @Deprecated
    public void sendMessage(GlobalPlayer player, BaseComponent ... message) {
        this.sendActionBarMessage(player, JSONComponentSerializer.json().deserialize((Object)ComponentSerializer.toString((BaseComponent[])message)));
    }

    @Override
    @Deprecated
    public void sendActionBarMessage(GlobalPlayer player, String message) {
        this.sendActionBarMessage(player, (Component)LegacyComponentSerializer.legacySection().deserialize(message));
    }

    @Override
    @Deprecated
    public void sendTitleBarMessage(GlobalPlayer player, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        TextComponent titleComponent = title == null ? Component.empty() : LegacyComponentSerializer.legacySection().deserialize(title);
        TextComponent subtitleComponent = subtitle == null ? Component.empty() : LegacyComponentSerializer.legacySection().deserialize(subtitle);
        this.sendTitleBarMessage(player, (Component)titleComponent, (Component)subtitleComponent, fadeInTicks, durationTicks, fadeOutTicks);
    }

    @Override
    public void sendMessage(GlobalPlayer player, Component message) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(2);
            dos.writeUTF((String)JSONComponentSerializer.json().serialize(message));
            dos.close();
        }
        catch (IOException ex) {
            throw new Error("impossible");
        }
        player.sendData(CHANNEL, baos.toByteArray());
        Player p = this.plugin.getServer().getPlayer(player.getUniqueId());
        if (p != null) {
            p.sendMessage(message);
        }
    }

    @Override
    public void sendActionBarMessage(GlobalPlayer player, Component message) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(5);
            dos.writeUTF((String)JSONComponentSerializer.json().serialize(message));
            dos.close();
        }
        catch (IOException ex) {
            throw new Error("impossible");
        }
        player.sendData(CHANNEL, baos.toByteArray());
        Player p = this.plugin.getServer().getPlayer(player.getUniqueId());
        if (p != null) {
            p.sendActionBar(message);
        }
    }

    @Override
    public void sendTitleBarMessage(GlobalPlayer player, Component title, Component subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)title, (Object)"title");
        Preconditions.checkNotNull((Object)subtitle, (Object)"subtitle");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(6);
            dos.writeUTF((String)JSONComponentSerializer.json().serialize(title));
            dos.writeUTF((String)JSONComponentSerializer.json().serialize(subtitle));
            dos.writeInt(fadeInTicks);
            dos.writeInt(durationTicks);
            dos.writeInt(fadeOutTicks);
            dos.close();
        }
        catch (IOException ex) {
            throw new Error("impossible");
        }
        player.sendData(CHANNEL, baos.toByteArray());
        Player p = this.plugin.getServer().getPlayer(player.getUniqueId());
        if (p != null) {
            Title titleToSend = Title.title((Component)title, (Component)subtitle, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeInTicks * 50), (Duration)Duration.ofMillis(durationTicks * 50), (Duration)Duration.ofMillis(fadeOutTicks * 50)));
            p.showTitle(titleToSend);
        }
    }
}

