/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import com.google.common.base.Preconditions;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.cubeside.connection.event.GlobalDataEvent;
import de.cubeside.connection.event.GlobalPlayerDisconnectedEvent;
import de.cubeside.connection.event.GlobalPlayerPropertyChangedEvent;
import de.cubeside.connection.event.GlobalServerConnectedEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

class PlayerPropertiesImplementation
implements PlayerPropertiesAPI,
Listener {
    private static final int MESSAGE_SET_PROPERTY = 1;
    private static final int MESSAGE_DELETE_PROPERTY = 2;
    private static final int MESSAGE_MULTISET_PROPERTIES = 3;
    private final GlobalClientPlugin plugin;
    private static final String CHANNEL = "GlobalClient.playerProperties";
    private final HashMap<UUID, HashMap<String, String>> playerProperties;

    public PlayerPropertiesImplementation(GlobalClientPlugin plugin) {
        this.plugin = plugin;
        this.playerProperties = new HashMap();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onGlobalPlayerDisconnected(GlobalPlayerDisconnectedEvent e) {
        if (e.hasJustLeftTheNetwork()) {
            this.playerProperties.remove(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void onGlobalServerConnected(GlobalServerConnectedEvent e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(3);
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                UUID uuid = p.getUniqueId();
                HashMap<String, String> properties = this.playerProperties.get(uuid);
                if (properties == null) continue;
                dos.writeBoolean(true);
                dos.writeLong(uuid.getMostSignificantBits());
                dos.writeLong(uuid.getLeastSignificantBits());
                dos.writeInt(properties.size());
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    dos.writeUTF(entry.getKey());
                    dos.writeUTF(entry.getValue());
                }
            }
            dos.writeBoolean(false);
            dos.close();
        }
        catch (IOException ex) {
            throw new Error("impossible");
        }
        e.getServer().sendData(CHANNEL, baos.toByteArray());
    }

    @EventHandler
    public void onGlobalData(GlobalDataEvent e) {
        if (e.getChannel().equals(CHANNEL)) {
            DataInputStream dis = new DataInputStream(e.getData());
            try {
                byte type = dis.readByte();
                if (type == 1) {
                    UUID uuid = this.readUUID(dis);
                    GlobalPlayer target = this.plugin.getConnectionAPI().getPlayer(uuid);
                    String property = dis.readUTF();
                    String value = dis.readUTF();
                    HashMap<String, String> properties = this.playerProperties.get(uuid);
                    if (properties == null) {
                        properties = new HashMap();
                        this.playerProperties.put(uuid, properties);
                    }
                    properties.put(property, value);
                    this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(e.getSource(), target, property, value));
                } else if (type == 2) {
                    UUID uuid = this.readUUID(dis);
                    GlobalPlayer target = this.plugin.getConnectionAPI().getPlayer(uuid);
                    String property = dis.readUTF();
                    HashMap<String, String> properties = this.playerProperties.get(uuid);
                    if (properties != null) {
                        properties.remove(property);
                        if (properties.isEmpty()) {
                            this.playerProperties.remove(uuid);
                        }
                        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(e.getSource(), target, property, null));
                    }
                } else if (type == 3) {
                    while (dis.readBoolean()) {
                        UUID uuid = this.readUUID(dis);
                        GlobalPlayer target = this.plugin.getConnectionAPI().getPlayer(uuid);
                        int propertiesCount = dis.readInt();
                        if (propertiesCount <= 0) continue;
                        HashMap<String, String> properties = this.playerProperties.get(uuid);
                        if (properties == null) {
                            properties = new HashMap();
                            this.playerProperties.put(uuid, properties);
                        }
                        for (int i = 0; i < propertiesCount; ++i) {
                            String property = dis.readUTF();
                            String value = dis.readUTF();
                            properties.put(property, value);
                            this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(e.getSource(), target, property, null));
                        }
                    }
                }
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not parse PlayerProperties message", ex);
            }
        }
    }

    private UUID readUUID(DataInputStream dis) throws IOException {
        long msb = dis.readLong();
        long lsb = dis.readLong();
        return new UUID(msb, lsb);
    }

    @Override
    public boolean hasProperty(GlobalPlayer player, String property) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)property, (Object)"property");
        HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
        return properties != null && properties.containsKey(property);
    }

    @Override
    public String getPropertyValue(GlobalPlayer player, String property) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)property, (Object)"property");
        HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
        return properties == null ? null : properties.get(property);
    }

    @Override
    public Map<String, String> getAllProperties(GlobalPlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
        return properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    @Override
    public void setPropertyValue(GlobalPlayer player, String property, String value) {
        Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"not on main thread!");
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)property, (Object)"property");
        Preconditions.checkArgument((boolean)player.isOnAnyServer(), (Object)"player is not online");
        HashMap<String, String> properties = this.playerProperties.get(player.getUniqueId());
        if (value == null) {
            if (properties != null && properties.remove(property) != null) {
                if (properties.isEmpty()) {
                    this.playerProperties.remove(player.getUniqueId());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                try {
                    dos.writeByte(2);
                    dos.writeLong(player.getUniqueId().getMostSignificantBits());
                    dos.writeLong(player.getUniqueId().getLeastSignificantBits());
                    dos.writeUTF(property);
                    dos.close();
                }
                catch (IOException ex) {
                    throw new Error("impossible");
                }
                this.plugin.getConnectionAPI().sendData(CHANNEL, baos.toByteArray());
            }
        } else {
            if (properties == null) {
                properties = new HashMap();
                this.playerProperties.put(player.getUniqueId(), properties);
            }
            properties.put(property, value);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeByte(1);
                dos.writeLong(player.getUniqueId().getMostSignificantBits());
                dos.writeLong(player.getUniqueId().getLeastSignificantBits());
                dos.writeUTF(property);
                dos.writeUTF(value);
                dos.close();
            }
            catch (IOException ex) {
                throw new Error("impossible");
            }
            this.plugin.getConnectionAPI().sendData(CHANNEL, baos.toByteArray());
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalPlayerPropertyChangedEvent(this.plugin.getConnectionAPI().getThisServer(), player, property, value));
    }
}

